/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.math.sequence;

import java.util.Map;
import java.util.WeakHashMap;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.Procedure;
import net.morilib.lisp.Scheme;
import net.morilib.lisp.math.sequence.AbstractLispRealSequence;
import net.morilib.lisp.subr.SubrUtils;

public class LispRecurrenceRelationSequence
extends AbstractLispRealSequence {
    public static final int INFINITE = -1;
    private Procedure recur;
    private Environment env;
    private LispMessage mesg;
    private LispReal[] init;
    private int size;
    private transient Map<Integer, LispReal> memo = new WeakHashMap<Integer, LispReal>();

    public LispRecurrenceRelationSequence(Procedure recur, Environment env, LispMessage mesg, int size, LispReal ... reals) {
        this.recur = recur;
        this.env = env;
        this.mesg = mesg;
        this.size = size;
        this.init = new LispReal[reals.length];
        System.arraycopy(reals, 0, this.init, 0, reals.length);
    }

    private LispReal _get(int i) {
        if (i < 1) {
            throw new IndexOutOfBoundsException();
        }
        if (i <= this.init.length) {
            return this.init[i - 1];
        }
        return this.memo.get(i);
    }

    @Override
    public LispReal get(int i) {
        Datum[] args = new LispReal[this.init.length];
        if (i > this.size) {
            return LispInteger.ZERO;
        }
        LispReal r = this._get(i);
        if (r == null) {
            int j = this.init.length + 1;
            while (j <= i) {
                r = this._get(j);
                if (r == null) {
                    int k = 1;
                    while (k <= args.length) {
                        args[k - 1] = this._get(j - k);
                        ++k;
                    }
                    Datum d = Scheme.callva(this.recur, this.env, this.mesg, args);
                    r = SubrUtils.getReal(d, this.mesg);
                    this.memo.put(j, r);
                }
                ++j;
            }
        }
        return r;
    }

    @Override
    public LispReal limit() {
        return this.size < 0 ? null : LispInteger.ZERO;
    }

    @Override
    public boolean isFinite() {
        return this.size >= 1;
    }

    @Override
    public int size() {
        return this.size;
    }
}

