/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.math.sequence;

import java.math.BigInteger;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.math.sequence.AbstractLispRealSequence;
import net.morilib.lisp.math.sequence.ILispRealSequence;
import net.morilib.lisp.math.sequence.LispRealConstantSequence;

public class LispRatio2GeometricSequence
extends AbstractLispRealSequence {
    private BigInteger a1;
    private int size;

    private LispRatio2GeometricSequence(BigInteger a1, int size) {
        this.a1 = a1;
        this.size = size;
    }

    public LispRatio2GeometricSequence(LispInteger a1, int size) {
        this(a1.getBigInteger(), size);
    }

    @Override
    public LispReal get(int i) {
        if (i < 1) {
            throw new IndexOutOfBoundsException();
        }
        return i <= this.size ? LispInteger.valueOf(this.a1.shiftLeft(i - 1)) : LispInteger.ZERO;
    }

    @Override
    public LispReal limit() {
        return this.size < 0 ? LispDouble.POSITIVE_INFINITY : LispInteger.ZERO;
    }

    @Override
    public boolean isFinite() {
        return this.size >= 1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public ILispRealSequence difference() {
        if (this.size > 1) {
            return new LispRatio2GeometricSequence(this.a1, this.size - 1);
        }
        if (this.size < 0) {
            return new LispRatio2GeometricSequence(this.a1, this.size);
        }
        return new LispRealConstantSequence(LispInteger.ZERO, -1);
    }

    @Override
    public LispReal sum(int start, int end) {
        if (start < 1) {
            throw new IllegalArgumentException();
        }
        if (end < 1) {
            throw new IllegalArgumentException();
        }
        if (start > end) {
            throw new IllegalArgumentException();
        }
        BigInteger x = this.a1.multiply(BigInteger.ONE.pow(end).subtract(BigInteger.ONE.pow(start + 1)));
        x = x.negate();
        return LispInteger.valueOf(x);
    }

    @Override
    public LispReal sum() {
        if (this.isFinite()) {
            return this.sum(1, this.size());
        }
        if (this.a1.signum() > 0) {
            return LispDouble.POSITIVE_INFINITY;
        }
        return LispDouble.NEGATIVE_INFINITY;
    }
}

