/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.math.sequence;

import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.math.sequence.AbstractLispRealSequence;
import net.morilib.lisp.math.sequence.ILispRealSequence;
import net.morilib.lisp.math.sequence.LispRealConstantSequence;

public class LispGeometricSequence
extends AbstractLispRealSequence {
    public static final int INFINITE = -1;
    private LispReal a1;
    private LispReal r;
    private int size;

    public LispGeometricSequence(LispReal a1, LispReal r, int size) {
        if (a1 == null || r == null) {
            throw new NullPointerException();
        }
        if (a1.signum() == 0) {
            throw new IllegalArgumentException();
        }
        this.a1 = a1;
        this.r = r;
        this.size = size;
    }

    @Override
    public LispReal get(int i) {
        if (i < 1) {
            throw new IndexOutOfBoundsException();
        }
        return this.a1.multiply((LispReal)this.r.power(i - 1));
    }

    @Override
    public LispReal limit() {
        if (this.size >= 1) {
            return LispInteger.ZERO;
        }
        if (this.r.abs().compareTo(LispInteger.ONE) < 0) {
            return LispInteger.ZERO;
        }
        int c = this.r.compareTo(LispInteger.ONE);
        if (c == 0) {
            return this.r;
        }
        if (c < 0) {
            return LispDouble.NaN;
        }
        if (this.a1.signum() > 0) {
            return LispDouble.POSITIVE_INFINITY;
        }
        return LispDouble.NEGATIVE_INFINITY;
    }

    @Override
    public boolean isFinite() {
        return this.size >= 1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public ILispRealSequence difference() {
        if (this.size > 1) {
            return new LispGeometricSequence(this.a1.multiply(this.r.subtract(LispInteger.ONE)), this.r, this.size - 1);
        }
        if (this.size < 0) {
            return new LispGeometricSequence(this.a1.multiply(this.r.subtract(LispInteger.ONE)), this.r, this.size);
        }
        return new LispRealConstantSequence(LispInteger.ZERO, -1);
    }

    @Override
    public LispReal sum(int start, int end) {
        if (start < 1) {
            throw new IllegalArgumentException();
        }
        if (end < 1) {
            throw new IllegalArgumentException();
        }
        if (start > end) {
            throw new IllegalArgumentException();
        }
        LispReal x = this.a1.multiply(((LispReal)this.r.power(end - 1)).subtract((LispReal)this.r.power(start)));
        x = x.divide(LispInteger.ONE.subtract(this.r));
        return x;
    }

    @Override
    public LispReal sum() {
        if (this.isFinite()) {
            return this.sum(1, this.size());
        }
        if (this.r.abs().compareTo(LispInteger.ONE) < 0) {
            return this.r.divide(LispInteger.ONE.subtract(this.r));
        }
        if (this.r.compareTo(LispInteger.ONE) < 0) {
            return LispDouble.NaN;
        }
        if (this.a1.signum() > 0) {
            return LispDouble.POSITIVE_INFINITY;
        }
        return LispDouble.NEGATIVE_INFINITY;
    }
}

