/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.math.sequence;

import net.morilib.lisp.LispComplex;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMath;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.math.sequence.AbstractLispRealSequence;

public class Lisp2OrderLRS
extends AbstractLispRealSequence {
    public Lisp2OrderLRS FIBONACCI = new Lisp2OrderLRS(LispInteger.ONE, LispInteger.ONE, LispInteger.ONE, LispInteger.ONE);
    private static final LispReal TWO = LispInteger.valueOf(2);
    private LispComplex[] roots;
    private LispNumber a;
    private LispNumber b;

    public Lisp2OrderLRS(LispReal p, LispReal q, LispReal a1, LispReal a2) {
        this.roots = LispMath.solveQuadratic(LispInteger.ONE, p.negate(), q.negate());
        if (this.roots.length == 2) {
            LispComplex ab = (LispComplex)this.roots[0].sub(this.roots[1]);
            this.a = a2.sub(a1.mul(this.roots[1])).div(this.roots[0].mul(ab));
            this.b = this.roots[0].mul(a1).sub(a2).div(this.roots[1].mul(ab));
        } else {
            LispNumber aq = this.roots[0].mul(this.roots[0]);
            this.a = this.roots[0].mul(a1).mul(TWO).div(aq);
            this.b = a2.sub(a1).div(aq);
        }
    }

    @Override
    public LispReal get(int i) {
        if (i < 1) {
            throw new IndexOutOfBoundsException();
        }
        if (this.roots.length == 2) {
            return this.a.mul(this.roots[0].pow(i)).add(this.b.mul(this.roots[1].pow(i))).getReal();
        }
        return this.a.mul(this.roots[0].pow(i)).add(this.b.mul(this.roots[0].pow(i).mul(LispInteger.valueOf(i)))).getReal();
    }

    @Override
    public LispReal limit() {
        return null;
    }

    @Override
    public boolean isFinite() {
        return false;
    }

    @Override
    public int size() {
        return -1;
    }
}

