/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.math.random;

import java.util.Iterator;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Subr;
import net.morilib.lisp.math.random.ILispRandomSource;
import net.morilib.lisp.subr.NoArgs;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.math.random.RandomSource;
import net.morilib.util.Iterators;

public class RandomSourceMakeReals
extends Subr {
    private static final String PROCN = "random-real generated random-source-make-integers";

    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        Datum c1a = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        Datum ud = Iterators.nextIf(itr);
        double u = 1.0;
        SubrUtils.checkTerminated(itr, body, mesg);
        if (ud != null && ((u = SubrUtils.getDouble(ud, mesg)) < 0.0 || u > 1.0)) {
            throw mesg.getError("err.srfi27.unit.invalid", ud);
        }
        if (c1a instanceof ILispRandomSource) {
            return new RandReal(((ILispRandomSource)((Object)c1a)).getRandomSource(), u);
        }
        throw mesg.getError("err.srfi27.require.randomsource", c1a);
    }

    private class RandReal
    extends NoArgs {
        private RandomSource src;
        private double unit;

        private RandReal(RandomSource src, double unit) {
            super(RandomSourceMakeReals.PROCN);
            this.src = src;
            this.unit = unit;
        }

        @Override
        protected Datum execute(Environment env, LispMessage mesg) {
            return new LispDouble(this.src.nextDouble3() * this.unit);
        }
    }
}

