/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.math.matrix;

import java.util.Iterator;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.Subr;
import net.morilib.lisp.math.matrix.ILispMatrix;
import net.morilib.lisp.math.matrix.ILispNumberVector;
import net.morilib.lisp.math.matrix.LispMatrixException;
import net.morilib.lisp.subr.SubrUtils;

public class MatrixMul
extends Subr {
    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        Datum r = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        if (r instanceof LispNumber) {
            Datum x = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            SubrUtils.checkTerminated(itr, body, mesg);
            if (x instanceof ILispMatrix) {
                return (Datum)((Object)((ILispMatrix)((Object)x)).mul((LispNumber)r));
            }
            if (r instanceof ILispNumberVector) {
                return (Datum)((Object)((ILispNumberVector)((Object)x)).mul((LispNumber)r));
            }
            throw mesg.getError("err.matrix.require.numbermatrix", x);
        }
        if (r instanceof ILispMatrix) {
            ILispMatrix m = (ILispMatrix)((Object)r);
            while (itr.hasNext()) {
                Datum x = itr.next();
                if (x instanceof ILispMatrix) {
                    try {
                        m = m.mul((ILispMatrix)((Object)x));
                        continue;
                    }
                    catch (LispMatrixException e) {
                        throw mesg.getError("err.matrix.require.multipliable", x);
                    }
                }
                if (x instanceof ILispNumberVector) {
                    SubrUtils.checkTerminated(itr, body, mesg);
                    try {
                        return (Datum)((Object)m.mul((ILispNumberVector)((Object)x)));
                    }
                    catch (LispMatrixException e) {
                        throw mesg.getError("err.matrix.require.multipliable", x);
                    }
                }
                throw mesg.getError("err.matrix.require.numbermatrix", x);
            }
            SubrUtils.checkTerminated(itr, body, mesg);
            return (Datum)((Object)m);
        }
        throw mesg.getError("err.matrix.require.numbermatrix", r);
    }
}

