/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.math.angle;

import net.morilib.lisp.Datum2;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.math.angle.ILispAngle;
import net.morilib.lisp.math.constants.LispPi;

public class LispAngleGrade
extends Datum2
implements ILispAngle {
    static final LispInteger RIGHT_ANGLE = LispInteger.valueOf(100);
    static final LispInteger STRAIGHT_ANGLE = LispInteger.valueOf(200);
    static final LispInteger FULL_ANGLE = LispInteger.valueOf(400);
    private LispReal angle;

    public LispAngleGrade(LispReal a) {
        this.angle = a.remainder(FULL_ANGLE);
    }

    @Override
    public ILispAngle add(ILispAngle y) {
        return new LispAngleGrade(this.angle.add(y.byGrade()));
    }

    @Override
    public ILispAngle sub(ILispAngle y) {
        return new LispAngleGrade(this.angle.subtract(y.byGrade()));
    }

    @Override
    public ILispAngle uminus() {
        return new LispAngleGrade(this.angle.uminus());
    }

    @Override
    public ILispAngle mul(LispNumber x) {
        if (x instanceof LispReal) {
            return new LispAngleGrade(this.angle.multiply((LispReal)x));
        }
        throw new IllegalArgumentException();
    }

    @Override
    public LispReal byRadian() {
        return this.angle.divide(STRAIGHT_ANGLE).multiply(LispPi.PI);
    }

    @Override
    public LispReal byDegree() {
        return (LispReal)this.angle.divide(STRAIGHT_ANGLE).multiply(180);
    }

    @Override
    public LispReal byGrade() {
        return this.angle;
    }

    @Override
    public LispReal sin() {
        return new LispDouble(Math.sin(this.angle.doubleValue() / 200.0 * Math.PI));
    }

    @Override
    public LispReal cos() {
        return new LispDouble(Math.cos(this.angle.doubleValue() / 200.0 * Math.PI));
    }

    @Override
    public LispReal tan() {
        return new LispDouble(Math.tan(this.angle.doubleValue() / 200.0 * Math.PI));
    }

    @Override
    public LispReal cot() {
        return new LispDouble(1.0 / Math.tan(this.angle.doubleValue() / 200.0 * Math.PI));
    }

    @Override
    public LispReal sec() {
        return new LispDouble(1.0 / Math.cos(this.angle.doubleValue() / 200.0 * Math.PI));
    }

    @Override
    public LispReal cosec() {
        return new LispDouble(1.0 / Math.sin(this.angle.doubleValue() / 200.0 * Math.PI));
    }

    @Override
    public boolean isAcute() {
        return this.angle.compareTo(RIGHT_ANGLE) < 0;
    }

    @Override
    public boolean isRight() {
        return this.angle.isEqualTo(RIGHT_ANGLE);
    }

    @Override
    public boolean isObtuse() {
        return this.angle.compareTo(RIGHT_ANGLE) > 0 && this.angle.compareTo(STRAIGHT_ANGLE) < 0;
    }

    @Override
    public boolean isStraight() {
        return this.angle.isEqualTo(STRAIGHT_ANGLE);
    }

    @Override
    public boolean isReflex() {
        return this.angle.compareTo(STRAIGHT_ANGLE) > 0;
    }

    @Override
    public boolean isSinExact() {
        return false;
    }

    @Override
    public boolean isCosExact() {
        return false;
    }

    @Override
    public boolean isTanExact() {
        return false;
    }

    @Override
    public boolean isExact() {
        return this.angle.isExact();
    }

    @Override
    public ILispAngle toExact() {
        return new LispAngleGrade(this.angle.toExact());
    }

    @Override
    public ILispAngle toInexact() {
        return new LispAngleGrade(this.angle.toInexact());
    }

    @Override
    public int compareTo(ILispAngle o) {
        return this.angle.compareTo(o.byGrade());
    }

    @Override
    public boolean isEqualTo(ILispAngle x) {
        return this.angle.isEqualTo(x.byGrade());
    }

    public int hashCode() {
        return this.angle.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof ILispAngle) {
            return this.angle.isEqualTo(((ILispAngle)o).byGrade());
        }
        return false;
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append(LispUtils.print(this.angle)).append("#grad");
    }
}

