/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.math;

import java.math.BigInteger;
import java.util.Iterator;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispString;
import net.morilib.lisp.Subr;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.math.Math2;

public class RationalToDecimalString
extends Subr {
    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        Datum c1a = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        int radix = SubrUtils.nextSmallInt((Iterator<Datum>)itr, 10, mesg);
        BigInteger[] nd = SubrUtils.getRational(c1a, mesg);
        if (radix < 2 || radix > 36) {
            throw mesg.getError("err.radix.invalid", String.valueOf(radix));
        }
        return new LispString(Math2.toDecimalString(nd[0], nd[1], radix));
    }
}

