/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.lingua;

import java.util.Iterator;
import net.morilib.lingua.JapaneseUtils;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispString;
import net.morilib.lisp.Subr;
import net.morilib.lisp.subr.SubrUtils;

public class KanaToRomaji
extends Subr {
    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        String s = SubrUtils.nextString((Iterator<Datum>)itr, mesg, body);
        int f = 0;
        while (itr.hasNext()) {
            String fs = SubrUtils.getSymbolName(itr.next(), mesg);
            if (fs.equals("kunrei")) {
                f |= 1;
                continue;
            }
            if (fs.equals("dzu")) {
                f |= 2;
                continue;
            }
            if (fs.equals("oh")) {
                f |= 4;
                continue;
            }
            if (fs.equals("macron")) {
                f |= 8;
                continue;
            }
            if (fs.equals("circumflex")) {
                f |= 0x10;
                continue;
            }
            if (fs.equals("force-n")) {
                f |= 0x40;
                continue;
            }
            if (fs.equals("hyphen")) {
                f |= 0x80;
                continue;
            }
            if (!fs.equals("quote")) continue;
            f |= 0x20;
        }
        SubrUtils.checkTerminated(itr, body, mesg);
        try {
            return new LispString(JapaneseUtils.toRomaji(s, f));
        }
        catch (IllegalArgumentException e) {
            return LispBoolean.FALSE;
        }
    }
}

