/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.json;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import net.morilib.lisp.Cons;
import net.morilib.lisp.ConsListBuilder;
import net.morilib.lisp.Datum;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispString;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.LispVector;
import net.morilib.lisp.Nil;
import net.morilib.parser.json.JSONParseHandler;

public class JsonToListHandler
implements JSONParseHandler {
    public static final JsonToListHandler EXACT = new JsonToListHandler(true);
    public static final JsonToListHandler INEXACT = new JsonToListHandler(false);
    Stack<Object> stack = new Stack();
    private boolean exact;

    private JsonToListHandler(boolean exact) {
        this.exact = exact;
    }

    @Override
    public void begin() {
    }

    @Override
    public Object eof() {
        return this.stack.pop();
    }

    @Override
    public void beginArray() {
        this.stack.push(new ArrayList());
    }

    @Override
    public void beginObject() {
        this.stack.push(new ConsListBuilder());
    }

    @Override
    public void nextArray() {
        Datum o = (Datum)this.stack.pop();
        List l = (List)this.stack.peek();
        l.add(o);
    }

    @Override
    public void endArray() {
        Datum o = (Datum)this.stack.pop();
        List l = (List)this.stack.pop();
        l.add(o);
        this.stack.push(new LispVector(l));
    }

    @Override
    public void nextValue() {
    }

    @Override
    public void nextObject() {
        Datum v = (Datum)this.stack.pop();
        Datum k = (Datum)this.stack.pop();
        ConsListBuilder l = (ConsListBuilder)this.stack.peek();
        l.append(new Cons(k, v));
    }

    @Override
    public void endObject() {
        Datum v = (Datum)this.stack.pop();
        Datum k = (Datum)this.stack.pop();
        ConsListBuilder l = (ConsListBuilder)this.stack.pop();
        l.append(new Cons(k, v));
        this.stack.push(l.get());
    }

    @Override
    public void setString(String s) {
        this.stack.push(LispString.valueOf(s));
    }

    @Override
    public void setTrue() {
        this.stack.push(LispBoolean.TRUE);
    }

    @Override
    public void setFalse() {
        this.stack.push(LispBoolean.FALSE);
    }

    @Override
    public void setNull() {
        this.stack.push(Nil.NIL);
    }

    @Override
    public void setInteger(BigInteger x) {
        this.stack.push(LispInteger.valueOf(x));
    }

    @Override
    public void setFraction(BigDecimal x) {
        if (this.exact) {
            this.stack.push(LispUtils.bigDecimalToRational(x));
        } else {
            this.stack.push(new LispDouble(x.floatValue()));
        }
    }

    @Override
    public void emptyArray() {
        this.stack.pop();
        this.stack.push(new LispVector());
    }

    @Override
    public void emptyObject() {
        this.stack.pop();
        this.stack.push(Nil.NIL);
    }
}

