/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.iterator;

import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.iterator.ILispIterator;
import net.morilib.lisp.iterator.LispIteratorDatum;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.subr.TernaryArgs;

public class MakeRealNumberIterator
extends TernaryArgs {
    @Override
    protected Datum execute(Datum c1a, Datum c2a, Datum c3a, Environment env, LispMessage mesg) {
        final LispReal[] c = new LispReal[1];
        LispReal rb = SubrUtils.getReal(c1a, mesg);
        final LispReal re = SubrUtils.getReal(c2a, mesg);
        final LispReal st = SubrUtils.getReal(c3a, mesg);
        if (st.signum() * rb.compareTo(re) > 0) {
            throw mesg.getError("err.range.invalid");
        }
        c[0] = rb;
        return new LispIteratorDatum(){

            @Override
            public boolean isTerminated() {
                return st.signum() * c[0].compareTo(re) > 0;
            }

            @Override
            public ILispIterator next() {
                c[0] = c[0].add(st);
                return this;
            }

            @Override
            public Datum getCurrentDatum() {
                return c[0];
            }

            @Override
            public void toDisplayString(StringBuilder buf) {
                buf.append("#<real-number-iterator>");
            }
        };
    }
}

