/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.iterator;

import java.util.NoSuchElementException;
import net.morilib.lisp.ConsListBuilder;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.LispCharacter;
import net.morilib.lisp.iterator.ILispIterator;
import net.morilib.util.string.StringIterator;

public class LispStringGroupIterator
extends Datum2
implements ILispIterator {
    private StringIterator[] iterators;

    LispStringGroupIterator(StringIterator[] iterators) {
        this.iterators = iterators;
    }

    public LispStringGroupIterator(String ... strings) {
        this(LispStringGroupIterator._c(strings));
    }

    private static StringIterator[] _c(String[] strings) {
        StringIterator[] r = new StringIterator[strings.length];
        int i = 0;
        while (i < r.length) {
            r[i] = new StringIterator(strings[i]);
            ++i;
        }
        return r;
    }

    @Override
    public boolean isTerminated() {
        StringIterator[] stringIteratorArray = this.iterators;
        int n = this.iterators.length;
        int n2 = 0;
        while (n2 < n) {
            StringIterator itr = stringIteratorArray[n2];
            if (!itr.hasNext()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public ILispIterator next() {
        int i = 0;
        while (i < this.iterators.length) {
            if (!this.iterators[i].hasNext()) {
                throw new NoSuchElementException();
            }
            this.iterators[i].next();
            ++i;
        }
        return this;
    }

    @Override
    public Datum getCurrentDatum() {
        ConsListBuilder b = new ConsListBuilder();
        StringIterator[] stringIteratorArray = this.iterators;
        int n = this.iterators.length;
        int n2 = 0;
        while (n2 < n) {
            StringIterator itr = stringIteratorArray[n2];
            if (!itr.hasNext()) {
                throw new NoSuchElementException();
            }
            b.append(LispCharacter.valueOf(itr.peek()));
            ++n2;
        }
        return b.get();
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<string-group-iterator>");
    }
}

