/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.diff;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.morilib.diff.Change;
import net.morilib.diff.Diff;
import net.morilib.lang.EqualPredicate;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.ConsListBuilder;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Procedure;
import net.morilib.lisp.Scheme;
import net.morilib.lisp.Subr;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.subr.SubrUtils;

public class LcsEditList
extends Subr {
    static final EqualPredicate DEF_EQ = new EqualPredicate(){

        @Override
        public boolean isEqual(Object a, Object b) {
            return a != null ? a.equals(b) : b == null;
        }
    };
    private static final Symbol PL = Symbol.getSymbol("+");
    private static final Symbol MI = Symbol.getSymbol("-");

    private List<Object> tolist(Datum a) {
        ArrayList<Object> r = new ArrayList<Object>();
        ConsIterator i = new ConsIterator(a);
        while (i.hasNext()) {
            r.add(i.next());
        }
        return r;
    }

    private Datum changetolist(Change<Object> c) {
        ConsListBuilder b = new ConsListBuilder();
        switch (c.getOperation()) {
            case 2: {
                int i = 0;
                while (i < c.getAfter().size()) {
                    b.append(LispUtils.list(PL, LispInteger.valueOf(i + c.getBeginIndexA() - 1), c.getAfter().get(i)));
                    ++i;
                }
                return b.get();
            }
            case 3: {
                int i = 0;
                while (i < c.getBefore().size()) {
                    b.append(LispUtils.list(MI, LispInteger.valueOf(i + c.getBeginIndexA() - 1), c.getBefore().get(i)));
                    ++i;
                }
                return b.get();
            }
            case 1: {
                int i = 0;
                while (i < c.getBefore().size()) {
                    b.append(LispUtils.list(MI, LispInteger.valueOf(i + c.getBeginIndexA() - 1), c.getBefore().get(i)));
                    ++i;
                }
                i = 0;
                while (i < c.getAfter().size()) {
                    b.append(LispUtils.list(PL, LispInteger.valueOf(i + c.getBeginIndexB() - 1), c.getAfter().get(i)));
                    ++i;
                }
                return b.get();
            }
        }
        throw new RuntimeException();
    }

    @Override
    public Datum eval(Datum body, final Environment env, final LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        Datum a = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        Datum b = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        final Procedure p = SubrUtils.nextProcedureOptional(itr, mesg);
        ConsListBuilder bld = new ConsListBuilder();
        SubrUtils.checkTerminated(itr, body, mesg);
        List<Object> al = this.tolist(a);
        List<Object> bl = this.tolist(b);
        EqualPredicate eq = p == null ? DEF_EQ : new EqualPredicate(){

            @Override
            public boolean isEqual(Object a, Object b) {
                return Scheme.callva(p, env, mesg, (Datum)a, (Datum)b).isTrue();
            }
        };
        List<Change<Object>> r = Diff.diff(al, bl, eq);
        for (Change<Object> c : r) {
            bld.append(this.changetolist(c));
        }
        return bld.get();
    }
}

