/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.datetime;

import java.math.BigInteger;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.LispSmallInt;
import net.morilib.lisp.datetime.LispTime;
import net.morilib.lisp.subr.TernaryArgs;

public class MakeTime
extends TernaryArgs {
    @Override
    protected Datum execute(Datum c1a, Datum c2a, Datum c3a, Environment env, LispMessage mesg) {
        long sec;
        LispTime.TimeType tp = LispTime.SYM_TO_TYPE.get(c1a);
        if (!(c2a instanceof LispSmallInt)) {
            throw mesg.getError("err.require.smallint", c2a);
        }
        if (!(c3a instanceof LispNumber)) {
            throw mesg.getError("err.require.int", c3a);
        }
        if (tp == null) {
            throw mesg.getError("err.srfi19.invalidtimetype", c1a);
        }
        if (((LispNumber)c3a).isInteger()) {
            BigInteger bi = c3a.getBigInteger();
            sec = bi.compareTo(LispTime.MAX_LONG) > 0 ? Long.MAX_VALUE : (bi.compareTo(LispTime.MIN_LONG) < 0 ? Long.MIN_VALUE : bi.longValue());
        } else {
            throw mesg.getError("err.require.int", c3a);
        }
        return new LispTime(tp, sec, c2a.getInt());
    }
}

