/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.collection.hash;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.Map;
import net.morilib.lisp.Cons;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.ConsListBuilder;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.LispVector;
import net.morilib.lisp.Procedure;
import net.morilib.lisp.SExpressionDatum;
import net.morilib.lisp.Scheme;
import net.morilib.lisp.Subr;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.Undef;
import net.morilib.lisp.collection.LispBag;
import net.morilib.lisp.collection.LispCollection;
import net.morilib.lisp.collection.LispCollections;
import net.morilib.lisp.collection.LispMap;
import net.morilib.lisp.collection.hash.CharCiHash;
import net.morilib.lisp.collection.hash.CharHash;
import net.morilib.lisp.collection.hash.Hash;
import net.morilib.lisp.collection.hash.HashByIdentity;
import net.morilib.lisp.collection.hash.Hasv;
import net.morilib.lisp.collection.hash.StringCiHash;
import net.morilib.lisp.collection.hash.StringHash;
import net.morilib.lisp.r6rs.hash.ILispR6RSHashtable;
import net.morilib.lisp.subr.BinaryArgs;
import net.morilib.lisp.subr.CharCIEqual;
import net.morilib.lisp.subr.CharEqual;
import net.morilib.lisp.subr.IsEq;
import net.morilib.lisp.subr.IsEqual;
import net.morilib.lisp.subr.IsEqv;
import net.morilib.lisp.subr.StringCIEqual;
import net.morilib.lisp.subr.StringEqual;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.subr.TernaryArgs;
import net.morilib.lisp.subr.UnaryArgs;
import net.morilib.util.Iterators;

public class LispHash
extends Datum2
implements LispMap,
ILispR6RSHashtable {
    private static final Map<Datum, Datum> DEFHASH;
    public static final Procedure EQ;
    public static final Procedure EQV;
    public static final Procedure EQUAL;
    public static final Procedure EQ_HASH;
    public static final Procedure EQV_HASH;
    public static final Procedure EQUAL_HASH;
    private Map<Object, Datum> hashmap;
    private Procedure eqproc;
    private Procedure hashproc;
    private Environment activeenv;
    private LispMessage message;

    static {
        EQ = new IsEq();
        EQV = new IsEqv();
        EQUAL = new IsEqual();
        EQ_HASH = new HashByIdentity();
        EQV_HASH = new Hasv();
        EQUAL_HASH = new Hash();
        DEFHASH = new HashMap<Datum, Datum>();
        DEFHASH.put(new StringEqual(), new StringHash());
        DEFHASH.put(new StringCIEqual(), new StringCiHash());
        DEFHASH.put(new CharEqual(), new CharHash());
        DEFHASH.put(new CharCIEqual(), new CharCiHash());
        DEFHASH.put((Datum)((Object)EQ), (Datum)((Object)EQ_HASH));
        DEFHASH.put((Datum)((Object)EQV), (Datum)((Object)EQV_HASH));
        DEFHASH.put((Datum)((Object)EQUAL), (Datum)((Object)EQUAL_HASH));
    }

    private LispHash(Map<Object, Datum> hashmap, Procedure eqproc, Procedure hashproc, Environment activeenv, LispMessage message) {
        this.hashmap = hashmap;
        this.eqproc = eqproc;
        this.hashproc = hashproc;
        this.activeenv = activeenv;
        this.message = message;
    }

    public LispHash() {
        this.hashmap = new HashMap<Object, Datum>();
        this.eqproc = EQV;
        this.hashproc = EQV_HASH;
        this.activeenv = new Environment();
        this.message = LispMessage.getInstance();
    }

    public LispHash(LispHash hash) {
        this(new HashMap<Object, Datum>(hash.hashmap), hash.eqproc, hash.hashproc, hash.activeenv, hash.message);
    }

    private static LispHash createhash(Datum p1, Datum p2, Environment env, LispMessage mesg) {
        if (!(p1 instanceof Procedure)) {
            throw mesg.getError("err.require.procedure", p1);
        }
        if (p2 != null && !(p2 instanceof Procedure)) {
            throw mesg.getError("err.require.procedure", p2);
        }
        if (p1.equals(EQ)) {
            return new LispHash(new IdentityHashMap<Object, Datum>(), EQ, EQ_HASH, env, mesg);
        }
        if (p2 != null || (p2 = DEFHASH.get(p1)) != null) {
            return new LispHash(new HashMap<Object, Datum>(), (Procedure)((Object)p1), (Procedure)((Object)p2), env, mesg);
        }
        return new LispHash(new HashMap<Object, Datum>(), EQUAL, EQUAL_HASH, env, mesg);
    }

    private static LispHash createhash(Datum p1, Datum p2, int k, Environment env, LispMessage mesg) {
        if (!(p1 instanceof Procedure)) {
            throw mesg.getError("err.require.procedure", p1);
        }
        if (p2 != null && !(p2 instanceof Procedure)) {
            throw mesg.getError("err.require.procedure", p2);
        }
        if (p1.equals(EQ)) {
            return new LispHash(new IdentityHashMap<Object, Datum>(), EQ, EQ_HASH, env, mesg);
        }
        if (p2 != null || (p2 = DEFHASH.get(p1)) != null) {
            return new LispHash(new HashMap<Object, Datum>(k), (Procedure)((Object)p1), (Procedure)((Object)p2), env, mesg);
        }
        return new LispHash(new HashMap<Object, Datum>(k), EQUAL, EQUAL_HASH, env, mesg);
    }

    public Datum keyConsList() {
        ConsListBuilder b = new ConsListBuilder();
        for (Object x : this.hashmap.keySet()) {
            if (this.eqproc.equals(EQ) || this.eqproc.equals(EQV)) {
                b.append((Datum)x);
                continue;
            }
            b.append(((HashD)x).datum);
        }
        return b.get();
    }

    public Datum valueConsList() {
        ConsListBuilder b = new ConsListBuilder();
        for (Datum x : this.hashmap.values()) {
            b.append(x);
        }
        return b.get();
    }

    public Datum entryConsList() {
        ConsListBuilder b = new ConsListBuilder();
        for (Map.Entry<Object, Datum> x : this.hashmap.entrySet()) {
            if (this.eqproc.equals(EQ) || this.eqproc.equals(EQV)) {
                b.append(LispUtils.list((Datum)x.getKey(), x.getValue()));
                continue;
            }
            b.append(LispUtils.list(((HashD)x.getKey()).datum, x.getValue()));
        }
        return b.get();
    }

    public Datum entryAlist() {
        ConsListBuilder b = new ConsListBuilder();
        for (Map.Entry<Object, Datum> x : this.hashmap.entrySet()) {
            if (this.eqproc.equals(EQ) || this.eqproc.equals(EQV)) {
                b.append(new Cons((Datum)x.getKey(), x.getValue()));
                continue;
            }
            b.append(new Cons(((HashD)x.getKey()).datum, x.getValue()));
        }
        return b.get();
    }

    @Override
    public boolean containsKey(Datum k) {
        if (this.eqproc.equals(EQ) || this.eqproc.equals(EQV)) {
            return this.hashmap.containsKey(k);
        }
        return this.hashmap.containsKey(new HashD(k));
    }

    Datum put0(Datum k, Datum v) {
        Datum r = this.eqproc.equals(EQ) || this.eqproc.equals(EQV) ? this.hashmap.put(k, v) : this.hashmap.put(new HashD(k), v);
        return r;
    }

    @Override
    public Datum remove(Datum k) {
        Datum r = this.eqproc.equals(EQ) || this.eqproc.equals(EQV) ? this.hashmap.remove(k) : this.hashmap.remove(new HashD(k));
        return r;
    }

    @Override
    public Datum get(Datum k) {
        Datum r = this.eqproc.equals(EQ) || this.eqproc.equals(EQV) ? this.hashmap.get(k) : this.hashmap.get(new HashD(k));
        return r;
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<hash>");
    }

    @Override
    public Symbol getCollectionName() {
        return Symbol.getSymbol("hash-map");
    }

    @Override
    public int size() {
        return this.hashmap.size();
    }

    public boolean equivalence(Datum a, Datum b) {
        return LispCollections.equivalence(this, a, b);
    }

    @Override
    public Datum prototype() {
        return new LispHash(new HashMap<Object, Datum>(), this.eqproc, this.hashproc, this.activeenv, this.message);
    }

    @Override
    public Datum clear() {
        this.hashmap.clear();
        return this;
    }

    @Override
    public boolean equalTo(LispCollection col) {
        if (col instanceof LispHash) {
            return this.hashmap.equals(((LispHash)col).hashmap);
        }
        return LispCollections.equalsMapEntry(this, col);
    }

    @Override
    public boolean equalTo(LispCollection col, Procedure proc, Environment env, LispMessage mesg) {
        for (Datum e : this) {
            if (col.contains(e)) continue;
            return false;
        }
        for (Datum e : col) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public LispHash duplicate() {
        return new LispHash(this);
    }

    @Override
    public boolean contains(Datum d) {
        if (d instanceof Cons) {
            return this.equivalence(this.get(((Cons)d).getCar()), ((Cons)d).getCdr());
        }
        return false;
    }

    @Override
    public Iterator<Datum> iterator() {
        final Iterator<Map.Entry<Object, Datum>> itr = this.hashmap.entrySet().iterator();
        return new Iterator<Datum>(){

            @Override
            public boolean hasNext() {
                return itr.hasNext();
            }

            @Override
            public Datum next() {
                Map.Entry e = (Map.Entry)itr.next();
                Datum d = LispHash.this.eqproc.equals(EQ) || LispHash.this.eqproc.equals(EQV) ? (Datum)e.getKey() : ((HashD)e.getKey()).datum;
                return new Cons(d, (Datum)e.getValue());
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Iterator<Map.Entry<Datum, Datum>> entryIterator() {
        final Iterator<Map.Entry<Object, Datum>> itr = this.hashmap.entrySet().iterator();
        return new Iterator<Map.Entry<Datum, Datum>>(){

            @Override
            public boolean hasNext() {
                return itr.hasNext();
            }

            @Override
            public Map.Entry<Datum, Datum> next() {
                final Map.Entry e = (Map.Entry)itr.next();
                final Datum d = LispHash.this.eqproc.equals(EQ) || LispHash.this.eqproc.equals(EQV) ? (Datum)e.getKey() : ((HashD)e.getKey()).datum;
                return new Map.Entry<Datum, Datum>(){

                    @Override
                    public Datum getKey() {
                        return d;
                    }

                    @Override
                    public Datum getValue() {
                        return (Datum)e.getValue();
                    }

                    @Override
                    public Datum setValue(Datum value) {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public void remove() {
                itr.remove();
            }
        };
    }

    @Override
    public Procedure keyEquivalence() {
        return this.eqproc;
    }

    @Override
    public Procedure valueEquivalence() {
        return EQUAL;
    }

    @Override
    public SExpressionDatum keysToList() {
        ConsListBuilder b = new ConsListBuilder();
        for (Object o : this.hashmap.keySet()) {
            if (this.eqproc.equals(EQ) || this.eqproc.equals(EQV)) {
                b.append((Datum)o);
                continue;
            }
            b.append(((HashD)o).datum);
        }
        return b.get();
    }

    @Override
    public Datum[] copyPut(Datum k, Datum v) {
        return this.duplicate().put(k, v);
    }

    @Override
    public Datum[] put(Datum k, Datum v) {
        Datum[] r = new Datum[]{this, this.put0(k, v)};
        return r;
    }

    @Override
    public Datum copyDeleteKey(Datum k) {
        return this.duplicate().deleteKey(k);
    }

    @Override
    public Datum deleteKey(Datum k) {
        this.remove(k);
        return this;
    }

    @Override
    public Datum copyDeleteFromKey(LispBag k) {
        return this.duplicate().deleteFromKey(k);
    }

    @Override
    public Datum deleteFromKey(LispBag k) {
        for (Datum x : k) {
            this.remove(x);
        }
        return this;
    }

    @Override
    public Datum copyAddFrom(LispMap m) {
        return this.duplicate().addFrom(m);
    }

    @Override
    public Datum addFrom(LispMap m) {
        Iterator<Map.Entry<Datum, Datum>> itr = m.entryIterator();
        while (itr.hasNext()) {
            Map.Entry<Datum, Datum> e = itr.next();
            this.put0(e.getKey(), e.getValue());
        }
        return this;
    }

    @Override
    public boolean equivalenceKey(Datum a, Datum b) {
        if (this.eqproc.equals(EQ)) {
            return a == b;
        }
        if (this.eqproc.equals(EQV)) {
            return a.equals(b);
        }
        return Scheme.callva(this.eqproc, this.activeenv, this.message, a, b).isTrue();
    }

    @Override
    public boolean equivalenceValue(Datum a, Datum b) {
        return LispUtils.equals(a, b);
    }

    @Override
    public int count(Datum c2a) {
        int r = 0;
        for (Datum x : this) {
            if (!this.equivalence(x, c2a)) continue;
            ++r;
        }
        return r;
    }

    @Override
    public Datum toList() {
        return LispUtils.toAlist(this.entryIterator());
    }

    @Override
    public int countValue(Datum d) {
        Iterator<Map.Entry<Datum, Datum>> itr = this.entryIterator();
        int r = 0;
        while (itr.hasNext()) {
            if (!this.equivalence(itr.next().getValue(), d)) continue;
            ++r;
        }
        return r;
    }

    public int countKey(Datum d) {
        Iterator<Map.Entry<Datum, Datum>> itr = this.entryIterator();
        int r = 0;
        while (itr.hasNext()) {
            if (!this.equivalence(itr.next().getKey(), d)) continue;
            ++r;
        }
        return r;
    }

    @Override
    public boolean equalToMap(LispMap e, Procedure p, Environment env, LispMessage mesg) {
        return LispCollections.contains(this, e, p, env, mesg) && LispCollections.contains(e, this, p, env, mesg);
    }

    @Override
    public void setBang(Datum k, Datum v) {
        this.put0(k, v);
    }

    @Override
    public void clearBang(int k) {
        this.hashmap.clear();
    }

    @Override
    public LispVector keysToVector() {
        ArrayList<Datum> l = new ArrayList<Datum>();
        for (Object k : this.hashmap.keySet()) {
            if (this.eqproc.equals(EQ) || this.eqproc.equals(EQV)) {
                l.add((Datum)k);
                continue;
            }
            l.add(((HashD)k).datum);
        }
        return new LispVector(l);
    }

    @Override
    public LispVector valuesToVector() {
        return new LispVector(this.hashmap.values());
    }

    @Override
    public LispVector[] entriesToVector() {
        return new LispVector[]{this.keysToVector(), this.valuesToVector()};
    }

    @Override
    public Procedure hashFunction() {
        return this.hashproc;
    }

    @Override
    public boolean isMutableHashtable() {
        return true;
    }

    @Override
    public Datum ref(Datum arg, LispMessage mesg) {
        Datum r = this.get(arg);
        return r != null ? r : Undef.UNDEF;
    }

    public static abstract class AbstractMakeHashTable
    extends Subr {
        protected LispHash makeHash(Datum eqproc, Datum hashproc, int k, Environment env, LispMessage mesg) {
            return LispHash.createhash(eqproc, hashproc, k, env, mesg);
        }

        protected LispHash makeHash(Datum eqproc, Datum hashproc, Environment env, LispMessage mesg) {
            return LispHash.createhash(eqproc, hashproc, env, mesg);
        }
    }

    public static class AlistToHashTable
    extends Subr {
        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            Datum d = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            Datum p1 = Iterators.nextIf(itr, (Datum)((Object)EQUAL));
            Datum p2 = Iterators.nextIf(itr, null);
            ConsIterator it2 = new ConsIterator(d);
            LispHash r = LispHash.createhash(p1, p2, env, mesg);
            while (it2.hasNext()) {
                Datum x = it2.next();
                if (x instanceof Cons) {
                    r.put0(((Cons)x).getCar(), ((Cons)x).getCdr());
                    continue;
                }
                throw mesg.getError("err.require.assoc", d);
            }
            if (!it2.rest().isNil()) {
                throw mesg.getError("err.list", d);
            }
            return r;
        }
    }

    private class HashD {
        private Datum datum;

        private HashD(Datum k) {
            this.datum = k;
        }

        public boolean equals(Object o) {
            if (o instanceof HashD) {
                return Scheme.callva(LispHash.this.eqproc, LispHash.this.activeenv, LispHash.this.message, this.datum, ((HashD)o).datum).isTrue();
            }
            return false;
        }

        public int hashCode() {
            return Scheme.callva(LispHash.this.hashproc, LispHash.this.activeenv, LispHash.this.message, this.datum).getInt();
        }

        public String toString() {
            return this.datum.toString();
        }
    }

    public static class HashTableCopy
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof LispHash) {
                LispHash h = (LispHash)c1a;
                LispHash r = LispHash.createhash((Datum)((Object)h.eqproc), (Datum)((Object)h.hashproc), h.activeenv, h.message);
                Iterator<Map.Entry<Datum, Datum>> ei = h.entryIterator();
                while (ei.hasNext()) {
                    Map.Entry<Datum, Datum> e = ei.next();
                    r.put0(e.getKey(), e.getValue());
                }
                return r;
            }
            throw mesg.getError("err.srfi69.require.hashtable", c1a);
        }
    }

    public static class HashTableDeleteS
    extends BinaryArgs {
        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            if (!(c1a instanceof LispHash)) {
                throw mesg.getError("err.srfi69.require.hashtable", c1a);
            }
            ((LispHash)c1a).remove(c2a);
            return Undef.UNDEF;
        }
    }

    public static class HashTableEquivalenceFunction
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof LispHash) {
                return (Datum)((Object)((LispHash)c1a).eqproc);
            }
            throw mesg.getError("err.srfi69.require.hashtable", c1a);
        }
    }

    public static class HashTableFold
    extends TernaryArgs {
        @Override
        protected Datum execute(Datum c1a, Datum c2a, Datum c3a, Environment env, LispMessage mesg) {
            if (!(c2a instanceof Procedure)) {
                throw mesg.getError("err.require.procedure", c2a);
            }
            if (c1a instanceof LispHash) {
                ConsIterator itr = new ConsIterator(((LispHash)c1a).entryConsList());
                Datum a = c3a;
                while (itr.hasNext()) {
                    Cons c = (Cons)itr.next();
                    Datum arg = LispUtils.list(c.getCar(), ((Cons)c.getCdr()).getCar(), a);
                    a = Scheme.call((Procedure)((Object)c2a), env, mesg, arg);
                }
                return a;
            }
            throw mesg.getError("err.srfi69.require.hashtable", c1a);
        }
    }

    public static class HashTableHashFunction
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof LispHash) {
                return (Datum)((Object)((LispHash)c1a).hashproc);
            }
            throw mesg.getError("err.srfi69.require.hashtable", c1a);
        }
    }

    public static class HashTableKeys
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof LispHash) {
                return ((LispHash)c1a).keyConsList();
            }
            throw mesg.getError("err.srfi69.require.hashtable", c1a);
        }
    }

    public static class HashTableMergeS
    extends BinaryArgs {
        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            if (!(c2a instanceof LispHash)) {
                throw mesg.getError("err.srfi69.require.hashtable", c2a);
            }
            if (c1a instanceof LispHash) {
                LispHash h = (LispHash)c1a;
                LispHash g = (LispHash)c2a;
                Iterator<Map.Entry<Datum, Datum>> ei = g.entryIterator();
                while (ei.hasNext()) {
                    Map.Entry<Datum, Datum> e = ei.next();
                    h.put0(e.getKey(), e.getValue());
                }
                return h;
            }
            throw mesg.getError("err.srfi69.require.hashtable", c1a);
        }
    }

    public static class HashTableRef
    extends Subr {
        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            Datum ht = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            Datum k = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            Datum th = Iterators.nextIf(itr, null);
            if (!(ht instanceof LispHash)) {
                throw mesg.getError("err.srfi69.require.hashtable", ht);
            }
            if (th != null && !(th instanceof Procedure)) {
                throw mesg.getError("err.require.procedure", th);
            }
            LispHash h = (LispHash)ht;
            Datum r = h.get(k);
            if (r != null) {
                return r;
            }
            if (th != null) {
                return Scheme.callva((Procedure)((Object)th), env, mesg, new Datum[0]);
            }
            throw mesg.getError("err.srfi69.keynotfound", k);
        }
    }

    public static class HashTableRefWithDefault
    extends TernaryArgs {
        @Override
        protected Datum execute(Datum c1a, Datum c2a, Datum c3a, Environment env, LispMessage mesg) {
            if (!(c1a instanceof LispHash)) {
                throw mesg.getError("err.srfi69.require.hashtable", c1a);
            }
            LispHash h = (LispHash)c1a;
            Datum d = h.get(c2a);
            return d != null ? d : c3a;
        }
    }

    public static class HashTableSetS
    extends TernaryArgs {
        @Override
        protected Datum execute(Datum c1a, Datum c2a, Datum c3a, Environment env, LispMessage mesg) {
            if (!(c1a instanceof LispHash)) {
                throw mesg.getError("err.srfi69.require.hashtable", c1a);
            }
            ((LispHash)c1a).put0(c2a, c3a);
            return Undef.UNDEF;
        }
    }

    public static class HashTableSize
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof LispHash) {
                return LispInteger.valueOf(((LispHash)c1a).hashmap.size());
            }
            throw mesg.getError("err.srfi69.require.hashtable", c1a);
        }
    }

    public static class HashTableToAlist
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof LispHash) {
                return ((LispHash)c1a).entryAlist();
            }
            throw mesg.getError("err.srfi69.require.hashtable", c1a);
        }
    }

    public static class HashTableUpdateS
    extends Subr {
        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            Datum ht = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            Datum k = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            Datum f = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            Datum th = Iterators.nextIf(itr, null);
            SubrUtils.checkTerminated(itr, body, mesg);
            if (!(ht instanceof LispHash)) {
                throw mesg.getError("err.srfi69.require.hashtable", ht);
            }
            if (!(f instanceof Procedure)) {
                throw mesg.getError("err.require.procedure", f);
            }
            if (th != null && !(th instanceof Procedure)) {
                throw mesg.getError("err.require.procedure", th);
            }
            LispHash h = (LispHash)ht;
            Datum r = h.get(k);
            if (r == null) {
                if (th != null) {
                    r = Scheme.callva((Procedure)((Object)th), env, mesg, new Datum[0]);
                } else {
                    throw mesg.getError("err.srfi69.keynotfound", k);
                }
            }
            return Scheme.callva((Procedure)((Object)f), env, mesg, r);
        }
    }

    public static class HashTableUpdateSWithDefault
    extends Subr {
        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            Datum ht = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            Datum k = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            Datum f = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            Datum df = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            SubrUtils.checkTerminated(itr, body, mesg);
            if (!(ht instanceof LispHash)) {
                throw mesg.getError("err.srfi69.require.hashtable", ht);
            }
            if (!(f instanceof Procedure)) {
                throw mesg.getError("err.require.procedure", f);
            }
            LispHash h = (LispHash)ht;
            Datum r = h.get(k);
            if (r == null) {
                r = df;
            }
            return Scheme.callva((Procedure)((Object)f), env, mesg, r);
        }
    }

    public static class HashTableValues
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof LispHash) {
                return ((LispHash)c1a).valueConsList();
            }
            throw mesg.getError("err.srfi69.require.hashtable", c1a);
        }
    }

    public static class HashTableWalk
    extends BinaryArgs {
        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            if (!(c2a instanceof Procedure)) {
                throw mesg.getError("err.require.procedure", c2a);
            }
            if (c1a instanceof LispHash) {
                ConsIterator itr = new ConsIterator(((LispHash)c1a).entryConsList());
                while (itr.hasNext()) {
                    Scheme.call((Procedure)((Object)c2a), env, mesg, itr.next());
                }
                return Undef.UNDEF;
            }
            throw mesg.getError("err.srfi69.require.hashtable", c1a);
        }
    }

    public static class IsHashTable
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            return LispBoolean.getInstance(c1a instanceof LispHash);
        }
    }

    public static class IsHashTableExists
    extends BinaryArgs {
        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            if (!(c1a instanceof LispHash)) {
                throw mesg.getError("err.srfi69.require.hashtable", c1a);
            }
            return LispBoolean.getInstance(((LispHash)c1a).containsKey(c2a));
        }
    }

    public static class MakeHashMap
    extends Subr {
        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            Datum p1 = Iterators.nextIf(itr, (Datum)((Object)EQUAL));
            SubrUtils.checkTerminated(itr, body, mesg);
            return LispHash.createhash(p1, null, env, mesg);
        }
    }

    public static class MakeHashTable
    extends Subr {
        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            Datum p1 = Iterators.nextIf(itr, (Datum)((Object)EQUAL));
            Datum p2 = Iterators.nextIf(itr, null);
            SubrUtils.checkTerminated(itr, body, mesg);
            return LispHash.createhash(p1, p2, env, mesg);
        }
    }

    public static class SubrHashMap
    extends Subr {
        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            Datum p1 = Iterators.nextIf(itr, (Datum)((Object)EQUAL));
            Datum d = itr.rest();
            ConsIterator it2 = new ConsIterator(d);
            if (!(p1 instanceof Procedure)) {
                p1 = (Datum)((Object)EQUAL);
                d = new Cons(p1, d);
            }
            LispHash r = LispHash.createhash(p1, null, env, mesg);
            while (it2.hasNext()) {
                Datum x = it2.next();
                if (x instanceof Cons) {
                    r.put0(((Cons)x).getCar(), ((Cons)x).getCdr());
                    continue;
                }
                throw mesg.getError("err.require.pair", x);
            }
            if (!it2.rest().isNil()) {
                throw mesg.getError("err.list", d);
            }
            return r;
        }
    }
}

