/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.collection;

import java.util.Iterator;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.MultiValues;
import net.morilib.lisp.Procedure;
import net.morilib.lisp.Scheme;
import net.morilib.lisp.Subr;
import net.morilib.lisp.collection.ImmutableException;
import net.morilib.lisp.collection.LispCollection;
import net.morilib.lisp.collection.NoBoundsException;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.subr.UnaryArgs;
import net.morilib.util.Iterators;

public interface LispOrderedCollection
extends LispCollection {
    public Procedure ordering();

    public Datum first() throws NoBoundsException;

    public Datum last() throws NoBoundsException;

    public Datum removeFirst() throws ImmutableException, NoBoundsException;

    public Datum removeLast() throws ImmutableException, NoBoundsException;

    public Datum copyWithoutFirst() throws NoBoundsException;

    public Datum copyWithoutLast() throws NoBoundsException;

    public static class IsOrderedCollection
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            return LispBoolean.getInstance(c1a instanceof LispOrderedCollection);
        }
    }

    public static class OrderedCollectionDeleteLeft
    extends UnaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public OrderedCollectionDeleteLeft(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            try {
                Datum r3 = ((LispOrderedCollection)((Object)c1a)).first();
                Datum r2 = ((LispOrderedCollection)((Object)c1a)).copyWithoutFirst();
                return MultiValues.newValues(r2, r3);
            }
            catch (NoBoundsException e) {
                throw mesg.getError("err.srfi44.infinite", c1a);
            }
        }
    }

    public static class OrderedCollectionDeleteLeftS
    extends UnaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public OrderedCollectionDeleteLeftS(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            try {
                Datum r3 = ((LispOrderedCollection)((Object)c1a)).first();
                Datum r2 = ((LispOrderedCollection)((Object)c1a)).removeFirst();
                return MultiValues.newValues(r2, r3);
            }
            catch (ImmutableException e) {
                throw mesg.getError("err.srfi44.immutable", c1a);
            }
            catch (NoBoundsException e) {
                throw mesg.getError("err.srfi44.infinite", c1a);
            }
        }
    }

    public static class OrderedCollectionDeleteRight
    extends UnaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public OrderedCollectionDeleteRight(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            try {
                Datum r3 = ((LispOrderedCollection)((Object)c1a)).last();
                Datum r2 = ((LispOrderedCollection)((Object)c1a)).copyWithoutLast();
                return MultiValues.newValues(r2, r3);
            }
            catch (NoBoundsException e) {
                throw mesg.getError("err.srfi44.infinite", c1a);
            }
        }
    }

    public static class OrderedCollectionDeleteRightS
    extends UnaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public OrderedCollectionDeleteRightS(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            try {
                Datum r3 = ((LispOrderedCollection)((Object)c1a)).last();
                Datum r2 = ((LispOrderedCollection)((Object)c1a)).removeLast();
                return MultiValues.newValues(r2, r3);
            }
            catch (ImmutableException e) {
                throw mesg.getError("err.srfi44.immutable", c1a);
            }
            catch (NoBoundsException e) {
                throw mesg.getError("err.srfi44.infinite", c1a);
            }
        }
    }

    public static class OrderedCollectionGetLeft
    extends Subr {
        private Class<?> tocheck;
        private String errcd;

        public OrderedCollectionGetLeft(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            Datum d = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            Datum th = Iterators.nextIf(itr);
            this.checkType(d, mesg);
            if (th != null && !(th instanceof Procedure)) {
                throw mesg.getError("err.require.procedure", th);
            }
            LispOrderedCollection c = (LispOrderedCollection)((Object)d);
            if (c.size() > 0) {
                try {
                    return c.first();
                }
                catch (NoBoundsException e) {
                    throw new RuntimeException(e);
                }
            }
            if (th == null) {
                return LispBoolean.FALSE;
            }
            return Scheme.callva(th, env, mesg, new Datum[0]);
        }
    }

    public static class OrderedCollectionGetRight
    extends Subr {
        private Class<?> tocheck;
        private String errcd;

        public OrderedCollectionGetRight(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            Datum d = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            Datum th = Iterators.nextIf(itr);
            this.checkType(d, mesg);
            if (th != null && !(th instanceof Procedure)) {
                throw mesg.getError("err.require.procedure", th);
            }
            LispOrderedCollection c = (LispOrderedCollection)((Object)d);
            if (c.size() > 0) {
                try {
                    return c.last();
                }
                catch (NoBoundsException e) {
                    throw new RuntimeException(e);
                }
            }
            if (c.size() < 0) {
                throw mesg.getError("err.srfi44.infinite", d);
            }
            if (th == null) {
                return LispBoolean.FALSE;
            }
            return Scheme.callva(th, env, mesg, new Datum[0]);
        }
    }

    public static class OrderedCollectionOrderingFunction
    extends UnaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public OrderedCollectionOrderingFunction(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            return (Datum)((Object)((LispOrderedCollection)((Object)c1a)).ordering());
        }
    }
}

