/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.collection;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Procedure;
import net.morilib.lisp.Scheme;
import net.morilib.lisp.Subr;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.collection.LispCollection;
import net.morilib.lisp.collection.LispMutableSetDatum;
import net.morilib.lisp.collection.LispSet;
import net.morilib.lisp.collection.LispSetDatum;
import net.morilib.lisp.collection.hash.CharCiHash;
import net.morilib.lisp.collection.hash.CharHash;
import net.morilib.lisp.collection.hash.Hash;
import net.morilib.lisp.collection.hash.HashByIdentity;
import net.morilib.lisp.collection.hash.Hasv;
import net.morilib.lisp.collection.hash.StringCiHash;
import net.morilib.lisp.collection.hash.StringHash;
import net.morilib.lisp.subr.CharCIEqual;
import net.morilib.lisp.subr.CharEqual;
import net.morilib.lisp.subr.IsEq;
import net.morilib.lisp.subr.IsEqual;
import net.morilib.lisp.subr.IsEqv;
import net.morilib.lisp.subr.StringCIEqual;
import net.morilib.lisp.subr.StringEqual;
import net.morilib.lisp.subr.UnaryArgs;
import net.morilib.util.Iterators;
import net.morilib.util.set.IdentityHashSet;

public class LispHashSet
extends LispMutableSetDatum {
    private static final Map<Datum, Datum> DEFHASH;
    private static final Procedure EQ;
    private static final Procedure EQV;
    private static final Procedure EQUAL;
    private static final Procedure EQ_H;
    private static final Procedure EQV_H;
    private static final Procedure EQUAL_H;
    private Set<Object> hashSet;
    private Procedure eqproc;
    private Procedure hashproc;
    private Environment activeenv;
    private LispMessage message;

    static {
        EQ = new IsEq();
        EQV = new IsEqv();
        EQUAL = new IsEqual();
        EQ_H = new HashByIdentity();
        EQV_H = new Hasv();
        EQUAL_H = new Hash();
        DEFHASH = new HashMap<Datum, Datum>();
        DEFHASH.put(new StringEqual(), new StringHash());
        DEFHASH.put(new StringCIEqual(), new StringCiHash());
        DEFHASH.put(new CharEqual(), new CharHash());
        DEFHASH.put(new CharCIEqual(), new CharCiHash());
        DEFHASH.put((Datum)((Object)EQ), (Datum)((Object)EQ_H));
        DEFHASH.put((Datum)((Object)EQV), (Datum)((Object)EQV_H));
        DEFHASH.put((Datum)((Object)EQUAL), (Datum)((Object)EQUAL_H));
    }

    private LispHashSet(Set<Object> hashSet, Procedure eqproc, Procedure hashproc, Environment activeenv, LispMessage message) {
        this.hashSet = hashSet;
        this.eqproc = eqproc;
        this.hashproc = hashproc;
        this.activeenv = activeenv;
        this.message = message;
    }

    public LispHashSet() {
        this.hashSet = new HashSet<Object>();
        this.eqproc = EQV;
        this.hashproc = EQUAL_H;
        this.activeenv = new Environment();
        this.message = LispMessage.getInstance();
    }

    public LispHashSet(Collection<Datum> col) {
        this.hashSet = new HashSet<Datum>(col);
        this.eqproc = EQV;
        this.hashproc = EQUAL_H;
        this.activeenv = new Environment();
        this.message = LispMessage.getInstance();
    }

    @Override
    public Symbol getCollectionName() {
        return Symbol.getSymbol("hash-set");
    }

    @Override
    public int size() {
        return this.hashSet.size();
    }

    @Override
    public LispHashSet prototype() {
        return new LispHashSet(new HashSet<Object>(), this.eqproc, this.hashproc, this.activeenv, this.message);
    }

    @Override
    public Datum clear() {
        this.hashSet.clear();
        return this;
    }

    @Override
    public boolean equalTo(LispCollection col) {
        return this.equalTo(col, this.eqproc, this.activeenv, this.message);
    }

    @Override
    public LispHashSet duplicate() {
        return new LispHashSet(new HashSet<Object>(this.hashSet), this.eqproc, this.hashproc, this.activeenv, this.message);
    }

    @Override
    public boolean contains(Datum d) {
        if (this.eqproc.equals(EQ) || this.eqproc.equals(EQV)) {
            return this.hashSet.contains(d);
        }
        return this.hashSet.contains(new HashD(d));
    }

    @Override
    public Iterator<Datum> iterator() {
        final Iterator<Object> itr = this.hashSet.iterator();
        return new Iterator<Datum>(){

            @Override
            public boolean hasNext() {
                return itr.hasNext();
            }

            @Override
            public Datum next() {
                Object o = itr.next();
                if (o instanceof HashD) {
                    return ((HashD)o).datum;
                }
                return (Datum)o;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public Procedure equivalence() {
        return this.eqproc;
    }

    @Override
    public boolean equivalence(Datum a, Datum b) {
        if (this.eqproc.equals(EQ)) {
            return a == b;
        }
        if (this.eqproc.equals(EQV)) {
            return a.equals(b);
        }
        return Scheme.callva(this.eqproc, this.activeenv, this.message, a, b).isTrue();
    }

    @Override
    public Datum add(Datum d) {
        if (this.eqproc.equals(EQ) || this.eqproc.equals(EQV)) {
            this.hashSet.add(d);
        } else {
            this.hashSet.add(new HashD(d));
        }
        return this;
    }

    @Override
    public Datum delete(Datum d) {
        if (this.eqproc.equals(EQ) || this.eqproc.equals(EQV)) {
            this.hashSet.remove(d);
        } else {
            this.hashSet.remove(new HashD(d));
        }
        return this;
    }

    @Override
    public LispSetDatum intersection(LispSet s) {
        return this.duplicate().retainAll(s);
    }

    @Override
    public LispSetDatum retainAll(LispSet s) {
        Iterator<Object> itr = this.hashSet.iterator();
        while (itr.hasNext()) {
            if (this.eqproc.equals(EQ) || this.eqproc.equals(EQV)) {
                if (s.contains((Datum)itr.next())) continue;
                itr.remove();
                continue;
            }
            if (s.contains(((HashD)itr.next()).datum)) continue;
            itr.remove();
        }
        return this;
    }

    public int hashCode() {
        return this.hashSet.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof LispCollection) {
            return this.equalTo((LispCollection)obj);
        }
        return false;
    }

    @Override
    public void getResult(StringBuilder buf) {
        String dlm = "";
        buf.append("#{");
        for (Datum d : this) {
            buf.append(dlm);
            buf.append(LispUtils.getResult(d));
            dlm = " ";
        }
        buf.append("}");
    }

    @Override
    public void print(StringBuilder buf) {
        String dlm = "";
        buf.append("#{");
        for (Datum d : this) {
            buf.append(dlm);
            buf.append(LispUtils.print(d));
            dlm = " ";
        }
        buf.append("}");
    }

    @Override
    public Set<Datum> getJavaSet() {
        HashSet<Datum> r = new HashSet<Datum>();
        for (Object o : this.hashSet) {
            if (o instanceof HashD) {
                r.add(((HashD)o).datum);
                continue;
            }
            r.add((Datum)o);
        }
        return r;
    }

    /* synthetic */ LispHashSet(Set set, Procedure procedure, Procedure procedure2, Environment environment, LispMessage lispMessage, LispHashSet lispHashSet) {
        this(set, procedure, procedure2, environment, lispMessage);
    }

    private class HashD {
        private Datum datum;

        private HashD(Datum k) {
            this.datum = k;
        }

        public boolean equals(Object o) {
            if (o instanceof HashD) {
                if (LispHashSet.this.eqproc.equals(EQ)) {
                    return this.datum == ((HashD)o).datum;
                }
                if (LispHashSet.this.eqproc.equals(EQV)) {
                    return this.datum.equals(((HashD)o).datum);
                }
                return Scheme.callva(LispHashSet.this.eqproc, LispHashSet.this.activeenv, LispHashSet.this.message, this.datum, ((HashD)o).datum).isTrue();
            }
            return false;
        }

        public int hashCode() {
            return Scheme.callva(LispHashSet.this.hashproc, LispHashSet.this.activeenv, LispHashSet.this.message, this.datum).getInt();
        }

        public String toString() {
            return this.datum.toString();
        }
    }

    public static class IsHashSet
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            return LispBoolean.getInstance(c1a instanceof LispHashSet);
        }
    }

    public static class MakeHashSet
    extends Subr {
        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            Datum ep = Iterators.nextIf(itr);
            Datum hp = Iterators.nextIf(itr);
            if (ep == null) {
                return new LispHashSet(new HashSet(), EQV, EQUAL_H, env, mesg, null);
            }
            if (hp == null) {
                if (!(ep instanceof Procedure)) {
                    throw mesg.getError("err.require.procedure", ep);
                }
                return new LispHashSet(new HashSet(), (Procedure)((Object)ep), EQUAL_H, env, mesg, null);
            }
            if (hp instanceof Procedure) {
                if (hp.equals(EQ)) {
                    return new LispHashSet(new IdentityHashSet(), (Procedure)((Object)ep), (Procedure)((Object)hp), env, mesg, null);
                }
                return new LispHashSet(new HashSet(), (Procedure)((Object)ep), (Procedure)((Object)hp), env, mesg, null);
            }
            throw mesg.getError("err.require.procedure", ep);
        }
    }

    public static class SubrHashSet
    extends Subr {
        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            Procedure hp2;
            Procedure ep2;
            ConsIterator itr = new ConsIterator(body);
            HashSet<Object> st = new HashSet<Object>();
            Datum ep = Iterators.nextIf(itr);
            Datum hp = Iterators.nextIf(itr);
            if (ep == null) {
                ep2 = EQV;
                hp2 = EQUAL_H;
            } else if (hp == null) {
                if (ep instanceof Procedure) {
                    ep2 = (Procedure)((Object)ep);
                    hp2 = EQUAL_H;
                } else {
                    ep2 = EQV;
                    hp2 = EQUAL_H;
                    st.add(ep);
                }
            } else if (hp instanceof Procedure) {
                if (ep instanceof Procedure) {
                    Procedure ep22 = (Procedure)((Object)ep);
                    Procedure hp22 = (Procedure)((Object)hp);
                    LispHashSet rs = new LispHashSet(st, ep22, hp22, env, mesg, null);
                    while (itr.hasNext()) {
                        LispHashSet lispHashSet = rs;
                        lispHashSet.getClass();
                        st.add(lispHashSet.new HashD(itr.next()));
                    }
                    return rs;
                }
                ep2 = EQV;
                hp2 = EQUAL_H;
                st.add(ep);
                st.add(hp);
                while (itr.hasNext()) {
                    st.add(itr.next());
                }
            } else {
                if (ep instanceof Procedure) {
                    LispHashSet rs;
                    Procedure ep23 = (Procedure)((Object)ep);
                    Procedure hp23 = EQUAL_H;
                    LispHashSet lispHashSet = rs = new LispHashSet(st, ep23, hp23, env, mesg, null);
                    lispHashSet.getClass();
                    st.add(lispHashSet.new HashD(hp));
                    while (itr.hasNext()) {
                        LispHashSet lispHashSet2 = rs;
                        lispHashSet2.getClass();
                        st.add(lispHashSet2.new HashD(itr.next()));
                    }
                    return rs;
                }
                ep2 = EQV;
                hp2 = EQUAL_H;
                st.add(ep);
                st.add(hp);
                while (itr.hasNext()) {
                    st.add(itr.next());
                }
            }
            return new LispHashSet(st, ep2, hp2, env, mesg, null);
        }
    }
}

