/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.collection;

import java.util.NoSuchElementException;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Procedure;
import net.morilib.lisp.collection.ImmutableException;
import net.morilib.lisp.collection.LispCollection;
import net.morilib.lisp.subr.BinaryArgs;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.subr.UnaryArgs;

public interface LispBag
extends LispCollection {
    public Procedure equivalence();

    public boolean equivalence(Datum var1, Datum var2);

    public Datum copyAdd(Datum var1);

    public Datum add(Datum var1) throws ImmutableException;

    public Datum copyDelete(Datum var1);

    public Datum delete(Datum var1) throws ImmutableException;

    public Datum copyDeleteAll(Datum var1);

    public Datum deleteAll(Datum var1) throws ImmutableException;

    public Datum copyAddFrom(LispBag var1);

    public Datum addFrom(LispBag var1) throws ImmutableException;

    public Datum copyDeleteFrom(LispBag var1);

    public Datum deleteFrom(LispBag var1) throws ImmutableException;

    public Datum copyDeleteAllFrom(LispBag var1);

    public Datum deleteAllFrom(LispBag var1) throws ImmutableException;

    public static class BagAdd
    extends BinaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public BagAdd(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            return ((LispBag)((Object)c1a)).copyAdd(c2a);
        }
    }

    public static class BagAddFrom
    extends BinaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public BagAddFrom(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            if (!(c2a instanceof LispBag)) {
                throw mesg.getError("err.srfi44.require.bag", c2a);
            }
            return ((LispBag)((Object)c1a)).copyAddFrom((LispBag)((Object)c2a));
        }
    }

    public static class BagAddFromS
    extends BinaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public BagAddFromS(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            if (!(c2a instanceof LispBag)) {
                throw mesg.getError("err.srfi44.require.bag", c2a);
            }
            try {
                return ((LispBag)((Object)c1a)).addFrom((LispBag)((Object)c2a));
            }
            catch (ImmutableException e) {
                throw mesg.getError("err.srfi44.immutable", c1a);
            }
        }
    }

    public static class BagAddS
    extends BinaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public BagAddS(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            try {
                return ((LispBag)((Object)c1a)).add(c2a);
            }
            catch (ImmutableException e) {
                throw mesg.getError("err.srfi44.immutable", c1a);
            }
        }
    }

    public static class BagDelete
    extends BinaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public BagDelete(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            try {
                return ((LispBag)((Object)c1a)).copyDelete(c2a);
            }
            catch (NoSuchElementException e) {
                throw mesg.getError("err.srfi44.nosuchelement", c1a);
            }
        }
    }

    public static class BagDeleteAll
    extends BinaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public BagDeleteAll(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            return ((LispBag)((Object)c1a)).copyDeleteAll(c2a);
        }
    }

    public static class BagDeleteAllFrom
    extends BinaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public BagDeleteAllFrom(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            if (!(c2a instanceof LispBag)) {
                throw mesg.getError("err.srfi44.require.bag", c2a);
            }
            return ((LispBag)((Object)c1a)).copyDeleteAllFrom((LispBag)((Object)c2a));
        }
    }

    public static class BagDeleteAllFromS
    extends BinaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public BagDeleteAllFromS(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            if (!(c2a instanceof LispBag)) {
                throw mesg.getError("err.srfi44.require.bag", c2a);
            }
            try {
                return ((LispBag)((Object)c1a)).deleteAllFrom((LispBag)((Object)c2a));
            }
            catch (ImmutableException e) {
                throw mesg.getError("err.srfi44.immutable", c1a);
            }
        }
    }

    public static class BagDeleteAllS
    extends BinaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public BagDeleteAllS(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            try {
                return ((LispBag)((Object)c1a)).deleteAll(c2a);
            }
            catch (ImmutableException e) {
                throw mesg.getError("err.srfi44.immutable", c1a);
            }
        }
    }

    public static class BagDeleteFrom
    extends BinaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public BagDeleteFrom(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            if (!(c2a instanceof LispBag)) {
                throw mesg.getError("err.srfi44.require.bag", c2a);
            }
            return ((LispBag)((Object)c1a)).copyDeleteFrom((LispBag)((Object)c2a));
        }
    }

    public static class BagDeleteFromS
    extends BinaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public BagDeleteFromS(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            if (!(c2a instanceof LispBag)) {
                throw mesg.getError("err.srfi44.require.bag", c2a);
            }
            try {
                return ((LispBag)((Object)c1a)).deleteFrom((LispBag)((Object)c2a));
            }
            catch (ImmutableException e) {
                throw mesg.getError("err.srfi44.immutable", c1a);
            }
        }
    }

    public static class BagDeleteS
    extends BinaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public BagDeleteS(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            try {
                return ((LispBag)((Object)c1a)).delete(c2a);
            }
            catch (ImmutableException e) {
                throw mesg.getError("err.srfi44.immutable", c1a);
            }
            catch (NoSuchElementException e) {
                throw mesg.getError("err.srfi44.nosuchelement", c1a);
            }
        }
    }

    public static class BagEquivalenceFunction
    extends UnaryArgs {
        private Class<?> tocheck;
        private String errcd;

        public BagEquivalenceFunction(Class<?> cls, String err) {
            this.tocheck = cls;
            this.errcd = err;
        }

        private void checkType(Datum c1a, LispMessage mesg) {
            SubrUtils.checkType(c1a, this.tocheck, mesg, this.errcd);
        }

        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            this.checkType(c1a, mesg);
            return (Datum)((Object)((LispBag)((Object)c1a)).equivalence());
        }
    }

    public static class IsBag
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            return LispBoolean.getInstance(c1a instanceof LispBag);
        }
    }
}

