/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.charset;

import java.util.Iterator;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.MultiValues;
import net.morilib.lisp.Subr;
import net.morilib.lisp.charset.LispCharSet;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.range.integer.IntRange;

public class CharSetDiffPlusIntersectionS
extends Subr {
    Datum e2(LispCharSet cs1, LispCharSet cs2, ConsIterator itr, LispMessage mesg) {
        IntRange rs1 = cs1.charset;
        IntRange rs2 = cs2.charset;
        while (itr.hasNext()) {
            Datum d = itr.next();
            if (d instanceof LispCharSet) {
                LispCharSet rx = (LispCharSet)d;
                rs2 = rs2.join(rx.charset);
                continue;
            }
            throw mesg.getError("err.charset.require.charset", d);
        }
        cs1.charset = rs1.difference(rs2);
        cs2.charset = rs1.meet(rs2);
        return MultiValues.newValues(cs1, cs2);
    }

    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        Datum cs1 = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        Datum cs2 = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        if (!(cs1 instanceof LispCharSet)) {
            throw mesg.getError("err.charset.require.charset", cs1);
        }
        if (!(cs2 instanceof LispCharSet)) {
            throw mesg.getError("err.charset.require.charset", cs2);
        }
        return this.e2((LispCharSet)cs1, (LispCharSet)cs2, itr, mesg);
    }
}

