/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.bits;

import java.math.BigInteger;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.subr.QuaternaryArgs;
import net.morilib.lisp.subr.SubrUtils;

public class RotateBitField
extends QuaternaryArgs {
    @Override
    protected Datum execute(Datum c1a, Datum c2a, Datum c3a, Datum c4a, Environment env, LispMessage mesg) {
        int c = SubrUtils.getSmallInt(c2a, mesg);
        int s = SubrUtils.getSmallInt(c3a, mesg);
        int e = SubrUtils.getSmallInt(c4a, mesg);
        if (s < 0) {
            throw mesg.getError("err.require.int.nonnegative", c3a);
        }
        if (e < 0) {
            throw mesg.getError("err.require.int.nonnegative", c4a);
        }
        if (s > e) {
            throw mesg.getError("err.srfi60.index.invalid");
        }
        if (s == e) {
            return c1a;
        }
        if (c1a instanceof LispInteger) {
            BigInteger m;
            BigInteger b = c1a.getBigInteger();
            BigInteger t = m = BigInteger.valueOf(-1L);
            if ((c %= e - s) < 0) {
                c += e - s;
            }
            m = m.shiftLeft(e - s).not().shiftLeft(s);
            BigInteger f = b.and(m);
            if (c == 0) {
                return c1a;
            }
            t = t.shiftLeft(c).not().shiftLeft(e - c);
            BigInteger d = f.and(t).shiftRight(e - s - c);
            f = f.shiftLeft(c).or(d);
            return LispInteger.valueOf(b.andNot(m).or(f.and(m)));
        }
        throw mesg.getError("err.require.int", c1a);
    }
}

