/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.automata.nfa;

import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.morilib.automata.NFA;
import net.morilib.automata.NFAEdges;
import net.morilib.automata.NFAState;
import net.morilib.automata.TextBound;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispCharacter;
import net.morilib.lisp.automata.ILispConfiguration;
import net.morilib.lisp.automata.cfg.LispCFG;
import net.morilib.lisp.automata.cfg.LispCFGRule;
import net.morilib.lisp.automata.nfa.ILispNfa;
import net.morilib.lisp.automata.nfa.LispNfaStates;
import net.morilib.range.Interval;
import net.morilib.range.Range;

public class RegularGrammarNFA
extends Datum2
implements ILispNfa,
NFA<Datum, Datum, Datum> {
    private LispCFG cfg;

    @Override
    public boolean isState(NFAState o) {
        return this.cfg.getVariables().contains(o);
    }

    @Override
    public Set<NFAState> getStates(NFAState state, Datum alphabet) {
        HashSet<NFAState> z = new HashSet<NFAState>();
        for (LispCFGRule r : this.cfg.getRules()) {
            if (!r.getLeftValue().equals(state)) continue;
            List<Datum> l = r.getRightValues();
            Datum a = l.get(0);
            Datum b = l.get(1);
            if (!b.isGrammarVariable()) {
                throw new RuntimeException();
            }
            for (LispCFGRule s : this.cfg.getRules()) {
                if (!s.getLeftValue().equals(a)) continue;
                List<Datum> m = s.getRightValues();
                if (m.isEmpty()) {
                    throw new RuntimeException();
                }
                Datum c = m.get(0);
                if (c.isGrammarVariable()) {
                    throw new RuntimeException();
                }
                if (!c.equals(alphabet)) continue;
                z.add((NFAState)((Object)b));
            }
        }
        return z;
    }

    @Override
    public Set<NFAState> getStates(NFAState state, Range rng) {
        HashSet<NFAState> z = new HashSet<NFAState>();
        for (LispCFGRule r : this.cfg.getRules()) {
            if (!r.getLeftValue().equals(state)) continue;
            List<Datum> l = r.getRightValues();
            Datum a = l.get(0);
            Datum b = l.get(1);
            if (!b.isGrammarVariable()) {
                throw new RuntimeException();
            }
            for (LispCFGRule s : this.cfg.getRules()) {
                if (!s.getLeftValue().equals(a)) continue;
                List<Datum> m = s.getRightValues();
                if (m.isEmpty()) {
                    throw new RuntimeException();
                }
                Datum c = m.get(0);
                if (c.isGrammarVariable()) {
                    throw new RuntimeException();
                }
                if (!rng.contains(c)) continue;
                z.add((NFAState)((Object)b));
            }
        }
        return z;
    }

    @Override
    public Set<NFAState> getStates(NFAState state, EnumSet<TextBound> bound) {
        return Collections.emptySet();
    }

    @Override
    public Set<NFAState> getStatesEpsilon(NFAState state) {
        return Collections.emptySet();
    }

    @Override
    public Set<NFAState> getStatesBound(NFAState state, EnumSet<TextBound> bound) {
        return Collections.emptySet();
    }

    @Override
    public Set<NFAState> getInitialStates() {
        return Collections.singleton(this.cfg.getStartVariable());
    }

    @Override
    public boolean isInitialState(NFAState o) {
        return this.cfg.getStartVariable().equals(o);
    }

    @Override
    public boolean isFinal(NFAState state) {
        return this.isAccepted(state);
    }

    @Override
    public boolean isFinalAny(Set<NFAState> states) {
        for (NFAState s : states) {
            if (!this.isFinal(s)) continue;
            return true;
        }
        return false;
    }

    @Override
    public NFAEdges<Datum> getEdges(NFAState state) {
        final NFAState st = state;
        return new NFAEdges<Datum>(){

            @Override
            public Set<NFAState> goNext(Datum alphabet) {
                return RegularGrammarNFA.this.getStates(st, alphabet);
            }

            @Override
            public Set<NFAState> goNext(int alphabet) {
                return RegularGrammarNFA.this.getStates(st, LispCharacter.valueOf(alphabet));
            }

            @Override
            public Set<NFAState> goNext(char alphabet) {
                return RegularGrammarNFA.this.getStates(st, LispCharacter.valueOf(alphabet));
            }

            @Override
            public Set<NFAState> goNextEpsilon() {
                return RegularGrammarNFA.this.getStatesEpsilon(st);
            }

            @Override
            public Set<? extends Range> nextAlphabets() {
                return RegularGrammarNFA.this.nextAlphabets(st);
            }

            @Override
            public boolean isNextEpsilon() {
                return false;
            }
        };
    }

    @Override
    public Set<Interval> nextAlphabets(NFAState state) {
        HashSet<Interval> z = new HashSet<Interval>();
        for (Datum d : this.nextDiscreteAlphabets(state)) {
            z.add(Interval.newPoint(d));
        }
        return z;
    }

    @Override
    public Iterable<Interval> nextAlphabets(Set<NFAState> states) {
        HashSet<Interval> z = new HashSet<Interval>();
        for (NFAState s : states) {
            z.addAll(this.nextAlphabets(s));
        }
        return z;
    }

    @Override
    public Set<Datum> nextDiscreteAlphabets(NFAState state) {
        HashSet<Datum> z = new HashSet<Datum>();
        for (LispCFGRule r : this.cfg.getRules()) {
            if (!r.getLeftValue().equals(state)) continue;
            List<Datum> l = r.getRightValues();
            Datum a = l.get(0);
            if (!l.get(1).isGrammarVariable()) {
                throw new RuntimeException();
            }
            for (LispCFGRule s : this.cfg.getRules()) {
                if (!s.getLeftValue().equals(a)) continue;
                List<Datum> m = s.getRightValues();
                if (m.isEmpty()) {
                    throw new RuntimeException();
                }
                Datum c = m.get(0);
                if (c.isGrammarVariable()) {
                    throw new RuntimeException();
                }
                z.add(c);
            }
        }
        return z;
    }

    @Override
    public Iterable<Datum> nextDiscreteAlphabets(Set<NFAState> states) {
        HashSet<Datum> z = new HashSet<Datum>();
        for (NFAState s : states) {
            z.addAll(this.nextDiscreteAlphabets(s));
        }
        return z;
    }

    @Override
    public Set<NFAState> getAcceptedStates() {
        HashSet<NFAState> z = new HashSet<NFAState>();
        for (LispCFGRule r : this.cfg.getRules()) {
            List<Datum> l = r.getRightValues();
            Datum b = l.get(1);
            if (!b.isGrammarVariable()) {
                throw new RuntimeException();
            }
            for (LispCFGRule s : this.cfg.getRules()) {
                if (!s.getLeftValue().equals(b) || s.getRightValues().size() != 1) continue;
                z.add((NFAState)((Object)b));
            }
        }
        return z;
    }

    @Override
    public Set<Datum> getMatchTag(NFAState state) {
        return Collections.emptySet();
    }

    @Override
    public Set<Datum> getMatchTagEnd(NFAState state) {
        return Collections.emptySet();
    }

    @Override
    public Set<Datum> getAccept(NFAState state) {
        if (this.isAccepted(state)) {
            return Collections.singleton(LispBoolean.TRUE);
        }
        return Collections.emptySet();
    }

    @Override
    public boolean isAccepted(NFAState state) {
        for (LispCFGRule r : this.cfg.getRules()) {
            if (!r.getLeftValue().equals(state)) continue;
            List<Datum> l = r.getRightValues();
            Datum b = l.get(1);
            if (!b.isGrammarVariable()) {
                throw new RuntimeException();
            }
            for (LispCFGRule s : this.cfg.getRules()) {
                if (!s.getLeftValue().equals(b) || s.getRightValues().size() != 1) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public ILispConfiguration getInitial() {
        return new LispNfaStates(this, this.getInitialStates());
    }

    @Override
    public NFA<Datum, ?, ?> getNFA() {
        return this;
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<regular-grammar-nfa>");
    }
}

