/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.automata.lr;

import java.util.LinkedList;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispCharacter;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Nil;
import net.morilib.lisp.Procedure;
import net.morilib.lisp.Scheme;
import net.morilib.lisp.automata.ILispConfiguration;
import net.morilib.lisp.automata.cfg.LispCFGRule;
import net.morilib.lisp.automata.lr.ILispLRTable;
import net.morilib.util.ArrayListStack;

public class LispLRParser
extends Datum2
implements ILispConfiguration {
    private ILispLRTable table;
    private ArrayListStack<Datum> synstack;
    private ArrayListStack<Datum> semstack;
    private Procedure action;
    private Environment env;
    private boolean error;
    private boolean accept;

    public LispLRParser(ILispLRTable table, Procedure action, Environment env) {
        this.table = table;
        this.action = action;
        this.synstack = new ArrayListStack();
        this.semstack = new ArrayListStack();
        this.env = env;
        this.error = false;
        this.accept = false;
        this.synstack.push(table.getInitialState());
    }

    LispLRParser(LispLRParser p) {
        this.table = p.table;
        this.action = p.action;
        this.synstack = new ArrayListStack<Datum>(p.synstack);
        this.semstack = new ArrayListStack<Datum>(p.semstack);
        this.env = p.env;
        this.error = p.error;
        this.accept = p.accept;
    }

    private Datum callaction(LispCFGRule r, LispMessage mesg) {
        if (this.action == null) {
            return LispBoolean.FALSE;
        }
        int n = r.getRightValues().size();
        LinkedList<Datum> l = new LinkedList<Datum>();
        int i = 0;
        while (i < n) {
            Datum x = this.semstack.pop();
            l.add(0, x);
            ++i;
        }
        return Scheme.call(this.action, this.env, mesg, LispUtils.listToCons(l));
    }

    public ILispConfiguration goSideEffect(Datum a, Datum b, LispMessage mesg) {
        Datum s = this.synstack.peek();
        while (true) {
            if (this.error) {
                return this;
            }
            if (this.accept) {
                this.error = true;
                this.accept = false;
                return this;
            }
            Datum x = this.table.getShift(s, a);
            if (x != null) {
                this.synstack.push(x);
                this.semstack.push(b);
                return this;
            }
            LispCFGRule r = this.table.getReduce(s, a);
            if (r == null) break;
            this.synstack.pop(r.getRightValues().size());
            x = this.synstack.peek();
            s = this.table.getGoto(x, r.getLeftValue());
            if (s == null) {
                throw new RuntimeException();
            }
            this.synstack.push(s);
            this.semstack.push(this.callaction(r, mesg));
        }
        if (this.table.isAccept(s, a)) {
            this.accept = true;
            return this;
        }
        this.error = true;
        return this;
    }

    public ILispConfiguration goSideEffect(int d, Datum b, LispMessage mesg) {
        return this.goSideEffect(LispInteger.valueOf(d), b, mesg);
    }

    public ILispConfiguration goSideEffect(char d, Datum b, LispMessage mesg) {
        return this.goSideEffect(LispCharacter.valueOf(d), b, mesg);
    }

    @Override
    public ILispConfiguration goSideEffect(Datum a, LispMessage mesg) {
        return this.goSideEffect(a, (Datum)Nil.NIL, mesg);
    }

    @Override
    public ILispConfiguration goSideEffect(int d, LispMessage mesg) {
        return this.goSideEffect(LispInteger.valueOf(d), mesg);
    }

    @Override
    public ILispConfiguration goSideEffect(char d, LispMessage mesg) {
        return this.goSideEffect(LispCharacter.valueOf(d), mesg);
    }

    @Override
    public ILispConfiguration go(Datum a, LispMessage mesg) {
        return new LispLRParser(this).goSideEffect(a, mesg);
    }

    @Override
    public ILispConfiguration go(int d, LispMessage mesg) {
        return new LispLRParser(this).goSideEffect(d, mesg);
    }

    @Override
    public ILispConfiguration go(char d, LispMessage mesg) {
        return new LispLRParser(this).goSideEffect(d, mesg);
    }

    @Override
    public boolean isInitialState() {
        return this.synstack.size() == 1 && !this.error && !this.accept;
    }

    @Override
    public boolean isDead() {
        return this.error;
    }

    @Override
    public boolean isAccepted() {
        return this.accept;
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<lr-parser>");
    }
}

