/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.automata.lr;

import java.util.List;
import net.morilib.lang.Hashes;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.automata.LispGrammarVariable;
import net.morilib.lisp.automata.cfg.LispCFG;
import net.morilib.lisp.automata.cfg.LispCFGRule;
import net.morilib.lisp.automata.lr.LispLR0Item;
import net.morilib.util.Objects;

public class LispLR1Item
extends Datum2 {
    LispCFGRule rule;
    int mark;
    Datum lookahead;

    public LispLR1Item(LispCFGRule rule, int mark, Datum lookahead) {
        if (rule == null) {
            throw new NullPointerException();
        }
        if (mark < 0 || mark > rule.getRightValues().size()) {
            throw new IllegalArgumentException();
        }
        this.rule = rule;
        this.mark = mark;
        this.lookahead = lookahead;
    }

    public LispLR1Item(LispLR0Item item, Datum lookahead) {
        if (item == null) {
            throw new NullPointerException();
        }
        this.rule = item.rule;
        this.mark = item.mark;
        this.lookahead = lookahead;
    }

    public LispGrammarVariable getLeftValue() {
        return this.rule.getLeftValue();
    }

    public List<Datum> getRightValues() {
        return this.rule.getRightValues();
    }

    public LispCFGRule getRule() {
        return this.rule;
    }

    public Datum getLookahead() {
        return this.lookahead;
    }

    public int getMark() {
        return this.mark;
    }

    public boolean maybeKernel() {
        return this.mark > 0;
    }

    public Datum getIndicated() {
        List<Datum> l = this.rule.getRightValues();
        return this.mark < l.size() ? l.get(this.mark) : null;
    }

    public LispLR1Item shiftRight() {
        if (this.mark < this.rule.getRightValues().size()) {
            return new LispLR1Item(this.rule, this.mark + 1, this.lookahead);
        }
        throw new IllegalStateException();
    }

    public boolean isAccepted(LispCFG cfg) {
        return this.rule.getLeftValue().equals(cfg.getStartVariable()) && this.getIndicated() == null;
    }

    public int hashCode() {
        int r = 17;
        r = (r + this.rule.hashCode()) * 37;
        r = (r + this.mark) * 37;
        return r + Hashes.hashCode(this.lookahead);
    }

    public boolean equals(Object o) {
        if (o instanceof LispLR1Item) {
            LispLR1Item r = (LispLR1Item)o;
            return this.rule.equals(r.rule) && this.mark == r.mark && Objects.equals(this.lookahead, r.lookahead);
        }
        return false;
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        List<Datum> l = this.rule.getRightValues();
        String d = "";
        buf.append("{").append(this.rule.getLeftValue()).append(" -> ");
        int i = 0;
        while (i < l.size()) {
            buf.append(d);
            if (i == this.mark) {
                buf.append("*");
            }
            buf.append(LispUtils.print(l.get(i)));
            d = " ";
            ++i;
        }
        buf.append(",").append(LispUtils.print(this.lookahead)).append("}");
    }
}

