/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.automata.lr;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.automata.LispGrammarVariable;
import net.morilib.lisp.automata.cfg.LispCFG;
import net.morilib.lisp.automata.cfg.LispCFGRule;
import net.morilib.lisp.automata.lr.LispLR0Item;

public class LispLR0Items
extends Datum2 {
    Set<LispLR0Item> items;

    public LispLR0Items(Collection<LispLR0Item> items) {
        this.items = new HashSet<LispLR0Item>(items);
    }

    public LispLR0Items(LispLR0Item ... items) {
        this(Arrays.asList(items));
    }

    public Set<LispLR0Item> getItems() {
        return Collections.unmodifiableSet(this.items);
    }

    public Set<LispLR0Item> getKernelItems(LispCFG cfg) {
        HashSet<LispLR0Item> s = new HashSet<LispLR0Item>();
        LispGrammarVariable st = cfg.getStartVariable();
        for (LispLR0Item i : this.items) {
            if (i.maybeKernel()) {
                s.add(i);
                continue;
            }
            if (!i.getLeftValue().equals(st)) continue;
            s.add(i);
        }
        return s;
    }

    public static Set<LispLR0Item> getClosure(LispCFG cfg, Set<LispLR0Item> si) {
        boolean c = true;
        while (c) {
            c = false;
            HashSet<LispLR0Item> sj = new HashSet<LispLR0Item>(si);
            for (LispLR0Item i : si) {
                Datum d = i.getIndicated();
                if (d == null) continue;
                for (LispCFGRule r : cfg.getRules()) {
                    if (!r.getLeftValue().equals(d)) continue;
                    c |= sj.add(new LispLR0Item(r, 0));
                }
            }
            si = sj;
        }
        return si;
    }

    public LispLR0Items getClosure(LispCFG cfg) {
        return new LispLR0Items(LispLR0Items.getClosure(cfg, this.items));
    }

    public boolean isStart(LispCFG cfg) {
        for (LispLR0Item s : this.items) {
            if (!s.getLeftValue().equals(cfg.getStartVariable()) || s.getMark() != 0) continue;
            return true;
        }
        return false;
    }

    public boolean isAccepted(LispCFG cfg) {
        for (LispLR0Item s : this.items) {
            if (!s.getLeftValue().equals(cfg.getStartVariable()) || s.getIndicated() != null) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.items.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof LispLR0Items) {
            return this.items.equals(((LispLR0Items)o).items);
        }
        return false;
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        String d = "";
        buf.append("{");
        for (LispLR0Item i : this.items) {
            buf.append(d).append(i);
            d = " ";
        }
        buf.append("}");
    }
}

