/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.automata.lr;

import java.util.List;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.automata.LispGrammarVariable;
import net.morilib.lisp.automata.cfg.LispCFGRule;

public class LispLR0Item
extends Datum2 {
    LispCFGRule rule;
    int mark;

    public LispLR0Item(LispCFGRule rule, int mark) {
        if (mark < 0 || mark > rule.getRightValues().size()) {
            throw new IllegalArgumentException();
        }
        this.rule = rule;
        this.mark = mark;
    }

    public LispGrammarVariable getLeftValue() {
        return this.rule.getLeftValue();
    }

    public List<Datum> getRightValues() {
        return this.rule.getRightValues();
    }

    public int getMark() {
        return this.mark;
    }

    public boolean maybeKernel() {
        return this.mark > 0;
    }

    public Datum getIndicated() {
        List<Datum> l = this.rule.getRightValues();
        return this.mark < l.size() ? l.get(this.mark) : null;
    }

    public LispLR0Item shiftRight() {
        if (this.mark < this.rule.getRightValues().size()) {
            return new LispLR0Item(this.rule, this.mark + 1);
        }
        throw new IllegalStateException();
    }

    public int hashCode() {
        int r = 17;
        r = (r + this.rule.hashCode()) * 37;
        return r + this.mark;
    }

    public boolean equals(Object o) {
        if (o instanceof LispLR0Item) {
            LispLR0Item r = (LispLR0Item)o;
            return this.rule.equals(r.rule) && this.mark == r.mark;
        }
        return false;
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        List<Datum> l = this.rule.getRightValues();
        String d = "";
        buf.append("{").append(this.rule.getLeftValue()).append(" -> ");
        int i = 0;
        while (i < l.size()) {
            buf.append(d);
            if (i == this.mark) {
                buf.append("*");
            }
            buf.append(LispUtils.print(l.get(i)));
            d = " ";
            ++i;
        }
        buf.append("}");
    }
}

