/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.automata.legacy.lalr;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.morilib.automata.lr.ContextFreeGrammar;
import net.morilib.automata.lr.ContextFreeReduceAction;
import net.morilib.automata.lr.ContextFreeRule;
import net.morilib.automata.lr.GrammarSymbol;
import net.morilib.automata.lr.LALR1Items;
import net.morilib.automata.lr.LALR1Table;
import net.morilib.automata.lr.LR1Table;
import net.morilib.automata.lr.LRParseException;
import net.morilib.automata.lr.LRParser;
import net.morilib.automata.lr.LexicalAnalyser;
import net.morilib.automata.lr.Nonterminal;
import net.morilib.automata.lr.SemanticAttributes;
import net.morilib.automata.lr.Terminal;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.ConsListBuilder;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.MultiValues;
import net.morilib.lisp.Nil;
import net.morilib.lisp.Procedure;
import net.morilib.lisp.Scheme;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.Undef;
import net.morilib.lisp.subr.BinaryArgs;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.subr.UnaryArgs;
import net.morilib.util.mapset.HashOneToOneSet;
import net.morilib.util.mapset.OneToOneSet;

public class LispGrammar
extends Datum2 {
    private static final Nonterminal START_SYM = new NTer();
    private OneToOneSet<Datum, Terminal> terminals = new HashOneToOneSet<Datum, Terminal>();
    private OneToOneSet<Datum, Nonterminal> nonterminals = new HashOneToOneSet<Datum, Nonterminal>();
    private LALR1Table table;
    private LRParser<Datum> parser;

    private LispGrammar() {
        this.nonterminals.put(Symbol.getSymbol("S"), START_SYM);
    }

    private Datum parse(Procedure c2a, Environment env, LispMessage mesg) throws LRParseException {
        return this.parser.parse(new Lexer(c2a, env, mesg));
    }

    private Nonterminal putIfAbsentNonterminal(Datum nt) {
        Nonterminal t0 = (Nonterminal)this.nonterminals.getValue(nt);
        if (t0 == null) {
            t0 = new NTer();
            this.nonterminals.put(nt, t0);
        }
        return t0;
    }

    private Terminal putIfAbsentTerminal(Datum d) {
        Terminal t0 = (Terminal)this.terminals.getValue(d);
        if (t0 == null) {
            t0 = new Ter();
            this.terminals.put(d, t0);
        }
        return t0;
    }

    private Datum symbolToDatum(GrammarSymbol s) {
        Datum d = (Datum)this.terminals.getKey(s);
        if (d == null) {
            d = (Datum)this.nonterminals.getKey(s);
        }
        return d;
    }

    private Datum ruleToList(ContextFreeRule r) {
        ConsListBuilder b1 = new ConsListBuilder();
        ConsListBuilder b2 = new ConsListBuilder();
        b1.append((Datum)this.nonterminals.getKey(r.getLeftSymbol()));
        int i = 0;
        while (i < r.getDerivedSymbolLength()) {
            b2.append(this.symbolToDatum(r.getDerivedSymbol(i)));
            ++i;
        }
        b1.append(b2.get());
        return b1.get();
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<grammar>");
    }

    /* synthetic */ LispGrammar(LispGrammar lispGrammar) {
        this();
    }

    public static class GetConflicts
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof LispGrammar) {
                LispGrammar g = (LispGrammar)c1a;
                ConsListBuilder b = new ConsListBuilder();
                for (LR1Table.Conflict ci : g.table.getConflicts()) {
                    ConsListBuilder b2 = new ConsListBuilder();
                    if (ci.isShiftReduce()) {
                        b2.append(Symbol.getSymbol("shift-reduce"));
                        b2.append((Datum)g.terminals.getKey(ci.getShiftSymbol()));
                        b2.append(g.ruleToList(ci.getReduceRule()));
                    } else {
                        b2.append(Symbol.getSymbol("reduce-reduce"));
                        b2.append(g.ruleToList(ci.getReduceRule()));
                        b2.append(g.ruleToList(ci.getReduceRule2()));
                    }
                    b.append(b2.get());
                }
                return b.get();
            }
            throw mesg.getError("err.grammar.require.grammar", c1a);
        }
    }

    private class Lexer
    implements LexicalAnalyser<Datum> {
        private Procedure proc;
        private Environment env;
        private LispMessage mesg;
        private Datum before;
        private Datum semval;

        private Lexer(Procedure p, Environment e, LispMessage m) {
            this.proc = p;
            this.env = e;
            this.mesg = m;
            this.next();
        }

        private void next() {
            Datum d = Scheme.callva(this.proc, this.env, this.mesg, new Datum[0]);
            if (d instanceof MultiValues) {
                List<Datum> vs = ((MultiValues)d).getValues();
                if (vs.size() == 0) {
                    throw this.mesg.getError("err.grammar.unknowntermial", Nil.NIL);
                }
                this.semval = vs.size() > 1 ? vs.get(1) : Undef.UNDEF;
                this.before = vs.get(0);
            } else {
                this.semval = Undef.UNDEF;
                this.before = d;
            }
        }

        @Override
        public boolean isEnded() {
            return !this.before.isTrue();
        }

        @Override
        public LexicalAnalyser.Token<Datum> nextToken() {
            Datum s0 = this.semval;
            if (this.isEnded()) {
                return LexicalAnalyser.Token.endMarker();
            }
            Terminal t0 = (Terminal)LispGrammar.this.terminals.getValue(this.before);
            if (t0 == null) {
                throw this.mesg.getError("err.grammar.unknowntermial", this.before);
            }
            this.next();
            return new LexicalAnalyser.Token<Datum>(t0, s0);
        }
    }

    public static class MakeGrammar
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(c1a);
            ArrayList<Datum> nls = new ArrayList<Datum>();
            ArrayList<Datum> tls = new ArrayList<Datum>();
            ArrayList<Procedure> als = new ArrayList<Procedure>();
            ArrayList<ContextFreeRule> rls = new ArrayList<ContextFreeRule>();
            LispGrammar grm = new LispGrammar(null);
            final Environment ev2 = env;
            final LispMessage mg2 = mesg;
            while (itr.hasNext()) {
                Datum d1 = itr.next();
                ConsIterator it2 = new ConsIterator(d1);
                Datum nt = SubrUtils.nextIf((Iterator<Datum>)it2, mesg, "err.grammar.invalidrule", d1);
                nls.add(nt);
                grm.putIfAbsentNonterminal(nt);
                Datum gl = SubrUtils.nextIf((Iterator<Datum>)it2, mesg, "err.grammar.invalidrule", d1);
                tls.add(gl);
                Datum pr = SubrUtils.nextIf((Iterator<Datum>)it2, mesg, "err.grammar.invalidrule", d1);
                if (!(pr instanceof Procedure)) {
                    throw mesg.getError("err.require.procedure", pr);
                }
                als.add((Procedure)((Object)pr));
            }
            SubrUtils.checkTerminated(itr, c1a, mesg);
            int i = 0;
            while (i < nls.size()) {
                ConsIterator it3 = new ConsIterator((Datum)tls.get(i));
                ArrayList<GrammarSymbol> gs = new ArrayList<GrammarSymbol>();
                while (it3.hasNext()) {
                    Datum d3 = it3.next();
                    if (grm.nonterminals.containsKey(d3)) {
                        gs.add((GrammarSymbol)grm.nonterminals.getValue(d3));
                        continue;
                    }
                    gs.add(grm.putIfAbsentTerminal(d3));
                }
                SubrUtils.checkTerminated(it3, (Datum)tls.get(i), mesg);
                ContextFreeRule cfr = new ContextFreeRule((Nonterminal)grm.nonterminals.getValue(nls.get(i)), gs.toArray(new GrammarSymbol[0]));
                rls.add(cfr);
                ++i;
            }
            ContextFreeGrammar cfg = ContextFreeGrammar.newInstance(new HashSet<ContextFreeRule>(rls), START_SYM);
            LALR1Items itm = LALR1Items.newLALR(cfg);
            grm.table = new LALR1Table(itm);
            grm.parser = new LRParser(grm.table);
            i = 0;
            while (i < rls.size()) {
                final Procedure pc = (Procedure)als.get(i);
                ContextFreeReduceAction<Datum> rac = new ContextFreeReduceAction<Datum>(){

                    @Override
                    public Datum action(ContextFreeRule event, SemanticAttributes<Datum> attrs) {
                        int s0 = event.getDerivedSymbolLength();
                        Datum[] ds = new Datum[s0];
                        int i = 0;
                        while (i < s0) {
                            ds[i] = attrs.get(i);
                            ++i;
                        }
                        return Scheme.callva(pc, ev2, mg2, ds);
                    }
                };
                grm.parser.setAction((ContextFreeRule)rls.get(i), rac);
                ++i;
            }
            return grm;
        }
    }

    private static class NTer
    implements Nonterminal {
        private NTer() {
        }
    }

    public static class ParseGrammar
    extends BinaryArgs {
        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            if (!(c1a instanceof LispGrammar)) {
                throw mesg.getError("err.grammar.require.grammar", c1a);
            }
            if (!(c2a instanceof Procedure)) {
                throw mesg.getError("err.require.procedure", c2a);
            }
            try {
                return ((LispGrammar)c1a).parse((Procedure)((Object)c2a), env, mesg);
            }
            catch (LRParseException e) {
                throw mesg.getError("err.grammar.parseerror");
            }
        }
    }

    private static class Ter
    implements Terminal {
        private Ter() {
        }
    }
}

