/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.automata.dfa;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.LispCharacter;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.automata.dfa.ILispDfaState;

public class LispParallelDfaState
extends Datum2
implements ILispDfaState {
    private ILispDfaState[] states;

    public LispParallelDfaState(Collection<ILispDfaState> states) {
        this.states = states.toArray(new ILispDfaState[0]);
    }

    public LispParallelDfaState(ILispDfaState ... states) {
        this(Arrays.asList(states));
    }

    @Override
    public boolean isInitialState() {
        ILispDfaState[] iLispDfaStateArray = this.states;
        int n = this.states.length;
        int n2 = 0;
        while (n2 < n) {
            ILispDfaState x = iLispDfaStateArray[n2];
            if (!x.isInitialState()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public boolean isDead() {
        ILispDfaState[] iLispDfaStateArray = this.states;
        int n = this.states.length;
        int n2 = 0;
        while (n2 < n) {
            ILispDfaState x = iLispDfaStateArray[n2];
            if (!x.isDead()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public boolean isAccepted() {
        ILispDfaState[] iLispDfaStateArray = this.states;
        int n = this.states.length;
        int n2 = 0;
        while (n2 < n) {
            ILispDfaState x = iLispDfaStateArray[n2];
            if (x.isAccepted()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    @Override
    public ILispDfaState go(Datum d, LispMessage mesg) {
        ArrayList<ILispDfaState> r = new ArrayList<ILispDfaState>();
        ILispDfaState[] iLispDfaStateArray = this.states;
        int n = this.states.length;
        int n2 = 0;
        while (n2 < n) {
            ILispDfaState x = iLispDfaStateArray[n2];
            r.add(x.go(d, mesg));
            ++n2;
        }
        return new LispParallelDfaState(r);
    }

    @Override
    public ILispDfaState go(int d, LispMessage mesg) {
        return this.go(LispInteger.valueOf(d), mesg);
    }

    @Override
    public ILispDfaState go(char d, LispMessage mesg) {
        return this.go(LispCharacter.valueOf(d), mesg);
    }

    @Override
    public ILispDfaState goSideEffect(Datum d, LispMessage mesg) {
        return this.go(d, mesg);
    }

    @Override
    public ILispDfaState goSideEffect(int d, LispMessage mesg) {
        return this.go(d, mesg);
    }

    @Override
    public ILispDfaState goSideEffect(char d, LispMessage mesg) {
        return this.go(d, mesg);
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<dfa-parallel-state>");
    }
}

