/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.automata.dfa;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.morilib.automata.DFAState;
import net.morilib.automata.dfa.DFAs;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.automata.dfa.ILispDatumDfa;
import net.morilib.lisp.automata.dfa.ILispDfaState;
import net.morilib.lisp.automata.dfa.LispSimpleDfaState;
import net.morilib.util.set.PairSet;

public abstract class AbstractLispDatumDfa
extends Datum2
implements ILispDatumDfa {
    private transient Set<DFAState<Datum, ?, ?>> st2 = null;
    private transient Set<ILispDfaState> states = null;
    private transient Set<PairSet<DFAState<Datum, ?, ?>>> equiv = null;
    private transient boolean empty = false;

    @Override
    public synchronized Set<ILispDfaState> getReachableStates() {
        if (this.states == null) {
            this.states = new HashSet<ILispDfaState>();
            this.st2 = DFAs.getReachableStatesDiscrete(this.getDFA());
            this.empty = DFAs.isEmptyDiscrete(this.getDFA());
            for (DFAState<Datum, ?, ?> x : this.st2) {
                if (x instanceof ILispDfaState) {
                    this.states.add((ILispDfaState)((Object)x));
                    continue;
                }
                this.states.add(new LispSimpleDfaState(x));
            }
        }
        return Collections.unmodifiableSet(this.states);
    }

    @Override
    public synchronized boolean isEmpty() {
        this.getReachableStates();
        return this.empty;
    }

    @Override
    public synchronized boolean isEquvalent(Datum a, Datum b) {
        if (this.equiv == null) {
            this.equiv = DFAs.getEquivalentStatesDiscrete(this.getDFA());
        }
        Object x = a instanceof LispSimpleDfaState ? ((LispSimpleDfaState)a).state : a;
        Object y = b instanceof LispSimpleDfaState ? ((LispSimpleDfaState)b).state : b;
        this.getReachableStates();
        if (this.st2.contains(x) && this.st2.contains(y) && (this.empty || x.equals(y))) {
            return true;
        }
        for (PairSet<DFAState<Datum, ?, ?>> s : this.equiv) {
            if (!s.isPair(x, y)) continue;
            return true;
        }
        return false;
    }
}

