/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.automata.cfg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.automata.ILispFormalGrammarRule;
import net.morilib.lisp.automata.LispGrammarVariable;

public class LispCFGRule
extends Datum2
implements ILispFormalGrammarRule {
    private LispGrammarVariable lvalue;
    private List<Datum> rvalues;

    public LispCFGRule(LispGrammarVariable lvalue, List<Datum> rvalues) {
        this.lvalue = lvalue;
        this.rvalues = new ArrayList<Datum>(rvalues);
    }

    public LispGrammarVariable getLeftValue() {
        return this.lvalue;
    }

    @Override
    public List<Datum> getLeftValues() {
        return Collections.singletonList(this.lvalue);
    }

    @Override
    public List<Datum> getRightValues() {
        return Collections.unmodifiableList(this.rvalues);
    }

    @Override
    public boolean isEpsilonRule() {
        return this.rvalues.isEmpty();
    }

    @Override
    public boolean isUnitRule() {
        return this.rvalues.size() == 1 && this.rvalues.get(0).isGrammarVariable();
    }

    @Override
    public boolean isEquivalentRule(ILispFormalGrammarRule r) {
        return this.getLeftValues().equals(r.getLeftValues()) && this.getRightValues().equals(r.getRightValues());
    }

    public boolean isLeftRecursive() {
        return this.rvalues.size() > 0 && this.lvalue.equals(this.rvalues.get(0));
    }

    public int hashCode() {
        int r = 17;
        r = (r + this.lvalue.hashCode()) * 37;
        return r + this.rvalues.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof LispCFGRule) {
            LispCFGRule r = (LispCFGRule)o;
            return this.lvalue.equals(r.lvalue) && this.rvalues.equals(r.rvalues);
        }
        return false;
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        String d = "";
        buf.append("#<").append(this.lvalue).append(" -> ");
        for (Datum x : this.rvalues) {
            buf.append(d).append(LispUtils.print(x));
            d = " ";
        }
        buf.append(">");
    }
}

