/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.automata.cfg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.automata.ILispFormalGrammar;
import net.morilib.lisp.automata.LispAutomataUtils;
import net.morilib.lisp.automata.LispGrammarVariable;
import net.morilib.lisp.automata.cfg.LispCFGRule;
import net.morilib.lisp.automata.lr.LispLR0Item;
import net.morilib.lisp.automata.lr.LispLR0Items;

public class LispCFG
extends Datum2
implements ILispFormalGrammar {
    private LispGrammarVariable start;
    private Set<LispCFGRule> rules;
    private transient Map<Datum, Set<Datum>> firsts = null;
    private transient Map<Datum, Set<Datum>> follows = null;

    public LispCFG(LispGrammarVariable start, Set<LispCFGRule> rules) {
        this.start = start;
        this.rules = new HashSet<LispCFGRule>(rules);
    }

    public Set<LispCFGRule> getRules() {
        return Collections.unmodifiableSet(this.rules);
    }

    @Override
    public LispGrammarVariable getStartVariable() {
        return this.start;
    }

    boolean isNullableRecursive(Set<Datum> s, Datum v) {
        block0: for (LispCFGRule r : this.rules) {
            if (!r.getLeftValue().equals(v)) continue;
            for (Datum x : r.getRightValues()) {
                if (!x.isGrammarVariable() || s.contains(x)) continue block0;
                s.add(v);
                if (!this.isNullableRecursive(s, x)) continue block0;
            }
            return true;
        }
        return false;
    }

    public boolean isNullableRecursive(Datum v) {
        return this.isNullableRecursive(new HashSet<Datum>(), v);
    }

    public boolean isNullable() {
        return this.isNullableRecursive(this.start);
    }

    public boolean isNullable(Datum v) {
        if (!v.isGrammarVariable()) {
            return false;
        }
        for (LispCFGRule r : this.rules) {
            if (!r.getLeftValue().equals(v) || !r.getRightValues().isEmpty()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private Set<LispCFGRule> getNullableR(LispCFGRule r) {
        void var6_6;
        ArrayList w = new ArrayList();
        HashSet<LispCFGRule> rt = new HashSet<LispCFGRule>();
        w.add(new ArrayList());
        List<Datum> a = r.getRightValues();
        boolean bl = false;
        while (var6_6 < a.size()) {
            Datum x = a.get((int)var6_6);
            for (List list : w) {
                list.add(x);
            }
            if (this.isNullable(x)) {
                w.add(new ArrayList<Datum>(a.subList(0, (int)var6_6)));
            }
            ++var6_6;
        }
        for (List list : w) {
            rt.add(new LispCFGRule(r.getLeftValue(), list));
        }
        return rt;
    }

    private Set<LispCFGRule> getUnitR(LispCFGRule r) {
        HashSet<LispCFGRule> rt = new HashSet<LispCFGRule>();
        for (LispCFGRule s : this.rules) {
            Datum d = r.getRightValues().get(0);
            if (!d.equals(s.getLeftValue()) || s.isUnitRule()) continue;
            rt.add(new LispCFGRule(r.getLeftValue(), s.getRightValues()));
        }
        return rt;
    }

    public LispCFG eliminateEpsilonRules() {
        HashSet<LispCFGRule> z = new HashSet<LispCFGRule>();
        for (LispCFGRule r : this.rules) {
            if (r.getRightValues().isEmpty()) continue;
            z.addAll(this.getNullableR(r));
        }
        return new LispCFG(this.start, z);
    }

    public LispCFG eliminateUnitRules() {
        Set<LispCFGRule> rt = this.rules;
        boolean dirty = true;
        while (dirty) {
            dirty = false;
            HashSet<LispCFGRule> z = new HashSet<LispCFGRule>();
            for (LispCFGRule r : rt) {
                if (r.isUnitRule()) {
                    z.addAll(this.getUnitR(r));
                    dirty = true;
                    continue;
                }
                z.add(r);
            }
            rt = z;
        }
        return new LispCFG(this.start, rt);
    }

    private void substterm(Map<Datum, LispCFGRule> tr, List<Datum> l, Set<LispCFGRule> rt) {
        int i = 0;
        while (i < l.size()) {
            Datum x = l.get(i);
            if (!x.isGrammarVariable()) {
                LispCFGRule s = tr.get(x);
                if (s == null) {
                    s = new LispCFGRule(LispGrammarVariable.genvar(), Collections.singletonList(x));
                    tr.put(x, s);
                    rt.add(s);
                }
                l.set(i, s.getLeftValue());
            }
            ++i;
        }
    }

    public LispCFG toCNF() {
        HashMap<Datum, LispCFGRule> tr = new HashMap<Datum, LispCFGRule>();
        HashSet<LispCFGRule> rt = new HashSet<LispCFGRule>();
        LispGrammarVariable v = null;
        LispGrammarVariable w = null;
        LispCFG cfg = this.eliminateEpsilonRules().eliminateUnitRules();
        for (LispCFGRule r : cfg.rules) {
            ArrayList<Datum> l = new ArrayList<Datum>(r.getRightValues());
            if (l.size() > 2) {
                this.substterm(tr, l, rt);
                int i = 0;
                while (i < l.size() - 1) {
                    ArrayList<Datum> m = new ArrayList<Datum>();
                    if (i == 0) {
                        v = LispGrammarVariable.genvar();
                        m.add((Datum)l.get(i));
                        m.add(v);
                        rt.add(new LispCFGRule(r.getLeftValue(), m));
                    } else if (i == l.size() - 2) {
                        m.add((Datum)l.get(i));
                        m.add((Datum)l.get(i + 1));
                        rt.add(new LispCFGRule(v, m));
                    } else {
                        w = LispGrammarVariable.genvar();
                        m.add((Datum)l.get(i));
                        m.add(w);
                        rt.add(new LispCFGRule(v, m));
                        v = w;
                    }
                    ++i;
                }
                continue;
            }
            if (l.size() == 2) {
                this.substterm(tr, l, rt);
                rt.add(new LispCFGRule(r.getLeftValue(), l));
                continue;
            }
            rt.add(r);
        }
        return new LispCFG(this.start, rt);
    }

    private boolean putfirst(Datum x, Datum y) {
        Set<Datum> s = this.firsts.get(x);
        if (s == null) {
            s = new HashSet<Datum>();
            this.firsts.put(x, s);
        }
        return s.add(y);
    }

    private Set<Datum> getfirst(Datum x) {
        Set<Datum> s = this.firsts.get(x);
        return s != null ? s : Collections.emptySet();
    }

    boolean computeFirst1Step() {
        boolean c = false;
        block0: for (LispCFGRule r : this.rules) {
            LispGrammarVariable b = r.getLeftValue();
            List<Datum> l = r.getRightValues();
            for (Datum x : l) {
                if (!x.isGrammarVariable()) {
                    c |= this.putfirst(b, x);
                    continue block0;
                }
                Set<Datum> s = this.getfirst(x);
                for (Datum y : s) {
                    if (y.equals(LispAutomataUtils.EPSILON)) continue;
                    c |= this.putfirst(b, y);
                }
                if (!this.isNullableRecursive(x)) continue block0;
            }
            c |= this.putfirst(b, LispAutomataUtils.EPSILON);
        }
        return c;
    }

    void computeFirst() {
        this.firsts = new HashMap<Datum, Set<Datum>>();
        while (this.computeFirst1Step()) {
        }
    }

    public Set<Datum> getFirst(Datum d) {
        if (this.firsts == null) {
            this.computeFirst();
        }
        if (d.isGrammarVariable()) {
            return new HashSet<Datum>(this.getfirst(d));
        }
        return Collections.singleton(d);
    }

    public Set<Datum> getFirst(List<Datum> l) {
        HashSet<Datum> s = new HashSet<Datum>();
        if (this.firsts == null) {
            this.computeFirst();
        }
        for (Datum x : l) {
            if (x != null && !x.isGrammarVariable()) {
                s.add(x);
                return s;
            }
            Set<Datum> t = this.getfirst(x);
            for (Datum y : t) {
                if (y.equals(LispAutomataUtils.EPSILON)) continue;
                s.add(y);
            }
            if (this.isNullableRecursive(x)) continue;
            return s;
        }
        s.add(LispAutomataUtils.EPSILON);
        return s;
    }

    public Set<Datum> getFirst(Datum ... l) {
        return this.getFirst(Arrays.asList(l));
    }

    private boolean putfollow(Datum x, Set<Datum> y) {
        boolean c = false;
        Set<Datum> s = this.follows.get(x);
        if (s == null) {
            s = new HashSet<Datum>();
            this.follows.put(x, s);
        }
        for (Datum a : y) {
            if (a.equals(LispAutomataUtils.EPSILON)) continue;
            c |= s.add(a);
        }
        return c;
    }

    private Set<Datum> getfollow(Datum x) {
        Set<Datum> s = this.follows.get(x);
        return s != null ? s : Collections.emptySet();
    }

    boolean computeFollow1Step() {
        boolean c = false;
        for (LispCFGRule r : this.rules) {
            LispGrammarVariable b = r.getLeftValue();
            List<Datum> l = r.getRightValues();
            int i = 0;
            while (i < l.size()) {
                Set<Datum> s = this.getFirst(l.subList(i + 1, l.size()));
                if (i < l.size() - 1) {
                    c |= this.putfollow(l.get(i), s);
                }
                if (s.contains(LispAutomataUtils.EPSILON)) {
                    c |= this.putfollow(l.get(i), this.getfollow(b));
                }
                ++i;
            }
        }
        return c;
    }

    void computeFollow() {
        this.follows = new HashMap<Datum, Set<Datum>>();
        this.putfollow(this.start, Collections.singleton(LispAutomataUtils.ENDMARKER));
        while (this.computeFollow1Step()) {
        }
    }

    public Set<Datum> getFollow(Datum d) {
        if (this.follows == null) {
            this.computeFollow();
        }
        if (d.isGrammarVariable()) {
            return new HashSet<Datum>(this.getfollow(d));
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Set<LispGrammarVariable> getVariables() {
        HashSet<LispGrammarVariable> s = new HashSet<LispGrammarVariable>();
        for (LispCFGRule r : this.rules) {
            s.add(r.getLeftValue());
            for (Datum x : r.getRightValues()) {
                if (!x.isGrammarVariable()) continue;
                s.add((LispGrammarVariable)x);
            }
        }
        return s;
    }

    public Set<Datum> getTerminals() {
        HashSet<Datum> s = new HashSet<Datum>();
        for (LispCFGRule r : this.rules) {
            for (Datum x : r.getRightValues()) {
                if (x.isGrammarVariable()) continue;
                s.add(x);
            }
        }
        return s;
    }

    public boolean isValid() {
        Set<LispGrammarVariable> s = this.getVariables();
        boolean c = true;
        while (c) {
            c = false;
            block1: for (LispCFGRule r : this.rules) {
                for (Datum x : r.getRightValues()) {
                    if (x.isGrammarVariable() && s.contains(x)) continue block1;
                }
                c = s.remove(r.getLeftValue());
            }
        }
        return s.isEmpty();
    }

    private void getvariables2(List<LispGrammarVariable> l, Datum d) {
        for (LispCFGRule r : this.rules) {
            if (!r.getLeftValue().equals(d)) continue;
            for (Datum x : r.getRightValues()) {
                if (!x.isGrammarVariable() || l.contains(x)) continue;
                l.add((LispGrammarVariable)x);
                this.getvariables2(l, x);
            }
        }
    }

    Set<LispCFGRule> eliminateDirectLeftRecursion(Set<LispCFGRule> rs, Datum a) {
        LispGrammarVariable v = LispGrammarVariable.genvar();
        HashSet<LispCFGRule> rt = new HashSet<LispCFGRule>();
        Iterator<LispCFGRule> i = rs.iterator();
        while (i.hasNext()) {
            LispCFGRule r = i.next();
            LispCFGRule n = null;
            ArrayList<Datum> l = new ArrayList<Datum>();
            if (r.getLeftValue().equals(a) && !r.isEpsilonRule()) {
                if (r.isLeftRecursive()) {
                    List<Datum> m = r.getRightValues();
                    l.addAll(m.subList(1, m.size()));
                    l.add(v);
                    n = new LispCFGRule(v, l);
                    i.remove();
                } else {
                    l.addAll(r.getRightValues());
                    l.add(v);
                    n = new LispCFGRule(r.getLeftValue(), l);
                    i.remove();
                }
            }
            if (n == null) continue;
            rt.add(n);
        }
        rt.add(new LispCFGRule(v, Collections.<Datum>emptyList()));
        return rt;
    }

    public LispCFG eliminateLeftRecursion() {
        LispCFG ee = this.eliminateEpsilonRules();
        ArrayList<LispGrammarVariable> ll = new ArrayList<LispGrammarVariable>();
        HashSet<LispCFGRule> s = new HashSet<LispCFGRule>(ee.getRules());
        ll.add(this.start);
        this.getvariables2(ll, this.start);
        int i = 0;
        while (i < ll.size()) {
            int j = 0;
            while (j < i) {
                HashSet<LispCFGRule> t = new HashSet<LispCFGRule>();
                Iterator itr = s.iterator();
                while (itr.hasNext()) {
                    LispCFGRule r = (LispCFGRule)itr.next();
                    List<Datum> m = r.getRightValues();
                    if (!r.getLeftValue().equals(ll.get(i)) || !m.get(0).equals(ll.get(j))) continue;
                    boolean c = false;
                    for (LispCFGRule a : s) {
                        if (!a.getLeftValue().equals(ll.get(j))) continue;
                        ArrayList<Datum> l = new ArrayList<Datum>();
                        l.addAll(a.getRightValues());
                        l.addAll(m.subList(1, m.size()));
                        LispCFGRule e = new LispCFGRule(r.getLeftValue(), l);
                        if (s.contains(e)) continue;
                        t.add(e);
                        c = true;
                    }
                    if (!c) continue;
                    itr.remove();
                }
                s.addAll(t);
                ++j;
            }
            s.addAll(this.eliminateDirectLeftRecursion(s, (Datum)ll.get(i)));
            ++i;
        }
        LispCFG rr = new LispCFG(this.start, s);
        rr = rr.eliminateUselessRules();
        rr = rr.addEpsilonRules();
        rr = rr.eliminateCommonRules();
        return rr;
    }

    public boolean isUseless(Datum v) {
        boolean a = false;
        if (!v.isGrammarVariable()) {
            return false;
        }
        for (LispCFGRule r : this.rules) {
            if (!r.getLeftValue().equals(v)) continue;
            if (r.getRightValues().isEmpty()) {
                a = true;
                continue;
            }
            return false;
        }
        return a;
    }

    public boolean isUnused(Datum v) {
        if (!v.isGrammarVariable()) {
            return false;
        }
        for (LispCFGRule r : this.rules) {
            if (!r.getLeftValue().equals(v)) continue;
            return false;
        }
        return true;
    }

    public LispCFG eliminateUselessRules() {
        HashSet<LispCFGRule> ss = new HashSet<LispCFGRule>();
        for (LispCFGRule r : this.rules) {
            if (this.isUseless(r.getLeftValue())) continue;
            List<Datum> l = r.getRightValues();
            ArrayList<Datum> m = new ArrayList<Datum>(l);
            int i = 0;
            while (i < l.size()) {
                if (this.isUseless(l.get(i))) {
                    m.remove(i);
                }
                ++i;
            }
            ss.add(new LispCFGRule(r.getLeftValue(), m));
        }
        return new LispCFG(this.start, ss);
    }

    public LispCFG addEpsilonRules() {
        HashSet<LispCFGRule> ss = new HashSet<LispCFGRule>(this.rules);
        for (LispCFGRule r : this.rules) {
            List<Datum> l = r.getRightValues();
            int i = 0;
            while (i < l.size()) {
                if (l.get(i).isGrammarVariable()) {
                    ArrayList<Datum> m = new ArrayList<Datum>(l);
                    m.remove(i);
                    for (LispCFGRule t : this.rules) {
                        if (!t.getLeftValue().equals(r.getLeftValue()) || !t.getRightValues().equals(m)) continue;
                        ss.remove(t);
                        ss.add(new LispCFGRule((LispGrammarVariable)l.get(i), Collections.<Datum>emptyList()));
                        break;
                    }
                }
                ++i;
            }
        }
        return new LispCFG(this.start, ss);
    }

    private static Set<List<Datum>> containsrules(Set<LispCFGRule> rules, LispGrammarVariable x, LispGrammarVariable y) {
        HashSet<List<Datum>> s = new HashSet<List<Datum>>();
        for (LispCFGRule r : rules) {
            if (!r.getLeftValue().equals(x)) continue;
            s.add(r.getRightValues());
        }
        HashSet<List<Datum>> t = new HashSet<List<Datum>>();
        for (LispCFGRule r : rules) {
            if (!r.getLeftValue().equals(y)) continue;
            t.add(r.getRightValues());
        }
        return s.containsAll(t) ? t : null;
    }

    public LispCFG eliminateCommonRules() {
        HashSet<LispCFGRule> s = new HashSet<LispCFGRule>(this.rules);
        ArrayList<LispGrammarVariable> ll = new ArrayList<LispGrammarVariable>();
        ll.add(this.start);
        this.getvariables2(ll, this.start);
        int i = 0;
        while (i < ll.size()) {
            int j = 0;
            while (j < ll.size()) {
                LispGrammarVariable jj;
                LispGrammarVariable ii;
                Set<List<Datum>> t;
                if (i != j && (t = LispCFG.containsrules(s, ii = (LispGrammarVariable)ll.get(i), jj = (LispGrammarVariable)ll.get(j))) != null) {
                    for (List<Datum> r : t) {
                        s.remove(new LispCFGRule(ii, r));
                    }
                    s.add(new LispCFGRule(ii, Collections.singletonList(jj)));
                }
                ++j;
            }
            ++i;
        }
        return new LispCFG(this.start, s);
    }

    private static <T> List<T> commlist(List<T> a, List<T> b) {
        ArrayList<T> l = new ArrayList<T>();
        int i = 0;
        while (i < a.size() && i < b.size()) {
            if (!a.get(i).equals(b.get(i))) {
                return l;
            }
            l.add(a.get(i));
            ++i;
        }
        return l;
    }

    private static <T> List<T> startwith(List<T> a, List<T> b) {
        int i = 0;
        while (i < a.size() && i < b.size()) {
            if (!a.get(i).equals(b.get(i))) {
                return null;
            }
            ++i;
        }
        return i < b.size() ? null : a.subList(i, a.size());
    }

    public LispCFG leftFactor() {
        HashSet<LispCFGRule> ss = new HashSet<LispCFGRule>(this.rules);
        ArrayList<LispGrammarVariable> ll = new ArrayList<LispGrammarVariable>();
        ll.add(this.start);
        this.getvariables2(ll, this.start);
        int i = 0;
        while (i < ll.size()) {
            List<Datum> m;
            List<Datum> l = null;
            int c = 0;
            for (LispCFGRule t : ss) {
                if (!t.getLeftValue().equals(ll.get(i))) continue;
                if (l == null) {
                    ++c;
                    l = t.getRightValues();
                    continue;
                }
                m = LispCFG.commlist(l, t.getRightValues());
                if (m.isEmpty()) continue;
                ++c;
                l = m;
            }
            if (!l.isEmpty() && c > 1) {
                LispGrammarVariable v = LispGrammarVariable.genvar();
                HashSet<LispCFGRule> rr = new HashSet<LispCFGRule>(ss);
                for (LispCFGRule t : ss) {
                    if (!t.getLeftValue().equals(ll.get(i)) || (m = LispCFG.startwith(t.getRightValues(), l)) == null) continue;
                    rr.add(new LispCFGRule(v, m));
                    rr.remove(t);
                }
                l = new ArrayList<Datum>(l);
                l.add(v);
                rr.add(new LispCFGRule((LispGrammarVariable)ll.get(i), l));
                ss = rr;
                if (!ll.contains(v)) {
                    ll.add(v);
                }
            }
            ++i;
        }
        return new LispCFG(this.start, ss);
    }

    public LispCFG augument() {
        LispGrammarVariable v = LispGrammarVariable.genvar();
        HashSet<LispCFGRule> ss = new HashSet<LispCFGRule>(this.rules);
        ss.add(new LispCFGRule(v, Collections.singletonList(this.start)));
        return new LispCFG(v, ss);
    }

    public Set<LispCFGRule> findRules(LispGrammarVariable a) {
        HashSet<LispCFGRule> s = new HashSet<LispCFGRule>();
        for (LispCFGRule r : this.rules) {
            if (!r.getLeftValue().equals(a)) continue;
            s.add(r);
        }
        return s;
    }

    private Set<LispLR0Item> finditems(LispGrammarVariable a) {
        HashSet<LispLR0Item> s = new HashSet<LispLR0Item>();
        for (LispCFGRule r : this.rules) {
            if (!r.getLeftValue().equals(a)) continue;
            s.add(new LispLR0Item(r, 0));
        }
        return s;
    }

    public LispLR0Items lr0Goto(LispLR0Items is, Datum x) {
        HashSet<LispLR0Item> js = new HashSet<LispLR0Item>();
        for (LispLR0Item i : is.getItems()) {
            if (!x.equals(i.getIndicated())) continue;
            js.add(i.shiftRight());
        }
        return new LispLR0Items(LispLR0Items.getClosure(this, js));
    }

    private void putlr0goto(Map<LispLR0Items, Map<Datum, LispLR0Items>> m, LispLR0Items i, Datum x, LispLR0Items j) {
        Map<Datum, LispLR0Items> a = m.get(i);
        if (a == null) {
            a = new HashMap<Datum, LispLR0Items>();
            m.put(i, a);
        }
        a.put(x, j);
    }

    public Map<LispLR0Items, Map<Datum, LispLR0Items>> lr0Graph() {
        boolean c = true;
        HashMap<LispLR0Items, Map<Datum, LispLR0Items>> g = new HashMap<LispLR0Items, Map<Datum, LispLR0Items>>();
        HashSet<LispLR0Items> sc = new HashSet<LispLR0Items>();
        sc.add(this.lr0Start());
        HashSet<Datum> vs = new HashSet<Datum>();
        vs.addAll(this.getVariables());
        vs.addAll(this.getTerminals());
        while (c) {
            c = false;
            HashSet<LispLR0Items> sd = new HashSet<LispLR0Items>(sc);
            for (LispLR0Items i : sc) {
                for (Datum x : vs) {
                    LispLR0Items g0 = this.lr0Goto(i, x);
                    this.putlr0goto(g, i, x, g0);
                    c |= sd.add(g0);
                }
            }
            sc = sd;
        }
        return g;
    }

    public LispLR0Items lr0Start() {
        return new LispLR0Items(LispLR0Items.getClosure(this, this.finditems(this.start)));
    }

    @Override
    public boolean isContextSensitive() {
        return true;
    }

    @Override
    public boolean isMonotonic() {
        for (LispCFGRule r : this.rules) {
            if (!r.isEpsilonRule()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isContextFree() {
        return true;
    }

    @Override
    public boolean isRegular() {
        LispCFG cnf = this.toCNF();
        for (LispCFGRule r : cnf.rules) {
            List<Datum> l = r.getRightValues();
            if (l.size() != 2) continue;
            for (LispCFGRule s : cnf.rules) {
                if (!s.getLeftValues().equals(l.get(0)) || s.getRightValues().size() != 2) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public LispCFG toCFG() {
        return this;
    }

    @Override
    public ILispFormalGrammar toKurodaNormalForm() {
        return this.toCNF();
    }

    public int hashCode() {
        int r = 17;
        r = (r + this.start.hashCode()) * 37;
        return r + this.rules.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof LispCFG) {
            LispCFG r = (LispCFG)o;
            return this.start.equals(r.start) && this.rules.equals(r.rules);
        }
        return false;
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<context-free-grammar>");
    }
}

