/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.automata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.automata.ILispFormalGrammar;
import net.morilib.lisp.automata.ILispFormalGrammarRule;
import net.morilib.lisp.automata.Lisp0GrammarRule;
import net.morilib.lisp.automata.LispGrammarVariable;
import net.morilib.lisp.automata.cfg.LispCFG;
import net.morilib.lisp.automata.cfg.LispCFGRule;

public class Lisp0Grammar
extends Datum2
implements ILispFormalGrammar {
    private Set<Lisp0GrammarRule> rules;
    private LispGrammarVariable start;

    Lisp0Grammar(LispGrammarVariable start, Set<Lisp0GrammarRule> rules, boolean dummy) {
        this.start = start;
        this.rules = rules;
    }

    public Lisp0Grammar(LispGrammarVariable start, Set<Lisp0GrammarRule> rules) {
        this.start = start;
        this.rules = new HashSet<Lisp0GrammarRule>(rules);
    }

    public static Set<LispGrammarVariable> getAllVariables(ILispFormalGrammar g) {
        HashSet<LispGrammarVariable> s = new HashSet<LispGrammarVariable>();
        for (ILispFormalGrammarRule iLispFormalGrammarRule : g.getRules()) {
            for (Datum x : iLispFormalGrammarRule.getLeftValues()) {
                if (!x.isGrammarVariable()) continue;
                s.add((LispGrammarVariable)x);
            }
            for (Datum x : iLispFormalGrammarRule.getRightValues()) {
                if (!x.isGrammarVariable()) continue;
                s.add((LispGrammarVariable)x);
            }
        }
        return s;
    }

    @Override
    public Set<? extends ILispFormalGrammarRule> getRules() {
        return Collections.unmodifiableSet(this.rules);
    }

    @Override
    public LispGrammarVariable getStartVariable() {
        return this.start;
    }

    @Override
    public Set<LispGrammarVariable> getVariables() {
        return Lisp0Grammar.getAllVariables(this);
    }

    @Override
    public boolean isContextSensitive() {
        for (Lisp0GrammarRule r : this.rules) {
            List<Datum> lv = r.getLeftValues();
            int ls = lv.size();
            List<Datum> rv = r.getRightValues();
            int rs = rv.size();
            if (ls == 1 && rs == 0) {
                Datum d = r.getLeftValues().get(0);
                if (!d.equals(this.start)) {
                    return false;
                }
                for (Lisp0GrammarRule s : this.rules) {
                    if (!s.getRightValues().contains(d)) continue;
                    return false;
                }
                continue;
            }
            int i = 0;
            while (true) {
                if (i >= rs || i >= ls) {
                    return false;
                }
                if (!lv.get(i).equals(rv.get(i))) break;
                ++i;
            }
            int j = 1;
            while (ls - j != i) {
                if (!lv.get(ls - j).equals(rv.get(rs - j))) {
                    return false;
                }
                ++j;
            }
        }
        return true;
    }

    @Override
    public boolean isMonotonic() {
        for (Lisp0GrammarRule r : this.rules) {
            List<Datum> lv = r.getLeftValues();
            List<Datum> rv = r.getRightValues();
            if (lv.size() <= rv.size()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isContextFree() {
        for (Lisp0GrammarRule r : this.rules) {
            List<Datum> lv = r.getLeftValues();
            if (lv.size() == 1 && lv.get(0).isGrammarVariable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isRegular() {
        LispCFG cfg = this.toCFG();
        return cfg != null && cfg.isRegular();
    }

    @Override
    public LispCFG toCFG() {
        HashSet<LispCFGRule> rs = new HashSet<LispCFGRule>();
        for (Lisp0GrammarRule r : this.rules) {
            List<Datum> lv = r.getLeftValues();
            List<Datum> rv = r.getRightValues();
            if (lv.size() != 1 || !lv.get(0).isGrammarVariable()) {
                return null;
            }
            rs.add(new LispCFGRule((LispGrammarVariable)lv.get(0), rv));
        }
        return new LispCFG(this.start, rs);
    }

    static Set<Lisp0GrammarRule> decreaseDegree(Lisp0GrammarRule r) {
        HashSet<Lisp0GrammarRule> rl;
        List<Datum> lv = r.getLeftValues();
        int ls = lv.size();
        List<Datum> rv = r.getRightValues();
        int rs = rv.size();
        if (ls == 2 && rs == 2 || ls == 1 && (rs == 1 || rs == 2)) {
            return Collections.singleton(r);
        }
        if (ls > rs) {
            return null;
        }
        if (ls == 1) {
            rl = new HashSet<Lisp0GrammarRule>();
            LispGrammarVariable t0 = LispGrammarVariable.genvar();
            List<Datum> l0 = Arrays.asList(rv.get(0), t0);
            Lisp0GrammarRule r0 = new Lisp0GrammarRule(lv, l0, 1);
            rl.add(r0);
            l0 = Collections.singletonList(t0);
            r0 = new Lisp0GrammarRule(l0, rv.subList(1, rs), 2);
            rl.add(r0);
        } else {
            rl = new HashSet();
            LispGrammarVariable t0 = LispGrammarVariable.genvar();
            LispGrammarVariable t1 = LispGrammarVariable.genvar();
            List<Datum> l0 = Arrays.asList(t0, t1);
            Lisp0GrammarRule r0 = new Lisp0GrammarRule(lv.subList(0, 2), l0, 1);
            rl.add(r0);
            l0 = Collections.singletonList(t0);
            List<Datum> l1 = Collections.singletonList(rv.get(0));
            r0 = new Lisp0GrammarRule(l0, l1, 3);
            rl.add(r0);
            l0 = new ArrayList<Datum>();
            l0.add(t1);
            l0.addAll(lv.subList(2, ls));
            r0 = new Lisp0GrammarRule(l0, rv.subList(1, rs), 1);
            rl.add(r0);
        }
        return rl;
    }

    static Set<Lisp0GrammarRule> decreaseDegree(Set<Lisp0GrammarRule> rs) {
        HashSet<Lisp0GrammarRule> rt = new HashSet<Lisp0GrammarRule>();
        for (Lisp0GrammarRule r : rs) {
            Set<Lisp0GrammarRule> r0 = Lisp0Grammar.decreaseDegree(r);
            if (r0 == null) {
                return null;
            }
            rt.addAll(r0);
        }
        return rt;
    }

    @Override
    public Lisp0Grammar toKurodaNormalForm() {
        Set<Lisp0GrammarRule> rs = this.rules;
        Set<Lisp0GrammarRule> rt = null;
        while (rt == null || rt.size() < rs.size()) {
            rt = rs;
            rs = Lisp0Grammar.decreaseDegree(rs);
        }
        return new Lisp0Grammar(this.start, rs, false);
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<generic-grammar>");
    }
}

