/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.array;

import java.util.Arrays;
import net.morilib.lisp.Atom;
import net.morilib.lisp.LispString;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.array.ILispArray;
import net.morilib.lisp.array.LispArrayShape;

public abstract class SRFI47Array
extends Atom
implements ILispArray {
    protected int[] eIndices;

    protected SRFI47Array(int[] is) {
        this.eIndices = new int[is.length];
        System.arraycopy(is, 0, this.eIndices, 0, is.length);
    }

    @Override
    public boolean isIndexEqualTo(ILispArray a) {
        if (a instanceof SRFI47Array) {
            return Arrays.equals(this.eIndices, ((SRFI47Array)a).eIndices);
        }
        if (this.rank() == a.rank()) {
            int i = 0;
            while (i < this.rank()) {
                if (this.startIndex(i) != a.startIndex(i)) {
                    return false;
                }
                if (this.endIndex(i) != a.endIndex(i)) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    @Override
    public String print() {
        return LispUtils.print(this);
    }

    @Override
    public String getResult() {
        return LispUtils.getResult(this);
    }

    @Override
    public LispString toLispString() {
        return new LispString(LispUtils.print(this));
    }

    @Override
    public LispArrayShape getShape() {
        return new LispArrayShape(this.eIndices);
    }
}

