/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.array;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.LispVector;
import net.morilib.lisp.Subr;
import net.morilib.lisp.array.ILispArray;
import net.morilib.lisp.array.LispArrayPrototype;
import net.morilib.lisp.array.LispArrayShape;
import net.morilib.lisp.array.LispDefaultArray;
import net.morilib.lisp.array.SRFI47Array;
import net.morilib.lisp.array.ValueOutOfBoundsException;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.util.Iterators;

public class LispArrayS64
extends SRFI47Array
implements Serializable {
    private long[] real;

    public LispArrayS64(long r, int ... is) {
        super(is);
        this.real = new long[LispArrayShape.arraylength(is)];
        Arrays.fill(this.real, r);
    }

    @Override
    public int rank() {
        return this.eIndices.length;
    }

    @Override
    public int startIndex(int dim) {
        if (dim < 0 || dim >= this.eIndices.length) {
            throw new IndexOutOfBoundsException();
        }
        return 0;
    }

    @Override
    public int endIndex(int dim) {
        return this.eIndices[dim];
    }

    @Override
    public LispVector toVector() {
        Datum[] r = new Datum[LispArrayShape.arraylength(this.eIndices)];
        int i = 0;
        while (i < r.length) {
            r[i] = LispInteger.valueOf(this.real[i]);
            ++i;
        }
        return new LispVector(r);
    }

    @Override
    public Datum getFromArray(int ... is) {
        return LispInteger.valueOf(this.real[LispArrayShape.arrayindex(this.eIndices, is)]);
    }

    @Override
    public void setToArray(Datum d, int ... is) {
        if (!(d instanceof LispReal)) {
            throw new ClassCastException();
        }
        if (!((LispReal)d).inLongRange()) {
            throw new ValueOutOfBoundsException(d.toString());
        }
        this.real[LispArrayShape.arrayindex((int[])this.eIndices, (int[])is)] = d.getLong();
    }

    @Override
    public boolean isEqualTo(ILispArray a) {
        if (!this.isIndexEqualTo(a)) {
            return false;
        }
        if (a instanceof LispArrayS64) {
            return Arrays.equals(this.real, ((LispArrayS64)a).real);
        }
        return LispDefaultArray.isEqualTo(this, a);
    }

    @Override
    public String getTypeSpecifier() {
        return "fixZ64b";
    }

    @Override
    public void fill(Iterator<Datum> itr) {
        int i = 0;
        while (i < this.real.length && itr.hasNext()) {
            Datum x = itr.next();
            if (!(x instanceof LispReal)) {
                throw new ClassCastException();
            }
            if (!((LispReal)x).inLongRange()) {
                throw new ValueOutOfBoundsException(x.toString());
            }
            this.real[i] = x.getLong();
            ++i;
        }
    }

    public static class As64
    extends Subr {
        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            Datum d = Iterators.nextIf(itr);
            SubrUtils.checkTerminated(itr, body, mesg);
            if (d == null || d instanceof LispReal) {
                return new Prototype(d == null ? 0L : d.getLong());
            }
            throw mesg.getError("err.require.real", d);
        }
    }

    public static class Prototype
    extends Datum2
    implements LispArrayPrototype {
        private long real;

        public Prototype(long real) {
            this.real = real;
        }

        @Override
        public ILispArray makeArray(int ... is) {
            return new LispArrayS64(this.real, is);
        }

        @Override
        public void toDisplayString(StringBuilder buf) {
            buf.append("#<as64 prototype>");
        }
    }
}

