/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.array;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Iterator;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispComplex;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispVector;
import net.morilib.lisp.Subr;
import net.morilib.lisp.array.ILispArray;
import net.morilib.lisp.array.LispArrayPrototype;
import net.morilib.lisp.array.LispArrayShape;
import net.morilib.lisp.array.LispDefaultArray;
import net.morilib.lisp.array.SRFI47Array;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.util.Iterators;

public class LispArrayC64
extends SRFI47Array
implements Serializable {
    private double[] real;
    private double[] imag;

    public LispArrayC64(double r, double i, int ... is) {
        super(is);
        this.real = new double[LispArrayShape.arraylength(is)];
        this.imag = new double[LispArrayShape.arraylength(is)];
        Arrays.fill(this.real, r);
        Arrays.fill(this.imag, i);
    }

    @Override
    public int rank() {
        return this.eIndices.length;
    }

    @Override
    public int startIndex(int dim) {
        if (dim < 0 || dim >= this.eIndices.length) {
            throw new IndexOutOfBoundsException();
        }
        return 0;
    }

    @Override
    public int endIndex(int dim) {
        return this.eIndices[dim];
    }

    @Override
    public LispVector toVector() {
        Datum[] r = new Datum[LispArrayShape.arraylength(this.eIndices)];
        int i = 0;
        while (i < r.length) {
            r[i] = LispComplex.newComplex(this.real[i], this.imag[i]);
            ++i;
        }
        return new LispVector(r);
    }

    @Override
    public Datum getFromArray(int ... is) {
        int p = LispArrayShape.arrayindex(this.eIndices, is);
        return LispComplex.newComplex(this.real[p], this.imag[p]);
    }

    @Override
    public void setToArray(Datum d, int ... is) {
        if (!(d instanceof LispComplex)) {
            throw new ClassCastException();
        }
        LispComplex n = (LispComplex)d;
        int p = LispArrayShape.arrayindex(this.eIndices, is);
        this.real[p] = n.getRealDouble();
        this.imag[p] = n.getImagDouble();
    }

    @Override
    public boolean isEqualTo(ILispArray a) {
        if (!this.isIndexEqualTo(a)) {
            return false;
        }
        if (a instanceof LispArrayC64) {
            return Arrays.equals(this.real, ((LispArrayC64)a).real) && Arrays.equals(this.imag, ((LispArrayC64)a).imag);
        }
        return LispDefaultArray.isEqualTo(this, a);
    }

    @Override
    public String getTypeSpecifier() {
        return "floC64b";
    }

    @Override
    public void fill(Iterator<Datum> itr) {
        int i = 0;
        while (i < this.real.length && itr.hasNext()) {
            Datum x = itr.next();
            if (!(x instanceof LispComplex)) {
                throw new ClassCastException();
            }
            this.real[i] = x.getRealDouble();
            this.imag[i] = x.getImagDouble();
            ++i;
        }
    }

    public static class Ac64
    extends Subr {
        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            Datum d = Iterators.nextIf(itr);
            SubrUtils.checkTerminated(itr, body, mesg);
            if (d == null || d instanceof LispComplex) {
                return new Prototype(d == null ? 0.0 : d.getRealDouble(), d == null ? 0.0 : d.getImagDouble());
            }
            throw mesg.getError("err.require.complex", d);
        }
    }

    public static class Prototype
    extends Datum2
    implements LispArrayPrototype {
        private double real;
        private double imag;

        public Prototype(double real, double imag) {
            this.real = real;
            this.imag = imag;
        }

        @Override
        public ILispArray makeArray(int ... is) {
            return new LispArrayC64(this.real, this.imag, is);
        }

        @Override
        public void toDisplayString(StringBuilder buf) {
            buf.append("#<ac64 prototype>");
        }
    }
}

