/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.array;

import java.util.Iterator;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Subr;
import net.morilib.lisp.array.ILispArray;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.util.primitive.IntegerArrayVector;

public class IsArrayInBounds
extends Subr {
    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        ConsIterator itr = new ConsIterator(body);
        Datum a = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        IntegerArrayVector bin = new IntegerArrayVector();
        while (itr.hasNext()) {
            int b = SubrUtils.nextSmallInt((Iterator<Datum>)itr, mesg, body);
            if (b < 0) {
                throw mesg.getError("err.srfi25.arraysize.invalid", LispInteger.valueOf(b));
            }
            bin.add(b);
        }
        SubrUtils.checkTerminated(itr, body, mesg);
        if (!(a instanceof ILispArray)) {
            throw mesg.getError("err.srfi25.require.array", a);
        }
        ILispArray aa = (ILispArray)((Object)a);
        if (aa.rank() != bin.size()) {
            return LispBoolean.FALSE;
        }
        int i = 0;
        while (i < bin.size()) {
            if (bin.getInt(i) < aa.startIndex(i) || bin.getInt(i) >= aa.endIndex(i)) {
                return LispBoolean.FALSE;
            }
            ++i;
        }
        return LispBoolean.TRUE;
    }
}

