/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp.array;

import java.util.Iterator;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispVector;
import net.morilib.lisp.Subr;
import net.morilib.lisp.array.ILispArray;
import net.morilib.lisp.array.InvalidDimensionException;
import net.morilib.lisp.array.LispArrayIndices;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.util.Iterators;
import net.morilib.util.primitive.IntegerArrayVector;

public class ArrayRef
extends Subr {
    @Override
    public Datum eval(Datum body, Environment env, LispMessage mesg) {
        int[] i;
        ConsIterator itr = new ConsIterator(body);
        Datum a = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
        Datum d = Iterators.nextIf(itr);
        if (!(a instanceof ILispArray)) {
            throw mesg.getError("err.srfi25.require.array", a);
        }
        if (d == null) {
            return ((ILispArray)((Object)a)).getFromArray(new int[0]);
        }
        if (d instanceof LispArrayIndices) {
            i = ((LispArrayIndices)d).getpos();
        } else if (d instanceof ILispArray) {
            ILispArray b = (ILispArray)((Object)d);
            if (b.rank() != 1) {
                throw mesg.getError("err.srfi25.dimension.invalid", d);
            }
            LispVector v = b.toVector();
            i = new int[v.size()];
            int j = 0;
            while (j < v.size()) {
                i[j] = SubrUtils.getSmallInt(v.get(j), mesg);
                ++j;
            }
        } else {
            IntegerArrayVector iv = new IntegerArrayVector();
            do {
                iv.add(SubrUtils.getSmallInt(d, mesg));
            } while ((d = Iterators.nextIf(itr)) != null);
            i = iv.toIntArray();
        }
        SubrUtils.checkTerminated(itr, body, mesg);
        try {
            return ((ILispArray)((Object)a)).getFromArray(i);
        }
        catch (InvalidDimensionException e) {
            throw mesg.getError("err.srfi25.dimension.invalid");
        }
        catch (IndexOutOfBoundsException e) {
            throw mesg.getError("err.range.invalid");
        }
    }
}

