/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.morilib.lisp.ClosureClass;
import net.morilib.lisp.CodeExecutor;
import net.morilib.lisp.CompiledCode;
import net.morilib.lisp.Cons;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.ConsListBuilder;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.IntLispUtils;
import net.morilib.lisp.IntStack;
import net.morilib.lisp.LispCompiler;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Nil;
import net.morilib.lisp.PatternDepthException;
import net.morilib.lisp.PatternDepthMap;
import net.morilib.lisp.PatternEllipsisException;
import net.morilib.lisp.PatternMatch;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.SymbolName;
import net.morilib.lisp.SymbolScope;
import net.morilib.lisp.Undef;
import net.morilib.lisp.UserIdentifierSyntax;
import net.morilib.lisp.UserSyntax;

final class SyntaxUtils {
    private static final Symbol SYNTAX_RULES = Symbol.getSymbol("syntax-rules");
    private static final Symbol IDENTIFIER_SYNTAX = Symbol.getSymbol("identifier-syntax");
    private static final Symbol SETBANG = Symbol.getSymbol("set!");

    private SyntaxUtils() {
    }

    /*
     * Unable to fully structure code
     */
    static boolean isValidSymbolList(Datum d) {
        p = d;
        if (!d.isTypeSymbol()) ** GOTO lbl11
        return true;
lbl-1000:
        // 1 sources

        {
            if (p instanceof Cons) {
                c = (Cons)p;
                if (!c.getCar().isTypeSymbol()) {
                    return false;
                }
                p = c.getCdr();
                continue;
            }
            return p.isTypeSymbol();
lbl11:
            // 2 sources

            ** while (p != Nil.NIL)
        }
lbl12:
        // 1 sources

        return true;
    }

    static void compileBind(Datum sym, Datum bcdr, Environment env, LispCompiler comp, CompiledCode.Builder build, Cons callsym, boolean toplevel, LispMessage mesg, String ercd, List<Cons> symlist, CodeExecutor exec, IntStack memento, LispCompiler.MiscInfo syncased) {
        if (bcdr instanceof Cons) {
            Datum d1 = ((Cons)bcdr).getCar();
            CompiledCode.Builder nbuild = new CompiledCode.Builder();
            Environment nenv = new Environment(env);
            comp.compile(d1, nenv, nbuild, callsym, true, new ArrayList<Cons>(), exec, memento, syncased);
            nbuild.addReturnOp();
            ClosureClass cl = new ClosureClass(Nil.NIL, nbuild.getCodeRef());
            build.addPush(cl);
            build.addBeginList();
            build.addEndList();
            build.addCall();
            if (toplevel) {
                if (!(sym instanceof SymbolName)) {
                    throw mesg.getError("err.require.symbol");
                }
                Symbol r = ((SymbolName)((Object)sym)).getSymbol();
                r = r.getEnclosedSymbol();
                build.addBind(r);
                build.addPush(sym);
            } else {
                build.addBind(sym);
                build.addPush(Undef.UNDEF);
            }
        } else {
            throw mesg.getError(ercd);
        }
    }

    static void compileBindMacro(Datum sym, Datum bcdr, Environment env, LispCompiler comp, CompiledCode.Builder build, Cons callsym, LispMessage mesg, String ercd, List<Cons> symlist, CodeExecutor exec, IntStack memento, LispCompiler.MiscInfo syncased) {
        if (!(bcdr instanceof Cons)) {
            throw mesg.getError(ercd);
        }
        Datum d1 = ((Cons)bcdr).getCar();
        CompiledCode.Builder nbuild = new CompiledCode.Builder();
        Environment nenv = new Environment(env);
        comp.compile(d1, nenv, build, callsym, true, new ArrayList<Cons>(), exec, memento, syncased);
        nbuild.addReturnOp();
        ClosureClass cl = new ClosureClass(Nil.NIL, nbuild.getCodeRef());
        build.addPush(cl);
        build.addBeginList();
        build.addEndList();
        build.addCall();
        build.addBindMacro(sym);
        build.addPush(Undef.UNDEF);
    }

    static void compileBindMacro72(Datum sym, Datum bcdr, Environment env, LispCompiler comp, CompiledCode.Builder build, Cons callsym, LispMessage mesg, String ercd, List<Cons> symlist, CodeExecutor exec, IntStack memento, LispCompiler.MiscInfo syncased) {
        if (!(bcdr instanceof Cons)) {
            throw mesg.getError(ercd);
        }
        Datum d1 = ((Cons)bcdr).getCar();
        CompiledCode.Builder nbuild = new CompiledCode.Builder();
        Environment nenv = new Environment(env);
        comp.compile(d1, nenv, build, callsym, true, new ArrayList<Cons>(), exec, memento, syncased);
        nbuild.addReturnOp();
        ClosureClass cl = new ClosureClass(Nil.NIL, nbuild.getCodeRef());
        build.addPush(cl);
        build.addBeginList();
        build.addEndList();
        build.addCall();
        build.addBindMacro72(sym);
        build.addPush(Undef.UNDEF);
    }

    static void compileBindMacroQuote(Datum sym, Datum bcdr, Environment env, LispCompiler comp, CompiledCode.Builder build, Cons callsym, LispMessage mesg, String ercd, List<Cons> symlist, CodeExecutor exec, IntStack memento, LispCompiler.MiscInfo syncased) {
        if (!(bcdr instanceof Cons)) {
            throw mesg.getError(ercd);
        }
        Datum d1 = ((Cons)bcdr).getCar();
        CompiledCode.Builder nbuild = new CompiledCode.Builder();
        Environment nenv = new Environment(env);
        comp.compile(d1, nenv, build, callsym, true, new ArrayList<Cons>(), exec, memento, syncased);
        nbuild.addReturnOp();
        ClosureClass cl = new ClosureClass(Nil.NIL, nbuild.getCodeRef());
        build.addPush(cl);
        build.addBeginList();
        build.addEndList();
        build.addCall();
        build.addBindMacroQuote(sym);
        build.addPush(Undef.UNDEF);
    }

    static void compileList(Datum b, Environment env, LispCompiler comp, CompiledCode.Builder nbuild, Cons callsym, boolean istail, LispMessage mesg, List<Cons> symlist, CodeExecutor exec, IntStack memento, boolean toplv, LispCompiler.MiscInfo syncased) {
        Datum bcdr = b;
        nbuild.addPush(Undef.UNDEF);
        while (bcdr != Nil.NIL) {
            if (bcdr instanceof Cons) {
                Cons bc = (Cons)bcdr;
                boolean tl = istail && bc.getCdr() == Nil.NIL;
                nbuild.addPop();
                comp.compile(bc.getCar(), env, nbuild, toplv, callsym, tl, symlist, exec, memento, syncased);
                bcdr = bc.getCdr();
                continue;
            }
            throw mesg.getError("err.explist.malform");
        }
    }

    static void compileList(Datum b, Environment env, LispCompiler comp, CompiledCode.Builder nbuild, Cons callsym, boolean istail, LispMessage mesg, List<Cons> symlist, CodeExecutor exec, IntStack memento, LispCompiler.MiscInfo syncased) {
        SyntaxUtils.compileList(b, env, comp, nbuild, callsym, istail, mesg, symlist, exec, memento, false, syncased);
    }

    static void compileListApply(Datum b, Environment env, LispCompiler comp, CompiledCode.Builder nbuild, Cons callsym, LispMessage mesg, List<Cons> symlist, CodeExecutor exec, IntStack memento, LispCompiler.MiscInfo syncased) {
        Datum bcdr = b;
        while (bcdr != Nil.NIL) {
            if (bcdr instanceof Cons) {
                Cons bc = (Cons)bcdr;
                comp.compile(bc.getCar(), env, nbuild, callsym, false, symlist, exec, memento, syncased);
                nbuild.addAppendList();
                bcdr = bc.getCdr();
                continue;
            }
            throw mesg.getError("err.explist.malform");
        }
    }

    static Datum replaceLocalValsList(Datum b, Environment env, LispCompiler comp, Environment ienv, LispMessage mesg, boolean toplv, int ttype) {
        Datum bcdr = b;
        ArrayList<Datum> lst = new ArrayList<Datum>();
        while (bcdr != Nil.NIL) {
            if (bcdr instanceof Cons) {
                lst.add(comp.replaceLocalVals(((Cons)bcdr).getCar(), env, ienv, toplv, ttype));
                bcdr = ((Cons)bcdr).getCdr();
                continue;
            }
            throw mesg.getError("err.explist.malform");
        }
        return LispUtils.listToCons(lst);
    }

    static Datum replaceLocalValsList(Datum b, Environment env, LispCompiler comp, Environment ienv, LispMessage mesg, int ttype) {
        return SyntaxUtils.replaceLocalValsList(b, env, comp, ienv, mesg, false, ttype);
    }

    static Datum putSymbol(Environment ienv, Datum p, LispMessage mesg) {
        if (p instanceof Symbol) {
            Symbol res = Symbol.encloseSymbol((Symbol)p);
            ienv.bindDatum(p, res);
            return res;
        }
        if (p instanceof SymbolScope) {
            Symbol s = ((SymbolScope)p).getSymbol();
            Symbol res = ((SymbolScope)p).isCaptured() ? s : Symbol.encloseSymbol(s);
            ienv.bindDatum(s, res);
            return res;
        }
        if (p instanceof PatternMatch.IndSym) {
            return p;
        }
        throw mesg.getError("err.symbol");
    }

    static Datum addLocalValsAll(Environment ienv, Datum d, LispMessage mesg) {
        Datum p = d;
        ArrayList<Datum> lst = new ArrayList<Datum>();
        while (p != Nil.NIL) {
            if (p instanceof Cons) {
                Datum r = SyntaxUtils.putSymbol(ienv, ((Cons)p).getCar(), mesg);
                p = ((Cons)p).getCdr();
                lst.add(r);
                continue;
            }
            return LispUtils.listToCons(lst, SyntaxUtils.putSymbol(ienv, p, mesg));
        }
        return LispUtils.listToCons(lst);
    }

    private static void processRule(Symbol name, Datum body, List<Datum> pat, List<Datum> tmp, List<Set<Symbol>> stl, Set<Symbol> reserve, LispMessage mesg) {
        Datum ptd;
        List<Datum> lst = LispUtils.consToList(body, mesg);
        HashSet<Symbol> st = new HashSet<Symbol>();
        PatternDepthMap mpp = new PatternDepthMap();
        PatternDepthMap mpt = new PatternDepthMap();
        if (lst.size() != 2) {
            throw mesg.getError("err.syntaxrules.malform");
        }
        try {
            ptd = PatternMatch.compilePattern(lst.get(0), mpp, st, reserve);
        }
        catch (PatternEllipsisException e) {
            throw mesg.getError("err.wrongellipsis");
        }
        pat.add(ptd);
        Datum tpl = PatternMatch.compileTemplate(lst.get(1), mpt);
        try {
            PatternMatch.validateLevel(ptd, tpl, st);
        }
        catch (PatternDepthException e) {
            throw mesg.getError("err.wronglevel", e.getMessage());
        }
        tmp.add(lst.get(1));
        stl.add(st);
    }

    static UserSyntax processSyntaxRules(Symbol name, Datum body, Environment env, LispMessage mesg, UserSyntax rootsyn) {
        List<Datum> lst = LispUtils.consToList(body, mesg);
        if (lst.size() < 2) {
            throw mesg.getError("err.syntaxrules.malform");
        }
        Set<Symbol> reserve = SyntaxUtils.consToSymbolSet(lst.get(0), mesg);
        ArrayList<Datum> pat = new ArrayList<Datum>();
        ArrayList<Datum> tmp = new ArrayList<Datum>();
        ArrayList<Set<Symbol>> stl = new ArrayList<Set<Symbol>>();
        int i = 1;
        while (i < lst.size()) {
            SyntaxUtils.processRule(name, lst.get(i), pat, tmp, stl, reserve, mesg);
            ++i;
        }
        return new UserSyntax(name.getName(), pat, tmp, stl, reserve, env, rootsyn);
    }

    static UserSyntax processRuleDesc(Symbol name, Datum body, Environment env, LispMessage mesg, UserSyntax rootsyn) {
        if (!(body instanceof Cons)) {
            throw mesg.getError("err.syntaxrules.malform");
        }
        Cons b1 = (Cons)body;
        if (SYNTAX_RULES.equals(b1.getCar())) {
            return SyntaxUtils.processSyntaxRules(name, b1.getCdr(), env, mesg, rootsyn);
        }
        throw mesg.getError("err.syntaxrules.malform");
    }

    static boolean isSyntaxRules(Datum body) {
        if (!(body instanceof Cons)) {
            return false;
        }
        return SYNTAX_RULES.equals(((Cons)body).getCar());
    }

    static boolean isIdentifierSyntax(Datum body) {
        if (!(body instanceof Cons)) {
            return false;
        }
        return IDENTIFIER_SYNTAX.equals(((Cons)body).getCar());
    }

    static Set<Symbol> consToSymbolSet(Datum d, LispMessage mesg) {
        HashSet<Symbol> res = new HashSet<Symbol>();
        Datum dd = d;
        while (dd != Nil.NIL) {
            if (dd instanceof Cons) {
                Cons cd = (Cons)dd;
                if (!(cd.getCar() instanceof SymbolName)) {
                    throw mesg.getError("err.list.symbol");
                }
                Symbol smb = ((SymbolName)((Object)cd.getCar())).getSymbol();
                res.add(smb);
                dd = ((Cons)dd).getCdr();
                continue;
            }
            throw mesg.getError("err.list");
        }
        return res;
    }

    static boolean equalsReserved(Symbol rword, Datum d) {
        if (d instanceof SymbolName) {
            Symbol s1 = ((SymbolName)((Object)d)).getSymbol();
            return Symbol.DEFAULT_NAMESPACE.getSymbol(s1.getName()).equals(rword);
        }
        return rword.equals(d);
    }

    static Datum removeScope1(Datum d, Collection<Datum> col) {
        Symbol s;
        if (d instanceof SymbolName && col.contains(s = ((SymbolName)((Object)d)).getSymbol())) {
            return s;
        }
        return d;
    }

    static Datum removeScope(Datum body, Collection<Datum> col) {
        ConsIterator itr = new ConsIterator(body);
        if (itr.hasNext()) {
            ConsListBuilder bld = new ConsListBuilder();
            while (itr.hasNext()) {
                Datum c = itr.next();
                bld.append(SyntaxUtils.removeScope(c, col));
            }
            return bld.get(SyntaxUtils.removeScope1(itr.getTerminal(), col));
        }
        return SyntaxUtils.removeScope1(itr.getTerminal(), col);
    }

    private static Datum _caaaddr(Datum d) {
        Datum e = d;
        if (!(e instanceof Cons)) {
            return Undef.UNDEF;
        }
        if (!((e = ((Cons)e).getCdr()) instanceof Cons)) {
            return Undef.UNDEF;
        }
        if (!((e = ((Cons)e).getCdr()) instanceof Cons)) {
            return Undef.UNDEF;
        }
        if (!((e = ((Cons)e).getCar()) instanceof Cons)) {
            return Undef.UNDEF;
        }
        if (!((e = ((Cons)e).getCar()) instanceof Cons)) {
            return Undef.UNDEF;
        }
        return ((Cons)e).getCar();
    }

    public static Datum processIdentifierSyntax(Symbol name, Datum car, Environment env, LispMessage mesg) {
        if (SyntaxUtils._caaaddr(car).equals(SETBANG)) {
            Datum ptd;
            Set<Symbol> res = Collections.emptySet();
            HashSet<Symbol> st = new HashSet<Symbol>();
            PatternDepthMap mpp = new PatternDepthMap();
            PatternDepthMap mpt = new PatternDepthMap();
            Datum tmp = IntLispUtils.cadaddr(car, mesg);
            Datum ptn = IntLispUtils.caddaaddr(car, mesg);
            try {
                ptd = PatternMatch.compilePattern(ptn, mpp, st, res);
            }
            catch (PatternEllipsisException e) {
                throw mesg.getError("err.wrongellipsis");
            }
            Datum tpl = PatternMatch.compileTemplate(tmp, mpt);
            try {
                PatternMatch.validateLevel(ptd, tpl, st);
            }
            catch (PatternDepthException e) {
                throw mesg.getError("err.wronglevel", e.getMessage());
            }
            UserSyntax syn = new UserSyntax(name.getName(), Collections.singletonList(ptd), Collections.singletonList(tpl), Collections.singletonList(st), res, env, null);
            return new UserIdentifierSyntax(name.getName(), IntLispUtils.cadadr(car, mesg), syn);
        }
        return new UserIdentifierSyntax(name.getName(), IntLispUtils.cadr(car, mesg));
    }

    static interface SafeWrap {
        public Datum getWrapee();
    }
}

