/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.morilib.lisp.Closure;
import net.morilib.lisp.ClosureClass;
import net.morilib.lisp.CompiledCode;
import net.morilib.lisp.ConsIterator;
import net.morilib.lisp.ConsListBuilder;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Datum2;
import net.morilib.lisp.Environment;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispCharacter;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispString;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.MultiValues;
import net.morilib.lisp.Nil;
import net.morilib.lisp.Procedure;
import net.morilib.lisp.Subr;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.subr.QuaternaryArgs;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.lisp.subr.UnaryArgs;
import net.morilib.options.IllegalCommandLineException;
import net.morilib.options.OperandProcessor;
import net.morilib.options.OptionObject;
import net.morilib.options.OptionProcessor;
import net.morilib.options.OptionUtils;
import net.morilib.util.Strings;

public final class SRFI37 {
    private static final Symbol TMP = Symbol.gensym();
    private static final Symbol ARGS = Symbol.gensym();
    private static final ArgsFoldAux AUX = new ArgsFoldAux();

    private SRFI37() {
    }

    private static OptionProcessor toOption(final Procedure proc) {
        return new OptionProcessor(){

            @Override
            public Object call(OptionObject option, String name, String arg, Object extra) {
                CompiledCode.Builder build = (CompiledCode.Builder)extra;
                Option0 opt = option == null ? new Option0(proc, false, false, name) : (Option0)option;
                build.addBind(TMP);
                build.addPush((Datum)((Object)proc));
                build.addBeginList();
                build.addPush(opt);
                build.addAppendList();
                build.addPush(new LispString(name));
                build.addAppendList();
                build.addPush(arg == null ? LispBoolean.FALSE : new LispString(arg));
                build.addAppendList();
                build.addReferSymbol(TMP);
                build.addAppendListMultiValues();
                build.addEndList();
                build.addCall();
                return extra;
            }
        };
    }

    private static OperandProcessor toOperand(final Procedure proc) {
        return new OperandProcessor(){

            @Override
            public Object call(String operand, Object extra) {
                CompiledCode.Builder build = (CompiledCode.Builder)extra;
                build.addBind(TMP);
                build.addPush((Datum)((Object)proc));
                build.addBeginList();
                build.addPush(new LispString(operand));
                build.addAppendList();
                build.addReferSymbol(TMP);
                build.addAppendListMultiValues();
                build.addEndList();
                build.addCall();
                return extra;
            }
        };
    }

    public static class ArgsFold
    extends Subr {
        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            throw new RuntimeException();
        }

        @Override
        ClosureClass createClosureClass(Environment env) {
            CompiledCode.Builder bld = new CompiledCode.Builder();
            bld.addPush(AUX);
            bld.addBeginList();
            bld.addReferSymbol(ARGS);
            bld.addAppendListSplicing();
            bld.addEndList();
            bld.addCall();
            bld.addBeginList();
            bld.addEndList();
            bld.addCall();
            bld.addReturnOp();
            return new ClosureClass(ARGS, bld.getCodeRef());
        }
    }

    private static class ArgsFoldAux
    extends Subr {
        private ArgsFoldAux() {
        }

        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            ConsIterator itr = new ConsIterator(body);
            Datum args = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            Datum opts = SubrUtils.nextIf((Iterator<Datum>)itr, mesg, body);
            Procedure unrc = SubrUtils.nextProcedure(itr, mesg, body);
            Procedure oprc = SubrUtils.nextProcedure(itr, mesg, body);
            Datum rest = itr.rest();
            ArrayList<String> ss = new ArrayList<String>();
            ArrayList<OptionObject> oo = new ArrayList<OptionObject>();
            CompiledCode.Builder build = new CompiledCode.Builder();
            ConsIterator jtr = new ConsIterator(args);
            while (jtr.hasNext()) {
                ss.add(SubrUtils.getString(jtr.next(), mesg));
            }
            jtr = new ConsIterator(opts);
            while (jtr.hasNext()) {
                Datum d = jtr.next();
                if (d instanceof Option0) {
                    oo.add((OptionObject)((Object)d));
                    continue;
                }
                throw mesg.getError("err.srfi37.require.option", d);
            }
            try {
                Datum mt = MultiValues.newValues(LispUtils.consToList(rest, mesg));
                build.addPush(mt);
                OptionUtils.process(ss.toArray(new String[0]), oo.toArray(new OptionObject[0]), SRFI37.toOption(unrc), SRFI37.toOperand(oprc), build);
                build.addReturnOp();
            }
            catch (IllegalCommandLineException e) {
                throw mesg.getError("err.srfi37.option.error");
            }
            return new Closure(new ClosureClass(Nil.NIL, build.getCodeRef()), env);
        }
    }

    public static class IsOptionOptionalArg
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof Option0) {
                return LispBoolean.getInstance(((Option0)c1a).optional);
            }
            throw mesg.getError("err.srfi37.require.option", c1a);
        }
    }

    public static class IsOptionRequiredArg
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof Option0) {
                return LispBoolean.getInstance(((Option0)c1a).required);
            }
            throw mesg.getError("err.srfi37.require.option", c1a);
        }
    }

    public static class Option
    extends QuaternaryArgs {
        @Override
        protected Datum execute(Datum c1a, Datum c2a, Datum c3a, Datum c4a, Environment env, LispMessage mesg) {
            ArrayList<String> ss = new ArrayList<String>();
            ConsIterator jtr = new ConsIterator(c1a);
            while (jtr.hasNext()) {
                Datum d = jtr.next();
                if (d instanceof LispCharacter) {
                    ss.add(Strings.newString(d.getCharacterCodePoint()));
                    continue;
                }
                ss.add(SubrUtils.getString(d, mesg));
            }
            Procedure p = SubrUtils.getProcedure(c4a, mesg);
            return new Option0(p, c2a.isTrue(), c3a.isTrue(), ss);
        }
    }

    static class Option0
    extends Datum2
    implements OptionObject {
        private OptionProcessor prcs;
        List<String> names;
        boolean required;
        boolean optional;
        Procedure proc;

        Option0(Procedure p, boolean req, boolean opt, List<String> ns) {
            this.proc = p;
            this.required = req;
            this.optional = opt;
            this.names = Collections.unmodifiableList(ns);
            this.prcs = SRFI37.toOption(p);
        }

        Option0(Procedure p, boolean req, boolean opt, String ... ns) {
            this(p, req, opt, Arrays.asList(ns));
        }

        @Override
        public List<String> getNames() {
            return this.names;
        }

        @Override
        public boolean isArgumentRequired() {
            return this.required;
        }

        @Override
        public boolean isArgumentOptional() {
            return this.optional;
        }

        @Override
        public OptionProcessor getProcessor() {
            return this.prcs;
        }

        @Override
        public void toDisplayString(StringBuilder buf) {
            buf.append("#<option>");
        }
    }

    public static class OptionNames
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            ConsListBuilder b = new ConsListBuilder();
            if (c1a instanceof Option0) {
                for (String s : ((Option0)c1a).names) {
                    b.append(new LispString(s));
                }
                return b.get();
            }
            throw mesg.getError("err.srfi37.require.option", c1a);
        }
    }

    public static class SubrOptionProcessor
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof Option0) {
                return (Datum)((Object)((Option0)c1a).proc);
            }
            throw mesg.getError("err.srfi37.require.option", c1a);
        }
    }
}

