/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.morilib.lisp.Datum;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.Undef;
import net.morilib.lisp.accessor.ILispRef;
import net.morilib.lisp.subr.SubrUtils;

public class MultiValues
extends Datum
implements ILispRef {
    private List<? extends Datum> values;

    private MultiValues(List<? extends Datum> values) {
        if (values == null) {
            throw new NullPointerException();
        }
        this.values = values;
    }

    public static Datum newValues(List<? extends Datum> values) {
        if (values.size() == 0) {
            return Undef.UNDEF;
        }
        if (values.size() == 1) {
            return values.get(0);
        }
        return new MultiValues(values);
    }

    public static Datum newValues(Datum ... values) {
        if (values.length == 0) {
            return Undef.UNDEF;
        }
        if (values.length == 1) {
            return values[0];
        }
        return new MultiValues(Arrays.asList(values));
    }

    @Override
    public boolean isTrue() {
        return this.values.isEmpty() || this.values.get(0).isTrue();
    }

    @Override
    public List<Datum> getValues() {
        return Collections.unmodifiableList(this.values);
    }

    @Override
    public int howManyValues() {
        return this.values.size();
    }

    @Override
    public Datum getValueOf(int x) {
        if (x >= 0 && x < this.values.size()) {
            return this.values.get(x);
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public Datum ref(Datum arg, LispMessage mesg) {
        int k = SubrUtils.getSmallInt(arg, mesg);
        if (k < 0 || k >= this.values.size()) {
            throw mesg.getError("err.accessor.ref.outofrange", arg);
        }
        return this.values.get(k);
    }
}

