/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.morilib.lisp.Closure;
import net.morilib.lisp.ClosureClass;
import net.morilib.lisp.CodeExecutor;
import net.morilib.lisp.CodeExecutorFactory;
import net.morilib.lisp.CompiledCode;
import net.morilib.lisp.Cons;
import net.morilib.lisp.Datum;
import net.morilib.lisp.Environment;
import net.morilib.lisp.ExceptionObject;
import net.morilib.lisp.IntStack;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispException;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.Nil;
import net.morilib.lisp.SRFI34;
import net.morilib.lisp.Subr;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.Undef;
import net.morilib.lisp.datetime.LispTime;
import net.morilib.lisp.subr.BinaryArgs;
import net.morilib.lisp.subr.UnaryArgs;

public class LispThread
extends Datum
implements Runnable {
    static final ClosureClass DEFAULT_CURRENT_EXCEPTION_HANDLER;
    private static ThreadLocal<ThSp> threadLocal;
    private static Set<Thread> terminatedThreads;
    private static Map<LispThread, Datum> resultField;
    private Thread thread;
    private Throwable uncaughtException = null;
    private Datum specific = Undef.UNDEF;

    static {
        threadLocal = new ThreadLocal<ThSp>(){

            @Override
            protected ThSp initialValue() {
                return new ThSp();
            }
        };
        terminatedThreads = new HashSet<Thread>();
        resultField = new HashMap<LispThread, Datum>();
        threadLocal.get().lispThread = new LispThread(Thread.currentThread());
        CompiledCode.Builder bld = new CompiledCode.Builder();
        ClosureClass cl1 = new ClosureClass();
        Cons c1 = new Cons();
        bld.addPush(new SRFI34.Raise());
        bld.addBeginList();
        bld.addReferSymbol(Symbol.getSymbol("obj"));
        bld.addAppendList();
        bld.addEndList();
        bld.addCall();
        bld.addReturnOp();
        c1.setCar(Symbol.getSymbol("obj"));
        cl1.setParameterList(c1);
        cl1.setCode(bld.getCodeRef());
        DEFAULT_CURRENT_EXCEPTION_HANDLER = cl1;
    }

    private LispThread(Thread th) {
        this.thread = th;
    }

    LispThread(String name, final LispMessage msg, final CompiledCode code, final Environment env) {
        Runnable run = new Runnable(){

            @Override
            public void run() {
                ((ThSp)threadLocal.get()).lispThread = LispThread.this;
                CodeExecutor exe = CodeExecutorFactory.getInstance(msg);
                IntStack m = exe.newMemento();
                try {
                    resultField.put(LispThread.this, exe.exec(code, new Environment(env), m));
                }
                catch (LispException e) {
                    String tra = m.getStackTrace();
                    System.err.println(String.valueOf(msg.get("err.repl.err")) + e.getMessage());
                    if (tra != null && !tra.equals("")) {
                        System.err.println(msg.get("err.stacktrace"));
                        System.err.print(tra);
                    }
                    LispThread.this.uncaughtException = e;
                }
            }
        };
        if (code == null) {
            throw new NullPointerException();
        }
        if (env == null) {
            throw new NullPointerException();
        }
        if (msg == null) {
            throw new NullPointerException();
        }
        this.thread = name != null ? new Thread(run, name) : new Thread(run);
    }

    private static void callTime(Datum c1a, CallTh th, LispMessage mesg) throws InterruptedException {
        block11: {
            block12: {
                block10: {
                    if (!(c1a instanceof LispReal)) break block10;
                    double d = c1a.getRealDouble();
                    if (!(d < 0.001)) {
                        if (d > 9.223372036854776E15) {
                            th.run(Long.MAX_VALUE);
                        } else {
                            th.run((long)(d * 1000.0), (int)(d * 1.0E9) % 1000000);
                        }
                    }
                    break block11;
                }
                if (!(c1a instanceof LispTime)) break block12;
                LispTime d = (LispTime)c1a;
                switch (d.getTimeType()) {
                    case TIME_DURATION: {
                        long sec = d.getSecond();
                        int nanos = d.getNanosecond();
                        if (sec + (long)(nanos / 1000000) >= 1L) {
                            th.run(sec + (long)(nanos / 1000000), nanos % 1000000);
                            break;
                        }
                        break block11;
                    }
                    default: {
                        long td = d.toUTCTime().getTimeMillis();
                        if ((td -= System.currentTimeMillis()) >= 1L) {
                            th.run(td);
                            break;
                        }
                        break block11;
                    }
                }
                break block11;
            }
            if (!c1a.isTrue()) {
                th.run(0L);
            } else {
                throw mesg.getError("err.srfi18.require.realortime", c1a);
            }
        }
    }

    private static void _wait(final Object m, Datum time, LispMessage mesg) throws InterruptedException {
        CallTh ct = new CallTh(){

            @Override
            public void run(long millis) throws InterruptedException {
                m.wait(millis);
            }

            @Override
            public void run(long millis, int nanos) throws InterruptedException {
                m.wait(millis, nanos);
            }
        };
        LispThread.callTime(time, ct, mesg);
    }

    public void start() {
        this.thread.start();
    }

    public static LispThread currentThread() {
        return threadLocal.get().lispThread;
    }

    public boolean isAlive() {
        return this.thread.isAlive();
    }

    public static boolean isTerminated() {
        return terminatedThreads.contains(Thread.currentThread());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void acceptTerminate() {
        Set<Thread> set = terminatedThreads;
        synchronized (set) {
            terminatedThreads.remove(Thread.currentThread());
        }
    }

    public String getThreadName() {
        return this.thread.getName();
    }

    @Override
    public void run() {
        this.thread.run();
    }

    @Override
    public void toDisplayString(StringBuilder buf) {
        buf.append("#<thread>");
    }

    private static interface CallTh {
        public void run(long var1) throws InterruptedException;

        public void run(long var1, int var3) throws InterruptedException;
    }

    private static class ConditionVariable
    extends Datum {
        private boolean wait = false;
        private String name;
        private Datum specific = Nil.NIL;

        private ConditionVariable() {
        }

        private ConditionVariable(String s) {
            this.name = s;
        }

        @Override
        public void toDisplayString(StringBuilder buf) {
            buf.append("#<condition-variable>");
        }
    }

    public static class ConditionVariableBroadcastS
    extends UnaryArgs {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof ConditionVariable) {
                ConditionVariable cv;
                ConditionVariable conditionVariable = cv = (ConditionVariable)c1a;
                synchronized (conditionVariable) {
                    cv.wait = false;
                    cv.notifyAll();
                }
                return Undef.UNDEF;
            }
            throw mesg.getError("err.srfi18.require.condition", c1a);
        }
    }

    public static class ConditionVariableName
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof ConditionVariable) {
                return Symbol.getSymbol(((ConditionVariable)c1a).name);
            }
            throw mesg.getError("err.srfi18.require.condition", c1a);
        }
    }

    public static class ConditionVariableSignalS
    extends UnaryArgs {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof ConditionVariable) {
                ConditionVariable cv;
                ConditionVariable conditionVariable = cv = (ConditionVariable)c1a;
                synchronized (conditionVariable) {
                    cv.wait = false;
                    cv.notify();
                }
                return Undef.UNDEF;
            }
            throw mesg.getError("err.srfi18.require.condition", c1a);
        }
    }

    public static class ConditionVariableSpecific
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof ConditionVariable) {
                return ((ConditionVariable)c1a).specific;
            }
            throw mesg.getError("err.srfi18.require.condition", c1a);
        }
    }

    public static class ConditionVariableSpecificSetS
    extends BinaryArgs {
        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            if (c1a instanceof ConditionVariable) {
                ((ConditionVariable)c1a).specific = c2a;
                return Undef.UNDEF;
            }
            throw mesg.getError("err.srfi18.require.condition", c1a);
        }
    }

    public static class CurrentExceptionHandler
    extends Subr {
        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            throw new RuntimeException();
        }

        @Override
        ClosureClass createClosureClass(Environment env) {
            CompiledCode.Builder bld = new CompiledCode.Builder();
            ClosureClass cl1 = new ClosureClass();
            bld.addGetCurrentExceptionHandler();
            bld.addReturnOp();
            cl1.setParameterList(Nil.NIL);
            cl1.setCode(bld.getCodeRef());
            return cl1;
        }
    }

    public static class CurrentThread
    extends Subr {
        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            if (!body.equals(Nil.NIL)) {
                throw mesg.getError("err.argument", body);
            }
            return LispThread.currentThread();
        }
    }

    public static class IsAbandonedMutexException
    extends ExceptionObject.IsExceptionType {
        @Override
        protected boolean validate(String errorCode) {
            return errorCode.equals("err.srfi18.abandonedmutex");
        }
    }

    public static class IsConditionVariable
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            return LispBoolean.getInstance(c1a instanceof ConditionVariable);
        }
    }

    public static class IsJoinTimeoutException
    extends ExceptionObject.IsExceptionType {
        @Override
        protected boolean validate(String errorCode) {
            return errorCode.equals("err.srfi18.jointimeout");
        }
    }

    public static class IsMutex
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            return LispBoolean.getInstance(c1a instanceof Mutex);
        }
    }

    public static class IsTerminatedThreadException
    extends ExceptionObject.IsExceptionType {
        @Override
        protected boolean validate(String errorCode) {
            return errorCode.equals("err.srfi18.threadterminated");
        }
    }

    public static class IsThread
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            return LispBoolean.getInstance(c1a instanceof LispThread);
        }
    }

    public static class IsUncaughtException
    extends ExceptionObject.IsExceptionType {
        @Override
        protected boolean validate(String errorCode) {
            return errorCode.equals("err.srfi18.uncaught");
        }
    }

    public static class MakeConditionVariable
    extends Subr {
        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            List<Datum> l = LispUtils.consToList(body, mesg);
            if (l.size() == 0) {
                return new ConditionVariable();
            }
            if (!(l.get(0) instanceof Symbol)) {
                throw mesg.getError("err.require.symbol", l.get(0));
            }
            if (l.size() == 1) {
                return new ConditionVariable(((Symbol)l.get(0)).getName());
            }
            throw mesg.getError("err.argument", body);
        }
    }

    public static class MakeMutex
    extends Subr {
        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            List<Datum> l = LispUtils.consToList(body, mesg);
            if (l.size() == 0) {
                return new Mutex();
            }
            if (!(l.get(0) instanceof Symbol)) {
                throw mesg.getError("err.require.symbol", l.get(0));
            }
            if (l.size() == 1) {
                return new Mutex(((Symbol)l.get(0)).getName());
            }
            throw mesg.getError("err.argument", body);
        }
    }

    public static class MakeThread
    extends Subr {
        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            String name = null;
            if (!(body instanceof Cons)) {
                throw mesg.getError("err.argument", body);
            }
            if (!(((Cons)body).getCar() instanceof Closure)) {
                throw mesg.getError("err.require.closure", ((Cons)body).getCar());
            }
            Closure cl = (Closure)((Cons)body).getCar();
            CompiledCode c = cl.getCode();
            Environment e2 = cl.getEnvironment();
            Datum d1 = ((Cons)body).getCdr();
            if (d1 instanceof Cons) {
                Cons d1c = (Cons)d1;
                if (d1c.getCar() instanceof Symbol) {
                    name = ((Symbol)d1c.getCar()).getName();
                    d1 = d1c.getCdr();
                } else {
                    throw mesg.getError("err.require.symbol", d1c.getCar());
                }
            }
            if (!d1.equals(Nil.NIL)) {
                throw mesg.getError("err.argument", body);
            }
            return new LispThread(name, mesg, c, e2);
        }
    }

    private static class Mutex
    extends Datum {
        private boolean locked = false;
        private boolean wait = false;
        private String name;
        private Datum specific = Nil.NIL;
        private LispThread owner = null;

        private Mutex() {
        }

        private Mutex(String s) {
            this.name = s;
        }

        @Override
        public void toDisplayString(StringBuilder buf) {
            buf.append("#<mutex>");
        }
    }

    public static class MutexLockS
    extends Subr {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            List<Datum> l = LispUtils.consToList(body, mesg);
            Datum time = null;
            LispThread lt = LispThread.currentThread();
            if (l.size() < 1 || l.size() > 3) {
                throw mesg.getError("err.argument", body);
            }
            if (!(l.get(0) instanceof Mutex)) {
                throw mesg.getError("err.srfi18.require.mutex", l.get(0));
            }
            if (l.size() != 1) {
                if (l.size() == 2) {
                    if (l.get(1).isTrue()) {
                        time = l.get(1);
                    }
                } else if (!l.get(2).isTrue()) {
                    time = l.get(1);
                } else if (l.get(2) instanceof LispThread) {
                    time = l.get(1);
                    lt = (LispThread)l.get(2);
                } else {
                    throw mesg.getError("err.srfi18.require.thread", l.get(2));
                }
            }
            boolean res = true;
            Mutex m = (Mutex)l.get(0);
            if (m.locked) {
                m.wait = true;
                Mutex mutex = m;
                synchronized (mutex) {
                    try {
                        if (time == null) {
                            m.wait();
                        } else {
                            LispThread._wait(m, time, mesg);
                        }
                        res = !m.wait;
                    }
                    catch (InterruptedException e) {
                        throw mesg.getError("err.srfi18.interrupted");
                    }
                }
                m.wait = false;
            } else if (m.owner != null && !m.owner.isAlive()) {
                throw mesg.getError("err.srfi18.abandonedmutex");
            }
            m.locked = true;
            m.owner = lt;
            return LispBoolean.getInstance(res);
        }
    }

    public static class MutexName
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof Mutex) {
                return Symbol.getSymbol(((Mutex)c1a).name);
            }
            throw mesg.getError("err.srfi18.require.mutex", c1a);
        }
    }

    public static class MutexSpecific
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof Mutex) {
                return ((Mutex)c1a).specific;
            }
            throw mesg.getError("err.srfi18.require.mutex", c1a);
        }
    }

    public static class MutexSpecificSetS
    extends BinaryArgs {
        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            if (c1a instanceof Mutex) {
                ((Mutex)c1a).specific = c2a;
                return Undef.UNDEF;
            }
            throw mesg.getError("err.srfi18.require.mutex", c1a);
        }
    }

    public static class MutexState
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof Mutex) {
                Mutex m = (Mutex)c1a;
                if (m.owner != null && !m.owner.isAlive()) {
                    return Symbol.getSymbol("abandoned");
                }
                if (m.locked && m.owner != null) {
                    return m.owner;
                }
                if (m.locked) {
                    return Symbol.getSymbol("not-owned");
                }
                return Symbol.getSymbol("not-abandoned");
            }
            throw mesg.getError("err.srfi18.require.mutex", c1a);
        }
    }

    public static class MutexUnlockS
    extends Subr {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            Datum datum;
            List<Datum> l = LispUtils.consToList(body, mesg);
            ConditionVariable cv = null;
            if (l.size() < 1 || l.size() > 3) {
                throw mesg.getError("err.argument", body);
            }
            if (!(l.get(0) instanceof Mutex)) {
                throw mesg.getError("err.srfi18.require.mutex", l.get(0));
            }
            if (l.size() != 1) {
                if (!(l.get(1) instanceof ConditionVariable)) {
                    throw mesg.getError("err.srfi18.require.condition", l.get(0));
                }
                cv = (ConditionVariable)l.get(1);
            }
            Mutex m = (Mutex)l.get(0);
            boolean res = true;
            m.locked = false;
            if (cv != null) {
                try {
                    cv.wait = true;
                    datum = cv;
                    synchronized (datum) {
                        if (l.size() == 2) {
                            cv.wait();
                        } else {
                            LispThread._wait(cv, l.get(2), mesg);
                        }
                        res = !cv.wait;
                    }
                    cv.wait = false;
                }
                catch (InterruptedException e) {
                    throw mesg.getError("err.srfi18.interrupted");
                }
            }
            datum = m;
            synchronized (datum) {
                m.wait = false;
                m.notify();
            }
            return LispBoolean.getInstance(res);
        }
    }

    public static class SecondsToTime
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof LispReal) {
                return new LispTime(LispTime.TimeType.TIME_UTC, (LispReal)c1a);
            }
            throw mesg.getError("err.require.real", c1a);
        }
    }

    private static class ThSp {
        private LispThread lispThread;

        private ThSp() {
        }
    }

    public static class ThreadJoinS
    extends Subr {
        private Datum getResult(LispThread d, LispMessage mesg) {
            if (d.uncaughtException != null) {
                if (d.uncaughtException instanceof LispException) {
                    LispException le = (LispException)d.uncaughtException;
                    if (le.getErrorCode().equals("err.srfi18.threadterminated")) {
                        throw le;
                    }
                    throw mesg.getUncaughtException(le);
                }
                throw new RuntimeException(d.uncaughtException);
            }
            return (Datum)resultField.get(d);
        }

        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            List<Datum> l = LispUtils.consToList(body, mesg);
            try {
                if (l.size() < 1 || l.size() > 3) {
                    throw mesg.getError("err.argument", body);
                }
                if (!(l.get(0) instanceof LispThread)) {
                    throw mesg.getError("err.srfi18.require.thread", l.get(0));
                }
                if (l.size() == 1) {
                    ((LispThread)l.get(0)).thread.join();
                    return this.getResult((LispThread)l.get(0), mesg);
                }
                final LispThread d = (LispThread)l.get(0);
                CallTh ct = new CallTh(){

                    @Override
                    public void run(long millis) throws InterruptedException {
                        d.thread.join(millis);
                    }

                    @Override
                    public void run(long millis, int nanos) throws InterruptedException {
                        d.thread.join(millis, nanos);
                    }
                };
                LispThread.callTime(l.get(1), ct, mesg);
                if (d.thread.isAlive()) {
                    if (l.size() == 3) {
                        return l.get(2);
                    }
                    throw mesg.getError("err.srfi18.jointimeout");
                }
                return this.getResult((LispThread)l.get(0), mesg);
            }
            catch (InterruptedException e) {
                throw mesg.getError("err.srfi18.interrupted");
            }
        }
    }

    public static class ThreadName
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof LispThread) {
                return Symbol.getSymbol(((LispThread)c1a).getThreadName());
            }
            throw mesg.getError("err.srfi18.require.thread", c1a);
        }
    }

    public static class ThreadSleepS
    extends UnaryArgs {
        private static final CallTh TH1 = new CallTh(){

            @Override
            public void run(long millis) throws InterruptedException {
                Thread.sleep(millis);
            }

            @Override
            public void run(long millis, int nanos) throws InterruptedException {
                Thread.sleep(millis, nanos);
            }
        };

        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            try {
                LispThread.callTime(c1a, ThreadSleepS.TH1, mesg);
            }
            catch (InterruptedException e) {
                throw mesg.getError("err.srfi18.interrupted");
            }
            return null;
        }
    }

    public static class ThreadSpecific
    extends UnaryArgs {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof LispThread) {
                Datum datum = c1a;
                synchronized (datum) {
                    return ((LispThread)c1a).specific;
                }
            }
            throw mesg.getError("err.srfi18.require.thread", c1a);
        }
    }

    public static class ThreadSpecificSetS
    extends BinaryArgs {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Datum execute(Datum c1a, Datum c2a, Environment env, LispMessage mesg) {
            if (c1a instanceof LispThread) {
                Datum datum = c1a;
                synchronized (datum) {
                    ((LispThread)c1a).specific = c2a;
                    return Undef.UNDEF;
                }
            }
            throw mesg.getError("err.srfi18.require.thread", c1a);
        }
    }

    public static class ThreadStartS
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof LispThread) {
                ((LispThread)c1a).start();
                return c1a;
            }
            throw mesg.getError("err.srfi18.require.thread", c1a);
        }
    }

    public static class ThreadTerminateS
    extends UnaryArgs {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof LispThread) {
                Set set = terminatedThreads;
                synchronized (set) {
                    terminatedThreads.add(((LispThread)c1a).thread);
                }
                return Undef.UNDEF;
            }
            throw mesg.getError("err.srfi18.require.thread", c1a);
        }
    }

    public static class ThreadYieldS
    extends Subr {
        @Override
        public Datum eval(Datum body, Environment env, LispMessage mesg) {
            if (body.equals(Nil.NIL)) {
                Thread.yield();
                return Undef.UNDEF;
            }
            throw mesg.getError("err.argument", body);
        }
    }

    public static class TimeToSeconds
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof LispTime) {
                return ((LispTime)c1a).getSecond2();
            }
            throw mesg.getError("err.srfi19.require.time", c1a);
        }
    }

    public static class UncaughtExceptionReason
    extends UnaryArgs {
        @Override
        protected Datum execute(Datum c1a, Environment env, LispMessage mesg) {
            if (c1a instanceof ExceptionObject) {
                LispException le = ((ExceptionObject)c1a).getException();
                Throwable r = le.getCause();
                if (le.getErrorCode().equals("err.srfi18.uncaught")) {
                    if (r instanceof SRFI34.RaisedException) {
                        return ((SRFI34.RaisedException)r).raised;
                    }
                    return new ExceptionObject((LispException)r);
                }
            }
            throw mesg.getError("err.srfi18.require.uncaught", c1a);
        }
    }
}

