/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.io.Serializable;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.LispReal;

public class LispRangedDouble
extends LispDouble
implements Serializable {
    double error;

    LispRangedDouble(double x, double error) {
        super(LispRangedDouble.trim(x, error));
        this.error = Double.parseDouble(String.format("%.3g", error));
    }

    private static double trim(double x, double err) {
        int d = 1;
        int i = 1;
        while ((double)i < Math.abs(x / err)) {
            i *= 10;
            ++d;
        }
        return Double.parseDouble(String.format("%." + d + "g", x));
    }

    public static LispDouble valueOf(double x, double error) {
        if (error == 0.0) {
            return new LispDouble(x);
        }
        return new LispRangedDouble(x, Math.abs(error));
    }

    public double getMaxDouble() {
        return this.number + this.error;
    }

    public double getMinDouble() {
        return this.number - this.error;
    }

    public boolean isZeroIncluded() {
        return this.getMaxDouble() > 0.0 && this.getMinDouble() < 0.0 || this.getMaxDouble() == 0.0 || this.getMinDouble() == 0.0;
    }

    @Override
    public LispReal multiply(int n) {
        return new LispRangedDouble(this.number * (double)n, this.error * (double)n);
    }

    @Override
    public LispReal power(int n) {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        if (n == 0) {
            return LispDouble.ONE;
        }
        if (n == 1) {
            return this;
        }
        if (this.number - this.error >= 0.0) {
            double min = Math.pow(this.number - this.error, n);
            double max = Math.pow(this.number + this.error, n);
            return LispRangedDouble.valueOf((max + min) / 2.0, (max - min) / 2.0);
        }
        if (n % 2 == 1) {
            double min = Math.pow(this.number - this.error, n);
            double max = Math.pow(this.number + this.error, n);
            int i = 0;
            while (i < n) {
                min *= min;
                max *= max;
                ++i;
            }
            return LispRangedDouble.valueOf((max + min) / 2.0, (max - min) / 2.0);
        }
        if (this.number + this.error >= 0.0) {
            double max = Math.pow(Math.max(this.error - this.number, this.number + this.error), n);
            return LispRangedDouble.valueOf(max / 2.0, max / 2.0);
        }
        double min = Math.pow(-(this.number + this.error), n);
        double max = Math.pow(-(this.number - this.error), n);
        return LispRangedDouble.valueOf((max + min) / 2.0, (max - min) / 2.0);
    }

    @Override
    public LispReal invert() {
        if (this.number - this.error > 0.0) {
            double min = 1.0 / (this.number + this.error);
            double max = 1.0 / (this.number - this.error);
            return LispRangedDouble.valueOf((max + min) / 2.0, (max - min) / 2.0);
        }
        if (this.number - this.error == 0.0) {
            return LispDouble.NaN;
        }
        if (this.number + this.error > 0.0) {
            return LispDouble.NaN;
        }
        if (this.number + this.error == 0.0) {
            return LispDouble.NaN;
        }
        double min = 1.0 / -(this.number - this.error);
        double max = 1.0 / -(this.number + this.error);
        return LispRangedDouble.valueOf((max + min) / 2.0, (max - min) / 2.0);
    }

    @Override
    public LispRangedDouble uminus() {
        return new LispRangedDouble(-this.number, this.error);
    }

    @Override
    public String getResult() {
        int d = 1;
        if (Double.isNaN(this.number) || Double.isInfinite(this.number)) {
            return LispRangedDouble.disp(this.number);
        }
        if (this.number == 0.0) {
            return String.format("0.0+-%.3g", this.error);
        }
        int i = 1;
        while ((double)i < Math.abs(this.number / this.error)) {
            i *= 10;
            ++d;
        }
        return String.format("%." + d + "g+-%.3g", this.number, this.error);
    }

    @Override
    public int hashCode() {
        int h = 17;
        h = 37 * ((int)Double.doubleToLongBits(this.number) + h);
        h = 37 * ((int)Double.doubleToLongBits(this.error) + h);
        return h;
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof LispRangedDouble && this.number == ((LispRangedDouble)o).number && this.error == ((LispRangedDouble)o).error;
    }

    @Override
    public LispNumber add(LispNumber x) {
        if (x instanceof LispRangedDouble) {
            return LispRangedDouble.valueOf(this.number + ((LispRangedDouble)x).number, Math.max(this.error, ((LispRangedDouble)x).error));
        }
        if (x instanceof LispReal) {
            return LispRangedDouble.valueOf(this.number + x.getRealDouble(), this.error);
        }
        return super.add(x);
    }

    @Override
    public LispNumber sub(LispNumber x) {
        if (x instanceof LispRangedDouble) {
            return LispRangedDouble.valueOf(this.number - ((LispRangedDouble)x).number, Math.max(this.error, ((LispRangedDouble)x).error));
        }
        if (x instanceof LispReal) {
            return LispRangedDouble.valueOf(this.number - x.getRealDouble(), this.error);
        }
        return super.sub(x);
    }

    @Override
    public LispNumber mul(LispNumber x) {
        if (x instanceof LispRangedDouble) {
            LispRangedDouble x0 = (LispRangedDouble)x;
            double y0 = this.number * x0.number;
            double y1 = y0 + this.number * x0.error + x0.number * this.error;
            double y2 = y0 - this.number * x0.error + x0.number * this.error;
            double y3 = y0 + this.number * x0.error - x0.number * this.error;
            double y4 = y0 - this.number * x0.error - x0.number * this.error;
            double ya = Math.max(y1, y2);
            double yc = Math.min(y1, y2);
            double yb = Math.max(y3, y4);
            double yd = Math.min(y3, y4);
            double mx = Math.max(ya, yb);
            double mn = Math.min(yc, yd);
            return LispRangedDouble.valueOf((mx + mn) / 2.0, (mx - mn) / 2.0);
        }
        if (x instanceof LispReal) {
            return LispRangedDouble.valueOf(this.number * x.getRealDouble(), this.error * x.getRealDouble());
        }
        return super.mul(x);
    }

    @Override
    public LispNumber div(LispNumber x) {
        if (x instanceof LispRangedDouble) {
            LispRangedDouble x0 = (LispRangedDouble)x;
            if (x0.isZeroIncluded()) {
                return LispDouble.NaN;
            }
            double y0 = this.number / x0.number;
            double y1 = y0 + this.number * x0.error + x0.number * this.error;
            double y2 = y0 - this.number * x0.error + x0.number * this.error;
            double y3 = y0 + this.number * x0.error - x0.number * this.error;
            double y4 = y0 - this.number * x0.error - x0.number * this.error;
            double ya = Math.max(y1, y2);
            double yc = Math.min(y1, y2);
            double yb = Math.max(y3, y4);
            double yd = Math.min(y3, y4);
            double mx = Math.max(ya, yb);
            double mn = Math.min(yc, yd);
            return LispRangedDouble.valueOf((mx + mn) / 2.0, (mx - mn) / 2.0);
        }
        if (x instanceof LispReal) {
            if (x.getRealDouble() == 0.0) {
                return LispDouble.NaN;
            }
            double y1 = (this.number + this.error) / x.getRealDouble();
            double y2 = (this.number - this.error) / x.getRealDouble();
            return LispRangedDouble.valueOf((y1 + y2) / 2.0, Math.abs(y1 - y2) / 2.0);
        }
        return super.sub(x);
    }
}

