/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import net.morilib.lisp.Cons;
import net.morilib.lisp.ConsListBuilder;
import net.morilib.lisp.Datum;
import net.morilib.lisp.JavaException;
import net.morilib.lisp.JavaInstance;
import net.morilib.lisp.JavaNull;
import net.morilib.lisp.JavaObjective;
import net.morilib.lisp.JavaTargetException;
import net.morilib.lisp.LispBoolean;
import net.morilib.lisp.LispCharacter;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.LispString;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.LispVector;
import net.morilib.lisp.Nil;
import net.morilib.lisp.ParameterNotFoundException;
import net.morilib.lisp.util.ReflContainer;

public final class LispJavaUtils {
    static final String[] JAVAPATH = new String[]{"net.morilib.lisp.swing"};

    private LispJavaUtils() {
    }

    private static Class<?> getCompornentType(Class<?> cl) {
        if (cl.isArray()) {
            return cl.getComponentType();
        }
        if (cl.isAssignableFrom(List.class)) {
            return null;
        }
        return null;
    }

    static boolean isAssignableInt(Class<?> rtp) {
        return Integer.TYPE.isAssignableFrom(rtp) || Integer.class.isAssignableFrom(rtp);
    }

    static boolean isAssignableLong(Class<?> rtp) {
        return Long.TYPE.isAssignableFrom(rtp) || Long.class.isAssignableFrom(rtp);
    }

    static boolean isAssignableFloat(Class<?> rtp) {
        return Float.TYPE.isAssignableFrom(rtp) || Float.class.isAssignableFrom(rtp);
    }

    static boolean isAssignableDouble(Class<?> rtp) {
        return Double.TYPE.isAssignableFrom(rtp) || Double.class.isAssignableFrom(rtp);
    }

    static boolean isAssignableBigInteger(Class<?> rtp) {
        return BigInteger.class.isAssignableFrom(rtp);
    }

    static boolean isAssignableBigDecimal(Class<?> rtp) {
        return BigDecimal.class.isAssignableFrom(rtp);
    }

    /*
     * Unable to fully structure code
     */
    static boolean isSameClass(Class<?> cl, Datum ld) {
        block14: {
            if (cl.equals(Object.class)) {
                return true;
            }
            if (ld instanceof LispString) {
                return cl.isAssignableFrom(String.class);
            }
            if (ld instanceof LispBoolean) {
                return cl.isAssignableFrom(Boolean.TYPE) != false || cl.isAssignableFrom(Boolean.class) != false;
            }
            if (ld instanceof LispCharacter) {
                return cl.isAssignableFrom(Character.TYPE) != false || cl.isAssignableFrom(Character.class) != false;
            }
            if (ld instanceof LispInteger) {
                return LispJavaUtils.isAssignableInt(cl) != false || LispJavaUtils.isAssignableLong(cl) != false || LispJavaUtils.isAssignableFloat(cl) != false || LispJavaUtils.isAssignableDouble(cl) != false || LispJavaUtils.isAssignableBigInteger(cl) != false || LispJavaUtils.isAssignableBigDecimal(cl) != false;
            }
            if (ld instanceof LispReal) {
                return LispJavaUtils.isAssignableInt(cl) != false || LispJavaUtils.isAssignableLong(cl) != false || LispJavaUtils.isAssignableFloat(cl) != false || LispJavaUtils.isAssignableDouble(cl) != false || LispJavaUtils.isAssignableBigInteger(cl) != false || LispJavaUtils.isAssignableBigDecimal(cl) != false;
            }
            if (!(ld instanceof Cons)) break block14;
            p = ld;
            cc = LispJavaUtils.getCompornentType(cl);
            if (cc != null) ** GOTO lbl25
            return false;
lbl-1000:
            // 1 sources

            {
                if (p instanceof Cons) {
                    c = (Cons)p;
                    if (!LispJavaUtils.isSameClass(cc, c.getCar())) {
                        return false;
                    }
                    p = c.getCdr();
                    continue;
                }
                return false;
lbl25:
                // 2 sources

                ** while (p != Nil.NIL)
            }
lbl26:
            // 1 sources

            return true;
        }
        if (ld instanceof LispVector) {
            cc = LispJavaUtils.getCompornentType(cl);
            if (cc == null) {
                return false;
            }
            for (Datum o : ((LispVector)ld).getList()) {
                if (LispJavaUtils.isSameClass(cc, o)) continue;
                return false;
            }
            return true;
        }
        if (ld instanceof JavaInstance) {
            return cl.isAssignableFrom(((JavaInstance)ld).getJavaInstance().getClass());
        }
        if (ld == JavaNull.JAVA_NULL) {
            return true;
        }
        return ld == Nil.NIL;
    }

    static boolean isSameClasses(Class<?>[] cl, List<Datum> ld, boolean varargs) {
        if (!varargs && cl.length != ld.size()) {
            return false;
        }
        if (cl.length - 1 > ld.size()) {
            return false;
        }
        int i = 0;
        while (i < ld.size()) {
            if (varargs && i >= cl.length - 1) {
                Class<?> lcl = cl[cl.length - 1];
                if (!lcl.isArray()) {
                    return false;
                }
                if (!LispJavaUtils.isSameClass(lcl.getComponentType(), ld.get(i))) {
                    return false;
                }
            } else if (!LispJavaUtils.isSameClass(cl[i], ld.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    static Object toJavaInstance(Class<?> cl, Datum d) {
        if (cl.equals(Object.class)) {
            return d;
        }
        if (d instanceof LispString) {
            return d.getString();
        }
        if (d instanceof LispBoolean) {
            return d.isTrue();
        }
        if (d instanceof LispCharacter) {
            return new Character(d.getCharacter());
        }
        if (d instanceof LispInteger) {
            if (LispJavaUtils.isAssignableInt(cl)) {
                return new Integer(d.getInt());
            }
            if (LispJavaUtils.isAssignableLong(cl)) {
                return new Long(d.getLong());
            }
            if (LispJavaUtils.isAssignableFloat(cl)) {
                return new Float(d.getRealDouble());
            }
            if (LispJavaUtils.isAssignableDouble(cl)) {
                return new Double(d.getRealDouble());
            }
            if (LispJavaUtils.isAssignableBigInteger(cl)) {
                return d.getBigInteger();
            }
            if (LispJavaUtils.isAssignableBigDecimal(cl)) {
                return d.getBigDecimal();
            }
            throw new ClassCastException(cl.getName());
        }
        if (d instanceof LispReal) {
            if (LispJavaUtils.isAssignableInt(cl)) {
                return new Integer(d.getInt());
            }
            if (LispJavaUtils.isAssignableLong(cl)) {
                return new Long(d.getLong());
            }
            if (LispJavaUtils.isAssignableFloat(cl)) {
                return new Float(d.getRealDouble());
            }
            if (LispJavaUtils.isAssignableDouble(cl)) {
                return new Double(d.getRealDouble());
            }
            if (LispJavaUtils.isAssignableBigInteger(cl)) {
                return d.getBigInteger();
            }
            if (LispJavaUtils.isAssignableBigDecimal(cl)) {
                return d.getBigDecimal();
            }
            throw new ClassCastException(cl.getName());
        }
        if (d instanceof Cons) {
            Datum p = d;
            Class<?> cc = LispJavaUtils.getCompornentType(cl);
            int len = LispUtils.consLength(d);
            if (cc == null) {
                throw new ClassCastException(cl.getName());
            }
            ReflContainer cnt = new ReflContainer(cl, len);
            int i = 0;
            while (p != Nil.NIL) {
                if (!(p instanceof Cons)) {
                    throw new ClassCastException(cl.getName());
                }
                Cons c = (Cons)p;
                cnt.set(i, LispJavaUtils.toJavaInstance(cc, c.getCar()));
                p = c.getCdr();
                ++i;
            }
            return cnt.toObject();
        }
        if (d instanceof LispVector) {
            Class<?> cc = LispJavaUtils.getCompornentType(cl);
            int len = LispUtils.consLength(d);
            if (cc == null) {
                throw new ClassCastException(cl.getName());
            }
            ReflContainer cnt = new ReflContainer(cl, len);
            int i = 0;
            for (Datum o : ((LispVector)d).getList()) {
                cnt.set(i, LispJavaUtils.toJavaInstance(cc, o));
                ++i;
            }
            return cnt.toObject();
        }
        if (d instanceof JavaInstance) {
            return ((JavaInstance)d).getJavaInstance();
        }
        if (d instanceof JavaObjective) {
            return ((JavaObjective)((Object)d)).toObject();
        }
        if (d == JavaNull.JAVA_NULL) {
            return null;
        }
        if (d == Nil.NIL) {
            return new ReflContainer(cl, 0).toObject();
        }
        throw new ClassCastException(cl.getName());
    }

    static Object[] toJavaInstances(Class<?>[] cl, List<Datum> ld, boolean varargs) {
        Object rst;
        Object[] res = new Object[cl.length];
        if (!varargs && cl.length != ld.size()) {
            throw new ClassCastException();
        }
        if (varargs) {
            Class<?> lcl = cl[cl.length - 1];
            if (!lcl.isArray()) {
                throw new RuntimeException();
            }
            res[cl.length - 1] = rst = Array.newInstance(lcl.getComponentType(), ld.size() - cl.length + 1);
        } else {
            rst = null;
        }
        int i = 0;
        while (i < ld.size()) {
            Class<?> lcl = cl[cl.length - 1];
            Class<?> lcc = lcl.getComponentType();
            if (varargs && i >= cl.length - 1) {
                Array.set(rst, i - cl.length + 1, LispJavaUtils.toJavaInstance(lcc, ld.get(i)));
            } else if (LispJavaUtils.isSameClass(cl[i], ld.get(i))) {
                res[i] = LispJavaUtils.toJavaInstance(cl[i], ld.get(i));
            }
            ++i;
        }
        return res;
    }

    static Object[] toJavaInstances(Class<?>[] cl, boolean varargs, Datum ... ld) {
        Object rst;
        Object[] res = new Object[cl.length];
        if (!varargs && cl.length != ld.length) {
            throw new ClassCastException();
        }
        if (varargs) {
            Class<?> lcl = cl[cl.length - 1];
            if (!lcl.isArray()) {
                throw new RuntimeException();
            }
            res[cl.length - 1] = rst = Array.newInstance(lcl.getComponentType(), ld.length - cl.length + 1);
        } else {
            rst = null;
        }
        int i = 0;
        while (i < ld.length) {
            Class<?> lcl = cl[cl.length - 1];
            Class<?> lcc = lcl.getComponentType();
            if (varargs && i >= cl.length - 1) {
                Array.set(rst, i - cl.length + 1, LispJavaUtils.toJavaInstance(lcc, ld[i]));
            } else if (LispJavaUtils.isSameClass(cl[i], ld[i])) {
                res[i] = LispJavaUtils.toJavaInstance(cl[i], ld[i]);
            }
            ++i;
        }
        return res;
    }

    static Object newInstance(Class<?> klass, List<Datum> lst) throws ParameterNotFoundException {
        Constructor<?>[] cns = klass.getConstructors();
        int i = 0;
        while (i < cns.length) {
            boolean va;
            Class<?>[] cls = cns[i].getParameterTypes();
            if (LispJavaUtils.isSameClasses(cls, lst, va = cns[i].isVarArgs())) {
                Object[] args = LispJavaUtils.toJavaInstances(cls, lst, va);
                try {
                    return cns[i].newInstance(args);
                }
                catch (IllegalArgumentException e) {
                    throw new JavaException(e);
                }
                catch (InstantiationException e) {
                    throw new JavaException(e);
                }
                catch (IllegalAccessException e) {
                    throw new JavaException(e);
                }
                catch (InvocationTargetException e) {
                    throw new JavaTargetException(e.getCause());
                }
            }
            ++i;
        }
        throw new ParameterNotFoundException();
    }

    private static Class<?> applyRule1(Class<?> cl) {
        String n = cl.getName();
        String[] stringArray = JAVAPATH;
        int n2 = JAVAPATH.length;
        int n3 = 0;
        while (n3 < n2) {
            String p = stringArray[n3];
            try {
                return Class.forName(String.valueOf(p) + n.replaceFirst("^(.*)\\.J", ".Lisp"));
            }
            catch (ClassNotFoundException classNotFoundException) {
                ++n3;
            }
        }
        return null;
    }

    public static Datum newInstance(Object o) {
        Class<?> cl;
        Class<?> clazz = cl = o == null ? null : o.getClass();
        if (o == null || o == JavaNull.JAVA_NULL) {
            return Nil.NIL;
        }
        if (o instanceof Datum) {
            return (Datum)o;
        }
        if (o instanceof Integer) {
            return LispInteger.valueOf((Integer)o);
        }
        if (o instanceof Long) {
            return LispInteger.valueOf((Long)o);
        }
        if (o instanceof BigInteger) {
            return LispInteger.valueOf((BigInteger)o);
        }
        if (o instanceof BigDecimal) {
            return LispUtils.bigDecimalToRational((BigDecimal)o);
        }
        if (o instanceof Float) {
            return new LispDouble(((Float)o).doubleValue());
        }
        if (o instanceof Double) {
            return new LispDouble((Double)o);
        }
        if (o instanceof String) {
            return new LispString((String)o);
        }
        if (o instanceof Character) {
            return new LispCharacter(((Character)o).charValue());
        }
        if (o instanceof Boolean) {
            return LispBoolean.getInstance((Boolean)o);
        }
        if (cl.isArray()) {
            ConsListBuilder bld = new ConsListBuilder();
            int len = Array.getLength(o);
            int i = 0;
            while (i < len) {
                bld.append(LispJavaUtils.newInstance(Array.get(o, i)));
                ++i;
            }
            return bld.get();
        }
        Class<?> iv = LispJavaUtils.applyRule1(cl);
        if (iv != null) {
            try {
                return (Datum)iv.getConstructor(cl).newInstance(o);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
        }
        return new JavaInstance(o);
    }
}

