/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.math.BigInteger;
import java.util.NoSuchElementException;
import net.morilib.lisp.Datum;
import net.morilib.lisp.LispBigInt;
import net.morilib.lisp.LispExactReal;
import net.morilib.lisp.LispMessage;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.LispSmallInt;
import net.morilib.lisp.Nil;
import net.morilib.lisp.accessor.ILispRef;
import net.morilib.lisp.iterator.ILispIterator;
import net.morilib.lisp.math.LispOrdinalNumber;
import net.morilib.lisp.sos.LispType;
import net.morilib.lisp.subr.SubrUtils;
import net.morilib.util.Inclementor;

public abstract class LispInteger
extends LispExactReal
implements Inclementor<LispInteger>,
LispOrdinalNumber,
ILispIterator,
ILispRef {
    public static final LispInteger FIXNUM_MAX = LispInteger.valueOf(Integer.MAX_VALUE);
    public static final LispInteger FIXNUM_MIN = LispInteger.valueOf(Integer.MIN_VALUE);
    public static final long FIXNUM_MAX_LONG = Integer.MAX_VALUE;
    public static final long FIXNUM_MIN_LONG = Integer.MIN_VALUE;
    public static final long FIXNUM_MASK = 0xFFFFFFFFL;
    public static final int FIXNUM_WIDTH = 32;
    private static final BigInteger INT_MAX = BigInteger.valueOf(Integer.MAX_VALUE);
    private static final BigInteger INT_MIN = BigInteger.valueOf(Integer.MIN_VALUE);
    private static final int FWSIZE = 1000;
    public static final LispInteger ZERO = LispInteger.valueOf(0);
    public static final LispInteger ONE = LispInteger.valueOf(1);
    private static LispInteger[] flyweightp = new LispInteger[1000];
    private static LispInteger[] flyweightn = new LispInteger[1000];

    public static LispInteger valueOf(BigInteger val) {
        if (val.compareTo(INT_MAX) > 0 || val.compareTo(INT_MIN) < 0) {
            return new LispBigInt(val);
        }
        return LispInteger.valueOf(val.intValue());
    }

    public static LispInteger valueOf(int val) {
        if (flyweightp == null || flyweightn == null || val >= 1000 || val <= -1000) {
            return new LispSmallInt(val);
        }
        if (val > 0) {
            if (flyweightp[val] == null) {
                LispInteger.flyweightp[val] = new LispSmallInt(val);
            }
            return flyweightp[val];
        }
        if (val < 0) {
            if (flyweightn[-val] == null) {
                LispInteger.flyweightn[-val] = new LispSmallInt(val);
            }
            return flyweightn[-val];
        }
        return ZERO;
    }

    public static LispInteger valueOf(long val) {
        if (val > Integer.MAX_VALUE || val < Integer.MIN_VALUE) {
            return new LispBigInt(BigInteger.valueOf(val));
        }
        return LispInteger.valueOf((int)val);
    }

    @Override
    public abstract LispInteger uminus();

    @Override
    public LispInteger abs() {
        return this.signum() >= 0 ? this : this.negate();
    }

    @Override
    public LispInteger negate() {
        return this.uminus();
    }

    @Override
    public BigInteger getNumerator() {
        return this.getBigInteger();
    }

    @Override
    public BigInteger getDenominator() {
        return BigInteger.ONE;
    }

    @Override
    public boolean isInteger() {
        return true;
    }

    @Override
    public boolean isRational() {
        return true;
    }

    @Override
    public boolean isReal() {
        return true;
    }

    @Override
    public boolean isExact() {
        return true;
    }

    @Override
    public LispInteger getObject() {
        return this;
    }

    @Override
    public Inclementor<LispInteger> getZero() {
        return ZERO;
    }

    @Override
    public boolean hasNext() {
        return true;
    }

    @Override
    public LispReal floor() {
        return this;
    }

    @Override
    public LispReal ceil() {
        return this;
    }

    @Override
    public LispType getType() {
        return LispType.INTEGER;
    }

    @Override
    public Datum ref(Datum arg, LispMessage mesg) {
        LispInteger k = SubrUtils.getInteger(arg, mesg);
        LispInteger s = this.abs();
        if (k.signum() < 0 || k.compareTo(s) >= 0) {
            throw mesg.getError("err.accessor.ref.outofrange", k);
        }
        return Nil.NIL;
    }

    @Override
    public boolean isTerminated() {
        return this.signum() == 0;
    }

    @Override
    public ILispIterator next() {
        if (this.signum() > 0) {
            return (LispInteger)this.subtract(ONE);
        }
        if (this.signum() < 0) {
            return (LispInteger)this.add(ONE);
        }
        throw new NoSuchElementException();
    }

    @Override
    public Datum getCurrentDatum() {
        return this;
    }
}

