/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import net.morilib.lisp.LispComplex;
import net.morilib.lisp.LispDouble;
import net.morilib.lisp.LispInteger;
import net.morilib.lisp.LispNumber;
import net.morilib.lisp.LispReal;
import net.morilib.lisp.LispUtils;
import net.morilib.lisp.math.constants.LispPi;

public final class LispComplexPolar
extends LispComplex {
    private LispReal radius;
    private LispReal angle;

    LispComplexPolar(LispReal r, LispReal a) {
        this.radius = r;
        this.angle = a;
    }

    @Override
    public double getRealDouble() {
        return this.radius.getRealDouble() * Math.cos(this.angle.getRealDouble());
    }

    @Override
    public LispReal getReal() {
        return new LispDouble(this.getRealDouble());
    }

    @Override
    public double getImagDouble() {
        return this.radius.getRealDouble() * Math.sin(this.angle.getRealDouble());
    }

    @Override
    public LispReal getImag() {
        return new LispDouble(this.getImagDouble());
    }

    @Override
    public LispComplex toExact() {
        return new LispComplexPolar(this.radius.toExact(), this.angle.toExact());
    }

    @Override
    public LispComplex toInexact() {
        return new LispComplexPolar(this.radius.toInexact(), this.angle.toInexact());
    }

    @Override
    public LispComplex conjugate() {
        return new LispComplexPolar(this.radius, this.angle.uminus());
    }

    @Override
    public LispComplex uminus() {
        return new LispComplexPolar(this.getReal().uminus(), LispPi.PI.subtract(this.angle));
    }

    @Override
    public LispNumber add(LispNumber x) {
        if (!(x instanceof LispComplexPolar)) {
            return super.add(x);
        }
        LispComplexPolar p = (LispComplexPolar)x;
        if (p.angle.isEqualTo(this.angle)) {
            return LispComplexPolar.newPolar(this.radius.add(p.radius), this.angle);
        }
        if (this.angle.subtract(p.angle).abs().equals(LispPi.PI)) {
            return LispComplexPolar.newPolar(this.radius.subtract(p.radius), this.angle);
        }
        return super.add(x);
    }

    @Override
    public LispNumber sub(LispNumber x) {
        if (!(x instanceof LispComplexPolar)) {
            return super.add(x);
        }
        LispComplexPolar p = (LispComplexPolar)x;
        if (p.angle.isEqualTo(this.angle)) {
            return LispComplexPolar.newPolar(this.radius.subtract(p.radius), this.angle);
        }
        if (this.angle.subtract(p.angle).abs().equals(LispPi.PI)) {
            return LispComplexPolar.newPolar(this.radius.add(p.radius), this.angle);
        }
        return super.add(x);
    }

    @Override
    public LispNumber mul(LispNumber x) {
        if (!(x instanceof LispComplexPolar)) {
            return super.mul(x);
        }
        LispComplexPolar p = (LispComplexPolar)x;
        if (p.isNaN()) {
            return LispDouble.NaN;
        }
        if (p.radius.isZero()) {
            return this.isExact() && x.isExact() ? LispInteger.ZERO : LispDouble.ZERO;
        }
        return LispComplexPolar.newPolar(this.radius.multiply(p.radius), this.angle.add(p.angle));
    }

    @Override
    public LispNumber div(LispNumber x) {
        if (!(x instanceof LispComplexPolar)) {
            return super.mul(x);
        }
        LispComplexPolar p = (LispComplexPolar)x;
        if (p.isNaN()) {
            return LispDouble.NaN;
        }
        if (p.radius.isZero()) {
            return LispDouble.NaN;
        }
        return LispComplexPolar.newPolar(this.radius.divide(p.radius), this.angle.subtract(p.angle));
    }

    @Override
    public boolean isExact() {
        return this.radius.isExact() && this.angle.isExact();
    }

    @Override
    public LispReal norm() {
        return this.radius;
    }

    @Override
    public LispReal normSquared() {
        return this.radius.multiply(this.radius);
    }

    @Override
    public LispReal angle() {
        return this.angle;
    }

    @Override
    public boolean isFinite() {
        return this.radius.isFinite() && this.angle.isFinite();
    }

    public boolean equals(Object x) {
        if (x instanceof LispComplexPolar) {
            LispComplexPolar c = (LispComplexPolar)x;
            return this.radius.equals(c.radius) && this.angle.equals(c.angle);
        }
        return false;
    }

    public int hashCode() {
        int l = 17;
        l = 37 * (l + this.radius.hashCode());
        l = 37 * (l + this.angle.hashCode());
        return l;
    }

    @Override
    public String getResult() {
        return String.valueOf(LispUtils.getResult(this.radius)) + "@" + LispUtils.getResult(this.angle);
    }

    @Override
    public String print() {
        return this.getResult();
    }

    @Override
    public String toString() {
        return this.getResult();
    }
}

