/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.math.BigInteger;
import net.morilib.lisp.Atom;
import net.morilib.lisp.JavaObjective;
import net.morilib.lisp.LispString;
import net.morilib.lisp.sos.LispType;
import net.morilib.util.Inclementor;
import net.morilib.util.InclementorBoundsException;

public final class LispCharacter
extends Atom
implements Comparable<LispCharacter>,
Inclementor<LispCharacter>,
JavaObjective {
    public static final LispCharacter NEWLINE = new LispCharacter(10);
    public static final LispCharacter SPACE = new LispCharacter(32);
    public static final LispCharacter NUL = new LispCharacter(0);
    public static final LispCharacter ALERM = new LispCharacter(7);
    public static final LispCharacter BACKSPACE = new LispCharacter(8);
    public static final LispCharacter TAB = new LispCharacter(9);
    public static final LispCharacter LINEFEED = new LispCharacter(10);
    public static final LispCharacter VTAB = new LispCharacter(11);
    public static final LispCharacter PAGE = new LispCharacter(12);
    public static final LispCharacter RETURN = new LispCharacter(13);
    public static final LispCharacter ESC = new LispCharacter(27);
    public static final LispCharacter DELETE = new LispCharacter(127);
    private int character;

    public LispCharacter(int ch) {
        if (ch < 0) {
            throw new IllegalArgumentException();
        }
        this.character = ch;
    }

    private static String getName(int ch) {
        if (ch == 10) {
            return "newline";
        }
        if (ch == 32) {
            return "space";
        }
        if (ch == 0) {
            return "nul";
        }
        if (ch == 7) {
            return "alarm";
        }
        if (ch == 8) {
            return "backspace";
        }
        if (ch == 9) {
            return "tab";
        }
        if (ch == 11) {
            return "vtab";
        }
        if (ch == 12) {
            return "page";
        }
        if (ch == 13) {
            return "return";
        }
        if (ch == 27) {
            return "esc";
        }
        if (ch == 127) {
            return "delete";
        }
        if (ch > 65535) {
            return "?";
        }
        return Character.toString((char)ch);
    }

    public static LispCharacter getByName(String name) {
        if ("newline".equals(name)) {
            return NEWLINE;
        }
        if ("space".equals(name)) {
            return SPACE;
        }
        if ("nul".equals(name)) {
            return NUL;
        }
        if ("alarm".equals(name)) {
            return ALERM;
        }
        if ("backspace".equals(name)) {
            return BACKSPACE;
        }
        if ("tab".equals(name)) {
            return TAB;
        }
        if ("linefeed".equals(name)) {
            return LINEFEED;
        }
        if ("vtab".equals(name)) {
            return VTAB;
        }
        if ("page".equals(name)) {
            return PAGE;
        }
        if ("return".equals(name)) {
            return RETURN;
        }
        if ("esc".equals(name)) {
            return ESC;
        }
        if ("delete".equals(name)) {
            return DELETE;
        }
        return null;
    }

    public static LispCharacter valueOf(int ch) {
        return new LispCharacter(ch);
    }

    @Override
    public char getCharacter() {
        return (char)this.character;
    }

    @Override
    public int getCharacterCodePoint() {
        return this.character;
    }

    @Override
    public String getResult() {
        return "#\\" + LispCharacter.getName(this.character);
    }

    @Override
    public String print() {
        if (this.character > 65535) {
            return "?";
        }
        return Character.toString((char)this.character);
    }

    @Override
    public LispString toLispString() {
        return new LispString("#\\" + LispCharacter.getName(this.character));
    }

    @Override
    public boolean isTypeCharacter() {
        return true;
    }

    @Override
    public int compareTo(LispCharacter o) {
        return this.character < o.character ? -1 : (this.character > o.character ? 1 : 0);
    }

    @Override
    public boolean equalIncliment(Inclementor<?> i) {
        if (i instanceof LispCharacter) {
            return this.character == ((LispCharacter)i).character;
        }
        return this.character == i.toInt();
    }

    @Override
    public boolean equalInt(int i) {
        return this.character == i;
    }

    @Override
    public LispCharacter getObject() {
        return this;
    }

    @Override
    public boolean isZero() {
        return this.character == 0;
    }

    @Override
    public Inclementor<LispCharacter> suc() {
        if (this.character >= 65535) {
            throw new InclementorBoundsException();
        }
        return new LispCharacter((char)(this.character + 1));
    }

    @Override
    public Inclementor<LispCharacter> suc(int step) {
        if (this.character + step >= 65535) {
            throw new InclementorBoundsException();
        }
        return new LispCharacter((char)(this.character + 1));
    }

    @Override
    public int toInt() {
        return this.character;
    }

    @Override
    public boolean hasNext() {
        return this.character < 65535;
    }

    @Override
    public Inclementor<LispCharacter> getZero() {
        return new LispCharacter(0);
    }

    @Override
    public boolean equalInt(BigInteger i) {
        return i.equals(BigInteger.valueOf(this.character));
    }

    @Override
    public LispType getType() {
        return LispType.CHAR;
    }

    @Override
    public Object toObject() {
        if (this.character > 65535) {
            return this.character;
        }
        return new Character((char)this.character);
    }

    public boolean equals(Object d) {
        if (d instanceof LispCharacter) {
            return this.character == ((LispCharacter)d).character;
        }
        return false;
    }

    public int hashCode() {
        int l = 17;
        l = 37 * l + this.character;
        return l;
    }

    @Override
    public String toString() {
        if (this.character > 65535) {
            return "?";
        }
        return Character.toString((char)this.character);
    }
}

