/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.io.Serializable;
import net.morilib.lisp.Atom;
import net.morilib.lisp.Datum;
import net.morilib.lisp.JavaObjective;
import net.morilib.lisp.LispString;
import net.morilib.lisp.math.ILispSquareIdempotence;
import net.morilib.lisp.math.algebra.ILispAddable;
import net.morilib.lisp.math.algebra.ILispMultipliable;
import net.morilib.lisp.sos.LispType;
import net.morilib.lisp.topology.ILispTopology;
import net.morilib.lisp.topology.LispCardinality;

public final class LispBoolean
extends Atom
implements JavaObjective,
ILispAddable<LispBoolean>,
ILispMultipliable<LispBoolean>,
ILispTopology,
ILispSquareIdempotence,
Serializable {
    private static final long serialVersionUID = 1583375250021807431L;
    private boolean value;
    public static final LispBoolean TRUE = new LispBoolean(true);
    public static final LispBoolean FALSE = new LispBoolean(false);

    public static LispBoolean getInstance(boolean value) {
        return value ? TRUE : FALSE;
    }

    private LispBoolean(boolean value) {
        this.value = value;
    }

    public boolean isEqv(Atom a) {
        return this.equals(a);
    }

    public boolean getValue() {
        return this.value;
    }

    @Override
    public String print() {
        return this.value ? "#t" : "#f";
    }

    @Override
    public String getResult() {
        return this.value ? "#t" : "#f";
    }

    @Override
    public LispString toLispString() {
        return new LispString(this.value ? "#t" : "#f");
    }

    @Override
    public boolean isTypeBoolean() {
        return true;
    }

    @Override
    public boolean isTrue() {
        return this.value;
    }

    @Override
    public LispType getType() {
        return LispType.BOOLEAN;
    }

    @Override
    public Object toObject() {
        return this.value;
    }

    @Override
    public LispBoolean mul(LispBoolean y) {
        return LispBoolean.getInstance(this.value && y.value);
    }

    @Override
    public LispBoolean add(LispBoolean y) {
        return LispBoolean.getInstance(this.value || y.value);
    }

    @Override
    public boolean isNeighborhoodOf(Datum d) {
        return this.value;
    }

    @Override
    public boolean isContained(ILispTopology t) {
        return !this.value;
    }

    @Override
    public boolean isIndependent(ILispTopology t) {
        return !this.value;
    }

    @Override
    public boolean isNotContained(ILispTopology t) {
        return this.value;
    }

    @Override
    public boolean isNotIndependent(ILispTopology t) {
        return this.value;
    }

    @Override
    public ILispTopology unionTopology(ILispTopology t) {
        return this.value ? this : t;
    }

    @Override
    public ILispTopology intersectionTopology(ILispTopology t) {
        return this.value ? t : this;
    }

    @Override
    public ILispTopology interior() {
        return this;
    }

    @Override
    public ILispTopology closure() {
        return this;
    }

    @Override
    public boolean isOpen() {
        return true;
    }

    @Override
    public boolean isClosed() {
        return true;
    }

    @Override
    public LispCardinality cardinality() {
        return this.value ? LispCardinality.OVER_C : LispCardinality.ZERO;
    }

    @Override
    public boolean isEmpty() {
        return !this.value;
    }

    @Override
    public boolean isUniverse() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (o instanceof LispBoolean) {
            return this.value == ((LispBoolean)o).value;
        }
        return false;
    }

    public int hashCode() {
        return this.value ? 1 : 0;
    }

    @Override
    public String toString() {
        return this.value ? "#t" : "#f";
    }
}

