/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lisp;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.morilib.lisp.Closure;
import net.morilib.lisp.ClosureClass;
import net.morilib.lisp.Datum;
import net.morilib.lisp.LispSmallInt;
import net.morilib.lisp.Symbol;
import net.morilib.lisp.SymbolName;
import net.morilib.lisp.UserSyntax;
import net.morilib.lisp.r6rs.LibraryID;

class CompiledCode {
    static final Code CALL_CD = new Code(Oper.CALL);
    private List<Code> opers = new ArrayList<Code>();
    private List<Integer> labels = new ArrayList<Integer>();

    CompiledCode() {
    }

    Code getCode(int addr) {
        return addr < this.opers.size() ? this.opers.get(addr) : null;
    }

    int getAddress(int label) {
        return this.labels.get(label);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        int i = 0;
        while (i < this.opers.size()) {
            Code c = this.opers.get(i);
            if (c.datum instanceof ClosureClass) {
                buf.append("----------------------------\n");
                buf.append(((ClosureClass)c.datum).getCode());
                buf.append("----------------------------\n");
            } else if (c.datum instanceof Closure) {
                buf.append("----------------------------\n");
                buf.append(((Closure)c.datum).getCode());
                buf.append("----------------------------\n");
            }
            buf.append(c.toString());
            buf.append("\n");
            ++i;
        }
        return buf.toString();
    }

    static class Builder {
        private CompiledCode codes = new CompiledCode();

        Builder() {
        }

        void addPush(Datum d) {
            Code c = new Code(Oper.PUSH);
            c.datum = d;
            this.codes.opers.add(c);
        }

        void addPop() {
            this.codes.opers.add(new Code(Oper.POP));
        }

        void addBeginList() {
            this.codes.opers.add(new Code(Oper.BEGIN_LIST));
        }

        void addAppendList() {
            this.codes.opers.add(new Code(Oper.APPEND_LIST));
        }

        void addAppendListSplicing() {
            this.codes.opers.add(new Code(Oper.APPEND_LIST_SPLICING));
        }

        void addAppendListMultiValues() {
            this.codes.opers.add(new Code(Oper.APPEND_LIST_MULTI_VALUES));
        }

        void addEndListDot() {
            this.codes.opers.add(new Code(Oper.END_LIST_DOT));
        }

        void addEndList() {
            this.codes.opers.add(new Code(Oper.END_LIST));
        }

        void addEndListVector() {
            this.codes.opers.add(new Code(Oper.END_LIST_VECTOR));
        }

        void addCall() {
            this.codes.opers.add(new Code(Oper.CALL));
        }

        void addCallWind() {
            this.codes.opers.add(new Code(Oper.CALL_WIND));
        }

        void addCallMethod() {
            this.codes.opers.add(new Code(Oper.CALL_METHOD));
        }

        void addCallTail(int rewind) {
            Code c = new Code(Oper.CALL_TAIL);
            c.rewind = rewind;
            this.codes.opers.add(c);
        }

        void addJmp(int jmpLabel) {
            Code c = new Code(Oper.JMP);
            c.jmpLabel = jmpLabel;
            this.codes.opers.add(c);
        }

        void addJmpIf(int jmpLabel) {
            Code c = new Code(Oper.JMP_IF);
            c.jmpLabel = jmpLabel;
            this.codes.opers.add(c);
        }

        void addJmpUnless(int jmpLabel) {
            Code c = new Code(Oper.JMP_UNLESS);
            c.jmpLabel = jmpLabel;
            this.codes.opers.add(c);
        }

        void addJmpTop() {
            this.codes.opers.add(new Code(Oper.JMP_TOP));
        }

        void addReferSymbol(Datum destSymbol) {
            Code c = new Code(Oper.REFER_SYMBOL);
            c.datum = destSymbol;
            this.codes.opers.add(c);
        }

        void addReferSetter(Datum destSymbol) {
            Code c = new Code(Oper.REFER_SETTER);
            c.datum = destSymbol;
            this.codes.opers.add(c);
        }

        void addDefined(Datum destSymbol) {
            Code c = new Code(Oper.REFER_DEFINED);
            c.datum = destSymbol;
            this.codes.opers.add(c);
        }

        void addBind(Datum destSymbol) {
            Code c = new Code(Oper.BIND);
            c.datum = destSymbol;
            this.codes.opers.add(c);
        }

        void addBindMacro(Datum destSymbol) {
            Code c = new Code(Oper.BIND_MACRO);
            c.datum = destSymbol;
            this.codes.opers.add(c);
        }

        void addBindMacro72(Datum destSymbol) {
            Code c = new Code(Oper.BIND_MACRO72);
            c.datum = destSymbol;
            this.codes.opers.add(c);
        }

        void addBindMacroQuote(Datum destSymbol) {
            Code c = new Code(Oper.BIND_MACRO_QUOTE);
            c.datum = destSymbol;
            this.codes.opers.add(c);
        }

        void addSet(Datum destSymbol) {
            Code c = new Code(Oper.SET);
            c.datum = destSymbol;
            this.codes.opers.add(c);
        }

        void addReturnOp() {
            this.codes.opers.add(new Code(Oper.RETURN_OP));
        }

        void addPushContinuation() {
            Code c = new Code(Oper.PUSH_CONTINUATION);
            this.codes.opers.add(c);
        }

        void addPushUsyn(UserSyntax usyn) {
            Code c = new Code(Oper.PUSH_USYN);
            c.usyn = usyn;
            this.codes.opers.add(c);
        }

        void addPopUsyn() {
            this.codes.opers.add(new Code(Oper.POP_USYN));
        }

        void addForce() {
            this.codes.opers.add(new Code(Oper.FORCE));
        }

        void addNewPromise(Datum p) {
            Code c = new Code(Oper.NEW_PROMISE);
            c.datum = p;
            this.codes.opers.add(c);
        }

        void addAppendValues() {
            this.codes.opers.add(new Code(Oper.APPEND_VALUES));
        }

        void addEvalCode() {
            this.codes.opers.add(new Code(Oper.EVAL_CODE));
        }

        void addLoadCode() {
            this.codes.opers.add(new Code(Oper.LOAD_CODE));
        }

        void addOverrideLoadCode() {
            this.codes.opers.add(new Code(Oper.OVERRIDE_LOAD_CODE));
        }

        void addExpandMacro() {
            this.codes.opers.add(new Code(Oper.EXPAND_MACRO));
        }

        void addExpandMacro1() {
            this.codes.opers.add(new Code(Oper.EXPAND_MACRO1));
        }

        void addExpandMacro72() {
            this.codes.opers.add(new Code(Oper.EXPAND_MACRO72));
        }

        void addFindList() {
            this.codes.opers.add(new Code(Oper.FIND_LIST));
        }

        void addBindMethod(Datum destSymbol) {
            Code c = new Code(Oper.BIND_METHOD);
            c.datum = destSymbol;
            this.codes.opers.add(c);
        }

        void addSetLibID(LibraryID libid, Map<Symbol, Symbol> mp) {
            Code c = new Code(Oper.SET_LIBID);
            c.libid = libid;
            c.export = mp;
            this.codes.opers.add(c);
        }

        void addImportLib(Datum mp) {
            Code c = new Code(Oper.IMPORT_LIB);
            c.datum = mp;
            this.codes.opers.add(c);
        }

        void addJavaCall(SymbolName method, Datum callable) {
            Code c = new Code(Oper.JAVA_CALL);
            c.datum = callable;
            c.method = method;
            this.codes.opers.add(c);
        }

        void addExpandSyntaxRule(UserSyntax syn) {
            Code c = new Code(Oper.EXPAND_SYNTAX_RULE);
            c.syntax = syn;
            this.codes.opers.add(c);
        }

        void addReplaceParam() {
            this.codes.opers.add(new Code(Oper.REPLACE_PARAM));
        }

        void addJavaGet(SymbolName accessor, Datum instance, LispSmallInt ind) {
            Code c = new Code(Oper.JAVA_GET);
            c.datum = instance;
            c.method = accessor;
            c.beanIndex = ind;
            this.codes.opers.add(c);
        }

        void addJavaSet(SymbolName accessor, Datum instance, LispSmallInt ind) {
            Code c = new Code(Oper.JAVA_SET);
            c.datum = instance;
            c.method = accessor;
            c.beanIndex = ind;
            this.codes.opers.add(c);
        }

        void addJavaFieldGet(SymbolName accessor, Datum instance) {
            Code c = new Code(Oper.JAVA_FIELD_GET);
            c.datum = instance;
            c.method = accessor;
            this.codes.opers.add(c);
        }

        void addJavaFieldSet(SymbolName accessor, Datum instance) {
            Code c = new Code(Oper.JAVA_FIELD_SET);
            c.datum = instance;
            c.method = accessor;
            this.codes.opers.add(c);
        }

        void addJavaInstanceof(SymbolName name) {
            Code c = new Code(Oper.JAVA_INSTANCEOF);
            c.method = name;
            this.codes.opers.add(c);
        }

        void addJavaRaise() {
            this.codes.opers.add(new Code(Oper.JAVA_RAISE));
        }

        void addJavaEnterExceptionHandler(Datum callee, int endjmp) {
            Code c = new Code(Oper.JAVA_ENTER_EXCEPTION_HANDLER);
            c.datum = callee;
            c.jmpLabel = endjmp;
            this.codes.opers.add(c);
        }

        void addJavaLeaveExceptionHandler() {
            this.codes.opers.add(new Code(Oper.JAVA_LEAVE_EXCEPTION_HANDLER));
        }

        void addRewindEnv(int r) {
            Code c = new Code(Oper.REWIND_ENV);
            c.rewind = r;
            this.codes.opers.add(c);
        }

        void addRewindCont(int r) {
            Code c = new Code(Oper.REWIND_CONT);
            c.rewind = r;
            this.codes.opers.add(c);
        }

        void addEnterExceptionHandler(int endjmp) {
            Code c = new Code(Oper.ENTER_EXCEPTION_HANDLER);
            c.jmpLabel = endjmp;
            this.codes.opers.add(c);
        }

        void addLeaveExceptionHandler() {
            this.codes.opers.add(new Code(Oper.LEAVE_EXCEPTION_HANDLER));
        }

        void addGetCurrentExceptionHandler() {
            this.codes.opers.add(new Code(Oper.GET_CURRENT_EXCEPTION_HANDLER));
        }

        void addParameterize() {
            this.codes.opers.add(new Code(Oper.PARAMETERIZE));
        }

        void addDeparameterize() {
            this.codes.opers.add(new Code(Oper.DEPARAMETERIZE));
        }

        void addInitially(CompiledCode codes) {
            Code c = new Code(Oper.INITIALLY);
            c.codes = codes;
            this.codes.opers.add(c);
        }

        void addFinally(CompiledCode codes) {
            Code c = new Code(Oper.FINALLY);
            c.codes = codes;
            this.codes.opers.add(c);
        }

        int getCurrentAddress() {
            return this.codes.opers.size();
        }

        void setCurrentAddressToLabel(int label) {
            this.codes.labels.set(label, this.getCurrentAddress());
        }

        int allocLabel() {
            int res = this.codes.labels.size();
            this.codes.labels.add(-1);
            return res;
        }

        CompiledCode getCodeRef() {
            return this.codes;
        }

        void merge(CompiledCode cc) {
            this.codes.opers.addAll(cc.opers);
            this.codes.labels.addAll(cc.labels);
        }
    }

    static class Code {
        private Oper op;
        private Datum datum;
        private int jmpLabel;
        private UserSyntax usyn;
        private SymbolName method;
        private LispSmallInt beanIndex;
        private int rewind;
        private LibraryID libid;
        private Map<Symbol, Symbol> export;
        private UserSyntax syntax;
        private int depth;
        private CompiledCode codes;

        private Code(Oper op) {
            this.op = op;
        }

        Oper getOp() {
            return this.op;
        }

        Datum getDatum() {
            return this.datum;
        }

        int getJmpLabel() {
            return this.jmpLabel;
        }

        UserSyntax getUsyn() {
            return this.usyn;
        }

        SymbolName getMethod() {
            return this.method;
        }

        LispSmallInt getBeanIndex() {
            return this.beanIndex;
        }

        int getRewind() {
            return this.rewind;
        }

        LibraryID getLibID() {
            return this.libid;
        }

        Map<Symbol, Symbol> getExport() {
            return this.export;
        }

        UserSyntax getSyntax() {
            return this.syntax;
        }

        int getDepth() {
            return this.depth;
        }

        CompiledCode getCodes() {
            return this.codes;
        }

        public String toString() {
            return (Object)((Object)this.op) + ":" + this.datum + ":" + this.jmpLabel;
        }
    }

    static enum Oper {
        PUSH,
        POP,
        BEGIN_LIST,
        APPEND_LIST,
        APPEND_LIST_SPLICING,
        APPEND_LIST_MULTI_VALUES,
        END_LIST_DOT,
        END_LIST,
        END_LIST_VECTOR,
        CALL,
        CALL_WIND,
        CALL_METHOD,
        CALL_TAIL,
        JMP,
        JMP_IF,
        JMP_UNLESS,
        JMP_TOP,
        REFER_SYMBOL,
        REFER_SETTER,
        REFER_DEFINED,
        BIND,
        BIND_MACRO,
        BIND_MACRO72,
        BIND_MACRO_QUOTE,
        SET,
        RETURN_OP,
        PUSH_CONTINUATION,
        PUSH_USYN,
        POP_USYN,
        FORCE,
        NEW_PROMISE,
        APPEND_VALUES,
        EVAL_CODE,
        LOAD_CODE,
        OVERRIDE_LOAD_CODE,
        EXPAND_MACRO,
        EXPAND_MACRO1,
        EXPAND_MACRO72,
        FIND_LIST,
        BIND_METHOD,
        SET_LIBID,
        IMPORT_LIB,
        EXPAND_SYNTAX_RULE,
        REPLACE_PARAM,
        JAVA_CALL,
        JAVA_GET,
        JAVA_SET,
        JAVA_FIELD_GET,
        JAVA_FIELD_SET,
        JAVA_INSTANCEOF,
        JAVA_RAISE,
        JAVA_ENTER_EXCEPTION_HANDLER,
        JAVA_LEAVE_EXCEPTION_HANDLER,
        REWIND_ENV,
        REWIND_CONT,
        ENTER_EXCEPTION_HANDLER,
        LEAVE_EXCEPTION_HANDLER,
        GET_CURRENT_EXCEPTION_HANDLER,
        PARAMETERIZE,
        DEPARAMETERIZE,
        INITIALLY,
        FINALLY;

    }
}

