/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lingua.numeral;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class KanjiNumeral {
    private static final String PTN_KANS = "([0-9]*)(([0-9]{1,4})\u7121\u91cf\u5927\u6570)?(([0-9]{1,4})\u4e0d\u53ef\u601d\u8b70)?(([0-9]{1,4})\u90a3\u7531\u4ed6)?(([0-9]{1,4})\u963f\u50e7\u7947)?(([0-9]{1,4})\u6052\u6cb3\u6c99)?(([0-9]{1,4})\u6975)?(([0-9]{1,4})\u8f09)?(([0-9]{1,4})\u6b63)?(([0-9]{1,4})\u6f97)?(([0-9]{1,4})\u6e9d)?(([0-9]{1,4})\u7a63)?(([0-9]{1,4})[\u30b7\u79ed])?(([0-9]{1,4})\u5793)?(([0-9]{1,4})\u4eac)?(([0-9]{1,4})\u5146)?(([0-9]{1,4})\u5104)?(([0-9]{1,4})\u4e07)?([0-9]{1,4})?";
    private static final Pattern PTN_KAN = Pattern.compile("([0-9]*)(([0-9]{1,4})\u7121\u91cf\u5927\u6570)?(([0-9]{1,4})\u4e0d\u53ef\u601d\u8b70)?(([0-9]{1,4})\u90a3\u7531\u4ed6)?(([0-9]{1,4})\u963f\u50e7\u7947)?(([0-9]{1,4})\u6052\u6cb3\u6c99)?(([0-9]{1,4})\u6975)?(([0-9]{1,4})\u8f09)?(([0-9]{1,4})\u6b63)?(([0-9]{1,4})\u6f97)?(([0-9]{1,4})\u6e9d)?(([0-9]{1,4})\u7a63)?(([0-9]{1,4})[\u30b7\u79ed])?(([0-9]{1,4})\u5793)?(([0-9]{1,4})\u4eac)?(([0-9]{1,4})\u5146)?(([0-9]{1,4})\u5104)?(([0-9]{1,4})\u4e07)?([0-9]{1,4})?");
    private static final int MAX_KETA = 71;
    private static String[] SU = new String[]{"\u7121\u91cf\u5927\u6570", "\u4e0d\u53ef\u601d\u8b70", "\u90a3\u7531\u4ed6", "\u963f\u50e7\u7947", "\u6052\u6cb3\u6c99", "\u6975", "\u8f09", "\u6b63", "\u6f97", "\u6e9d", "\u7a63", "\u79ed", "\u5793", "\u4eac", "\u5146", "\u5104", "\u4e07", ""};
    private static final BigInteger ICHIMAN = BigInteger.valueOf(10000L);

    private KanjiNumeral() {
    }

    private static void copystr(String s, char[] cs, int off) {
        if (s != null) {
            System.arraycopy(s.toCharArray(), 0, cs, 71 - off - s.length(), s.length());
        }
    }

    public static BigInteger parseNumeralGroupedBy10000(String s) {
        char[] cs = new char[71];
        if (s == null) {
            throw new NullPointerException();
        }
        if (s.equals("")) {
            throw new NumberFormatException(s);
        }
        Matcher mt = PTN_KAN.matcher(s);
        if (!mt.matches()) {
            throw new NumberFormatException(s);
        }
        Arrays.fill(cs, '0');
        KanjiNumeral.copystr(mt.group(3), cs, 68);
        KanjiNumeral.copystr(mt.group(5), cs, 64);
        KanjiNumeral.copystr(mt.group(7), cs, 60);
        KanjiNumeral.copystr(mt.group(9), cs, 56);
        KanjiNumeral.copystr(mt.group(11), cs, 52);
        KanjiNumeral.copystr(mt.group(13), cs, 48);
        KanjiNumeral.copystr(mt.group(15), cs, 44);
        KanjiNumeral.copystr(mt.group(17), cs, 40);
        KanjiNumeral.copystr(mt.group(19), cs, 36);
        KanjiNumeral.copystr(mt.group(21), cs, 32);
        KanjiNumeral.copystr(mt.group(23), cs, 28);
        KanjiNumeral.copystr(mt.group(25), cs, 24);
        KanjiNumeral.copystr(mt.group(27), cs, 20);
        KanjiNumeral.copystr(mt.group(29), cs, 16);
        KanjiNumeral.copystr(mt.group(31), cs, 12);
        KanjiNumeral.copystr(mt.group(33), cs, 8);
        KanjiNumeral.copystr(mt.group(35), cs, 4);
        KanjiNumeral.copystr(mt.group(36), cs, 0);
        String ss = new String(cs);
        ss = ss.replaceFirst("^0+", "");
        return new BigInteger(String.valueOf(mt.group(1)) + ss);
    }

    public static String groupBy10000(BigInteger b, boolean zeroSuppress) {
        int i = SU.length - 1;
        String r = "";
        String sgn = "";
        if (b.signum() == 0) {
            return "0";
        }
        if (b.signum() < 0) {
            sgn = "-";
        }
        BigInteger[] d = new BigInteger[]{b.abs()};
        while (d[0].signum() > 0 && i > 0) {
            if ((d = d[0].divideAndRemainder(ICHIMAN))[1].signum() > 0) {
                String d0;
                if (zeroSuppress) {
                    d0 = "0000" + d[1];
                    d0 = d0.substring(d0.length() - 4, d0.length());
                } else {
                    d0 = d[1].toString();
                }
                r = String.valueOf(d0) + SU[i] + r;
            }
            --i;
        }
        return String.valueOf(sgn) + (i > 0 ? "" : d[0] + SU[i]) + r;
    }

    public static String groupBy10000(BigInteger b) {
        return KanjiNumeral.groupBy10000(b, false);
    }
}

