/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lingua.numeral;

import java.math.BigInteger;

public class GermanNumeral {
    private static final String[] NUMERAL1;
    private static final String[] NUMERAL20;
    private static final String[] NUMERAL10;
    private static final String[] NUMERAL1000;
    static final BigInteger TAUSEND;

    static {
        String[] stringArray = new String[10];
        stringArray[1] = "ein";
        stringArray[2] = "zwei";
        stringArray[3] = "drei";
        stringArray[4] = "vier";
        stringArray[5] = "f\u00fcnf";
        stringArray[6] = "sechs";
        stringArray[7] = "sieben";
        stringArray[8] = "acht";
        stringArray[9] = "neun";
        NUMERAL1 = stringArray;
        NUMERAL20 = new String[]{"zehn", "elf", "zw\u00f6lf", "dreizehn", "vierzehn", "f\u00fcnfzehn", "sechzehn", "siebzehn", "achtzehn", "neunzehn"};
        String[] stringArray2 = new String[10];
        stringArray2[1] = "zehn";
        stringArray2[2] = "zwanzig";
        stringArray2[3] = "drei\u00dfig";
        stringArray2[4] = "vierzig";
        stringArray2[5] = "f\u00fcnfzig";
        stringArray2[6] = "sechzig";
        stringArray2[7] = "siebzig";
        stringArray2[8] = "achtzig";
        stringArray2[9] = "neunzig";
        NUMERAL10 = stringArray2;
        NUMERAL1000 = new String[]{"", "tausend", "Million", "Milliarde", "Billion", "Billiarde", "Trillion", "Trilliarde", "Quadrillion", "Quadrilliarde"};
        TAUSEND = BigInteger.valueOf(1000L);
    }

    static int toDigit(char c) {
        if (c < '0' || c > '9') {
            throw new NumberFormatException();
        }
        return c - 48;
    }

    static boolean describeBelowThousand(StringBuilder buf, String s, int b) {
        int c1 = GermanNumeral.toDigit(s.charAt(b));
        int c2 = GermanNumeral.toDigit(s.charAt(b + 1));
        int c3 = GermanNumeral.toDigit(s.charAt(b + 2));
        if (c1 == 0 && c2 == 0 && c3 == 0) {
            return false;
        }
        if (c1 > 0) {
            if (c1 > 1) {
                buf.append(NUMERAL1[c1]);
            }
            buf.append("hundert");
        }
        if (c2 >= 2) {
            buf.append(NUMERAL1[c3]);
            if (c3 > 0) {
                buf.append("und").append(NUMERAL10[c2]);
            }
        } else if (c2 == 1) {
            buf.append(NUMERAL20[c3]);
        } else if (c3 > 0) {
            buf.append(NUMERAL1[c3]);
        }
        return true;
    }

    public static String describeNumber(BigInteger n) {
        StringBuilder buf = new StringBuilder();
        if (n.signum() < 0) {
            return null;
        }
        if (n.signum() == 0) {
            return "null";
        }
        if (n.equals(BigInteger.ONE)) {
            return "eins";
        }
        String s0 = n.toString();
        switch (s0.length() % 3) {
            case 1: {
                s0 = "00" + s0;
                break;
            }
            case 2: {
                s0 = "0" + s0;
            }
        }
        int i = 0;
        while (i < s0.length()) {
            int l = (s0.length() - i) / 3 - 1;
            if (l >= NUMERAL1000.length) {
                return null;
            }
            if (l > 0 && s0.charAt(i) == '0' && s0.charAt(i + 1) == '0' && s0.charAt(i + 2) == '1') {
                if (l == 1) {
                    buf.append("tausend");
                } else {
                    buf.append("eine ").append(NUMERAL1000[l]);
                }
            } else {
                if (l > 0 && buf.length() > 0) {
                    buf.append(" ");
                }
                if (GermanNumeral.describeBelowThousand(buf, s0, i)) {
                    if (l > 1) {
                        buf.append(" ");
                        buf.append(NUMERAL1000[l]).append("en");
                    } else {
                        buf.append(NUMERAL1000[l]);
                    }
                }
            }
            i += 3;
        }
        return buf.toString();
    }

    public static String describeNumber(long n) {
        return GermanNumeral.describeNumber(BigInteger.valueOf(n));
    }

    private static boolean match(String s, String d, int p) {
        if (s.length() - p < d.length()) {
            return false;
        }
        int i = 0;
        while (i < d.length()) {
            if (s.charAt(i + p) != d.charAt(i)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static BigInteger matchMillion(String s) {
        BigInteger r = BigInteger.ONE;
        int i = 2;
        while (i < NUMERAL1000.length) {
            if (s.equals(NUMERAL1000[i])) {
                int j = 0;
                while (j < i) {
                    r = r.multiply(TAUSEND);
                    ++j;
                }
                return r;
            }
            ++i;
        }
        return null;
    }

    private static BigInteger matchMillionPlural(String s) {
        BigInteger r = BigInteger.ONE;
        int i = 2;
        while (i < NUMERAL1000.length) {
            String t = NUMERAL1000[i];
            if ((i & 1) == 0 && s.equals(String.valueOf(t) + "en") || (i & 1) != 0 && s.equals(String.valueOf(t) + "n")) {
                int j = 0;
                while (j < i) {
                    r = r.multiply(TAUSEND);
                    ++j;
                }
                return r;
            }
            ++i;
        }
        return null;
    }

    private static boolean isEnd(String s, int p) {
        return p + 1 >= s.length() || Character.isWhitespace(s.charAt(p + 1));
    }

    static int parse99(String s, int[] p) {
        int r = 0;
        int i = 0;
        while (i < 10) {
            if (GermanNumeral.match(s, NUMERAL20[i], p[0])) {
                p[0] = p[0] + NUMERAL20[i].length();
                return i + 10;
            }
            ++i;
        }
        i = 1;
        while (i < 10) {
            if (GermanNumeral.match(s, NUMERAL1[i], p[0])) {
                r = i;
                p[0] = p[0] + NUMERAL1[i].length();
                if (p[0] >= s.length()) {
                    return r;
                }
                if (!GermanNumeral.match(s, "und", p[0])) {
                    throw new NumberFormatException();
                }
                p[0] = p[0] + 3;
                break;
            }
            ++i;
        }
        i = 2;
        while (i < 10) {
            if (GermanNumeral.match(s, NUMERAL10[i], p[0])) {
                p[0] = p[0] + NUMERAL10[i].length();
                return r + i * 10;
            }
            ++i;
        }
        throw new NumberFormatException();
    }

    static int parse999(String s, int[] p) {
        int r = 0;
        if (GermanNumeral.match(s, "hundert", p[0])) {
            p[0] = p[0] + 7;
            if (GermanNumeral.isEnd(s, p[0])) {
                return 100;
            }
            return 100 + GermanNumeral.parse99(s, p);
        }
        int i = 2;
        while (i < 10) {
            if (GermanNumeral.match(s, NUMERAL1[i], p[0])) {
                r = i;
                p[0] = p[0] + NUMERAL1[i].length();
                if (GermanNumeral.isEnd(s, p[0])) {
                    p[0] = p[0] - NUMERAL1[i].length();
                    break;
                }
                if (GermanNumeral.match(s, "hundert", p[0])) {
                    p[0] = p[0] + 7;
                    if (GermanNumeral.isEnd(s, p[0])) {
                        return r * 100;
                    }
                    return r * 100 + GermanNumeral.parse99(s, p);
                }
                p[0] = p[0] - NUMERAL1[i].length();
                break;
            }
            ++i;
        }
        return GermanNumeral.parse99(s, p);
    }

    static int parse999999(String s, int[] p) {
        if (GermanNumeral.match(s, "tausend", p[0])) {
            p[0] = p[0] + 7;
            return 1000 + GermanNumeral.parse999(s, p);
        }
        int r = GermanNumeral.parse999(s, p);
        if (GermanNumeral.isEnd(s, p[0])) {
            return r;
        }
        if (r > 1 && GermanNumeral.match(s, "tausend", p[0])) {
            p[0] = p[0] + 7;
            if (GermanNumeral.isEnd(s, p[0])) {
                return r * 1000;
            }
            return r * 1000 + GermanNumeral.parse999(s, p);
        }
        throw new NumberFormatException();
    }

    public static BigInteger parseNumber(String s) {
        BigInteger r = BigInteger.ZERO;
        BigInteger b = null;
        int[] p = new int[1];
        if (s == null) {
            throw new NullPointerException();
        }
        String[] sp = s.split("[ \t\n]+");
        if (sp.length == 0) {
            throw new NumberFormatException();
        }
        if (s.equals("null")) {
            return BigInteger.ZERO;
        }
        if (s.equals("eins")) {
            return BigInteger.ONE;
        }
        int i = 0;
        while (true) {
            BigInteger t;
            if (i >= sp.length) {
                if (i == 0) {
                    throw new NumberFormatException();
                }
                return r;
            }
            if (sp[i].equals("eine")) {
                if (i + 1 >= sp.length) {
                    throw new NumberFormatException();
                }
                t = GermanNumeral.matchMillion(sp[i + 1]);
                if (t != null) {
                    if (b != null && b.compareTo(t) <= 0) {
                        throw new NumberFormatException();
                    }
                    b = t;
                    r = r.add(t);
                    i += 2;
                    continue;
                }
                throw new NumberFormatException();
            }
            if (i + 1 >= sp.length) {
                p[0] = 0;
                r = r.add(BigInteger.valueOf(GermanNumeral.parse999999(sp[i], p)));
                return r;
            }
            t = GermanNumeral.matchMillionPlural(sp[i + 1]);
            if (t == null) break;
            if (b != null && b.compareTo(t) <= 0) {
                throw new NumberFormatException();
            }
            b = t;
            p[0] = 0;
            int v = GermanNumeral.parse999(sp[i], p);
            if (v == 1) {
                throw new NumberFormatException();
            }
            r = r.add(t.multiply(BigInteger.valueOf(v)));
            i += 2;
        }
        throw new NumberFormatException();
    }
}

