/*
 * Decompiled with CFR 0.152.
 */
package net.morilib.lingua;

public final class LatinUtils {
    public static String normalizeClassic(String s) {
        String t = s;
        t = t.replace('u', 'V');
        t = t.replace('j', 'I');
        t = t.replace('U', 'V');
        t = t.replace('J', 'I');
        t = t.replaceAll("W", "VV");
        t = t.replaceAll("w", "VV");
        return t.toUpperCase();
    }

    public static String normalizeModern(String s) {
        String t = s;
        t = t.replace('i', 'j');
        t = t.replace('I', 'J');
        t = t.replace('u', 'v');
        t = t.replace('U', 'V');
        t = t.replaceAll("W", "VV");
        t = t.replaceAll("VV([a-z])", "Vv$1");
        t = t.replaceFirst("^([A-Za-z]*[a-z][A-Za-z]*)VV$", "$1Vv");
        t = t.replaceAll("w", "vv");
        t = t.replaceFirst("^([aejovAEJOV])v", "$1u");
        t = t.replaceFirst("^([AEJOV])V", "$1U");
        t = t.replaceFirst("^([aejouAEJOU])j", "$1i");
        t = t.replaceFirst("^([AEJOU])J", "$1I");
        t = t.replaceAll("([^a-zA-Z][aejovAEJOV])v", "$1u");
        t = t.replaceAll("([^A-Z][AEJOV])V", "$1U");
        t = t.replaceAll("([^a-zA-Z][aejouAEJOU])j", "$1i");
        t = t.replaceAll("([^A-Z][AEJOU])J", "$1I");
        t = t.replaceAll("([bcdfghkjlmnpqrstvxyzBCDFGHJKLMNPQRSTVXYZ])v", "$1u");
        t = t.replaceAll("([BCDFGHJKLMNPQRSTVXYZ])V", "$1U");
        t = t.replaceAll("([bcdfghkjlmnpqrstvxyzBCDFGHJKLMNPQRSTVXYZ])j", "$1i");
        t = t.replaceAll("([BCDFGHJKLMNPQRSTVXYZ])J", "$1I");
        t = t.replaceAll("v([bcdfghkjlmnpqrstvxyz])", "u$1");
        t = t.replaceAll("V([BCDFGHJKLMNPQRSTVXYZ])", "U$1");
        return t;
    }

    static String normalizeClassicWithCase(String s) {
        String t = s;
        t = t.replace('u', 'v');
        t = t.replace('j', 'i');
        t = t.replace('U', 'V');
        t = t.replace('J', 'I');
        t = t.replaceAll("W", "VV");
        t = t.replaceAll("VV([a-z])", "Vv$1");
        t = t.replaceFirst("^([A-Za-z]*[a-z][A-Za-z]*)VV$", "$1Vv");
        t = t.replaceAll("w", "vv");
        return t;
    }

    public static boolean equalsAsLatin(String s, String t) {
        return s != null && t != null && LatinUtils.normalizeClassicWithCase(s).equals(LatinUtils.normalizeClassicWithCase(t));
    }

    public static boolean equalsIgnoreCaseAsLatin(String s, String t) {
        String a = s.toUpperCase();
        String b = t.toUpperCase();
        if (a == null || b == null) {
            return false;
        }
        a = a.replace('U', 'V');
        a = a.replace('J', 'I');
        a = a.replaceAll("W", "VV");
        b = b.replace('U', 'V');
        b = b.replace('J', 'I');
        b = b.replaceAll("W", "VV");
        return a.equals(b);
    }
}

